/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.playerquest;

import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.playerquest.PlayerQuestMenu;
import com.shengchanshe.chang_sheng_jue.network.ChangShengJueMessages;
import com.shengchanshe.chang_sheng_jue.network.packet.gui.playerquest.AbandonPlayerQuestPacket;
import com.shengchanshe.chang_sheng_jue.network.packet.gui.playerquest.SubmitPlayerQuestsPacket;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import com.shengchanshe.chang_sheng_jue.util.GuiEntityGraphics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class PlayerQuestScreen
extends AbstractContainerScreen<PlayerQuestMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("chang_sheng_jue", "textures/gui/container/player_quests.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int SLOT_SIZE = 18;
    private static final int REQ_SLOTS_X = 18;
    private static final int REQ_SLOTS_Y = 95;
    private static final int REWARD_SLOTS_Y = 99;
    private static final int BUTTON_WIDTH = 89;
    private static final int BUTTON_HEIGHT = 17;
    private static final int BUTTON_SPACING = 50;
    private static final int ARROW_BUTTON_WIDTH = 7;
    private static final int ARROW_BUTTON_HEIGHT = 11;
    private static final int ARROW_BUTTON_SPACING = 78;
    private static final int HEAD_SIZE = 9;
    private static final int MAX_VISIBLE_HEADS = 5;
    private static final Map<EntityType<?>, Entity> ENTITY_CACHE = new HashMap();
    private int scrollTick = 0;
    private TexturedButtonWithLabel peviousButton;
    private TexturedButtonWithLabel nextButton;
    private TexturedButtonWithLabel actionButton;
    private TexturedButtonWithLabel cancelButton;

    public PlayerQuestScreen(PlayerQuestMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 255;
        this.f_97727_ = 165;
    }

    protected void m_7856_() {
        super.m_7856_();
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        int arrowButtonY = top + 18 - 5;
        int arrowButtonX = left + (this.f_97726_ - 92) / 2;
        int buttonY = top + 99 + 31;
        int buttonX = left + (this.f_97726_ - 228) / 2;
        this.peviousButton = (TexturedButtonWithLabel)this.m_142416_((GuiEventListener)new TexturedButtonWithLabel(arrowButtonX - 78 + 15, arrowButtonY, 7, 11, 7, 202, 11, TEXTURE, 256, 256, button -> ((PlayerQuestMenu)this.f_97732_).prevPage(), (Component)Component.m_237119_()));
        this.nextButton = (TexturedButtonWithLabel)this.m_142416_((GuiEventListener)new TexturedButtonWithLabel(arrowButtonX + 7 + 156 - 15, arrowButtonY, 7, 11, 0, 202, 11, TEXTURE, 256, 256, button -> ((PlayerQuestMenu)this.f_97732_).nextPage(), (Component)Component.m_237119_()));
        this.actionButton = (TexturedButtonWithLabel)this.m_142416_((GuiEventListener)new TexturedButtonWithLabel(buttonX, buttonY, 89, 17, 0, 167, 17, TEXTURE, 256, 256, button -> ((PlayerQuestMenu)this.m_6262_()).getCurrentQuest(((PlayerQuestMenu)this.m_6262_()).getCurrentPage()).ifPresentOrElse(quest -> ChangShengJueMessages.sendToServer(new SubmitPlayerQuestsPacket(quest.getQuestId(), ((PlayerQuestMenu)this.m_6262_()).getCurrentPage())), () -> {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"quest.chang_sheng_jue.no_submit.button"), false);
            }
        }), (Component)Component.m_237115_((String)"quest.chang_sheng_jue.submit.button")));
        this.cancelButton = (TexturedButtonWithLabel)this.m_142416_((GuiEventListener)new TexturedButtonWithLabel(buttonX + 89 + 50, buttonY, 89, 17, 0, 167, 17, TEXTURE, 256, 256, button -> ((PlayerQuestMenu)this.m_6262_()).getCurrentQuest(((PlayerQuestMenu)this.m_6262_()).getCurrentPage()).ifPresentOrElse(quest -> ChangShengJueMessages.sendToServer(new AbandonPlayerQuestPacket(quest.getQuestId(), ((PlayerQuestMenu)this.m_6262_()).getCurrentPage())), () -> {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"quest.chang_sheng_jue.no_abandon.button"), false);
            }
        }), (Component)Component.m_237115_((String)"quest.chang_sheng_jue.abandon.button")));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        ((PlayerQuestMenu)this.f_97732_).getCurrentQuest(((PlayerQuestMenu)this.m_6262_()).getCurrentPage()).ifPresent(quest -> {
            int requirementsTitleWidth = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"quest.chang_sheng_jue.requirements"));
            int descriptionStartX = x + 18 + requirementsTitleWidth + 5;
            int rewardsTitleWidth = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"quest.chang_sheng_jue.rewards"));
            int rewardsDescriptionStartX = x + 18 + rewardsTitleWidth + 5;
            List<ItemStack> reqs = quest.getQuestRequirements();
            for (int i = 0; i < Math.min(3, reqs.size()); ++i) {
                ItemStack stack = reqs.get(i);
                this.renderItemAt(guiGraphics, descriptionStartX + i * 18, y + 95 - 8, stack);
            }
            List<ItemStack> rewards = quest.getQuestRewards();
            for (int i = 0; i < Math.min(6, rewards.size()); ++i) {
                ItemStack stack = rewards.get(i);
                this.renderItemAt(guiGraphics, rewardsDescriptionStartX + i * 18, y + 99 + 8, stack);
            }
            if (!quest.getTargetEntity().isEmpty()) {
                GuiEntityGraphics.getInstance(this.f_96547_, 9, 5, ENTITY_CACHE).renderKillTargetHead(guiGraphics, descriptionStartX, y + 95, quest.getTargetEntity(), quest.getCurrentKills(), quest.getRequiredKills());
                if (quest.getSecondTargetEntity() != null && !quest.getSecondTargetEntity().isEmpty()) {
                    GuiEntityGraphics.getInstance(this.f_96547_, 9, 5, ENTITY_CACHE).renderKillTargetHead(guiGraphics, descriptionStartX + 15, y + 95, quest.getSecondTargetEntity(), quest.getSecondCurrentKills(), quest.getSecondRequiredKills());
                }
            }
            this.renderTooltips(guiGraphics, mouseX, mouseY, x, y, (Quest)quest);
        });
    }

    private void renderItemAt(GuiGraphics guiGraphics, int x, int y, ItemStack stack) {
        guiGraphics.m_280480_(stack, x, y);
        guiGraphics.m_280370_(this.f_96547_, stack, x, y);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280163_(TEXTURE, x, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
        int currentPage = ((PlayerQuestMenu)this.f_97732_).getCurrentPage() + 1;
        String pageInfo = String.format("%d/%d", currentPage, ((PlayerQuestMenu)this.f_97732_).getTotalPages());
        guiGraphics.m_280056_(this.f_96547_, pageInfo, x + this.f_97726_ - (currentPage >= 10 ? 35 : 30), y + 150, 0x404040, false);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Optional<Quest> currentQuest = ((PlayerQuestMenu)this.f_97732_).getCurrentQuest(((PlayerQuestMenu)this.m_6262_()).getCurrentPage());
        if (currentQuest.isPresent()) {
            Quest quest = currentQuest.get();
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)quest.getQuestName()), (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)quest.getQuestName()))) / 2, 14, 0x404040, false);
            List lines = this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)quest.getQuestDescription()), this.f_97726_ - 45);
            for (int i = 0; i < lines.size(); ++i) {
                int descX = i == 0 ? 37 : 20;
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(i);
                Objects.requireNonNull(this.f_96547_);
                guiGraphics.m_280649_(this.f_96547_, formattedCharSequence, descX, 35 + i * 9, 0x404040, false);
            }
            int requirementsTitleWidth = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"quest.chang_sheng_jue.requirements"));
            int descriptionStartX = 18 + requirementsTitleWidth + (quest.getSecondTargetEntity() != null && !quest.getSecondTargetEntity().isEmpty() ? 30 : (quest.getTargetEntity() != null && !quest.getTargetEntity().isEmpty() ? 20 : 5));
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"quest.chang_sheng_jue.requirements"), 18, 91, ChatFormatting.RED.m_126665_().intValue(), false);
            String requirementsText = quest.getQuestRequirementsDescription();
            MutableComponent fullDescriptionComponent = Component.m_237115_((String)requirementsText);
            int fullTextWidth = this.f_96547_.m_92852_((FormattedText)fullDescriptionComponent);
            int maxAvailableWidth = this.f_97726_ - 50 - descriptionStartX;
            if (fullTextWidth > maxAvailableWidth && maxAvailableWidth > 0) {
                ++this.scrollTick;
                String visibleText = this.getString((Component)fullDescriptionComponent);
                guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)visibleText), descriptionStartX, 91, ChatFormatting.RED.m_126665_().intValue(), false);
            } else {
                List lines1 = this.f_96547_.m_92923_((FormattedText)fullDescriptionComponent, this.f_97726_ - 50);
                for (int i = 0; i < lines1.size(); ++i) {
                    FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines1.get(i);
                    Objects.requireNonNull(this.f_96547_);
                    guiGraphics.m_280649_(this.f_96547_, formattedCharSequence, descriptionStartX, 91 + i * 9, ChatFormatting.RED.m_126665_().intValue(), false);
                }
            }
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"quest.chang_sheng_jue.rewards"), 18, 112, ChatFormatting.YELLOW.m_126665_().intValue(), false);
        } else {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"quest.chang_sheng_jue.no_quest"), (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"quest.chang_sheng_jue.no_quest"))) / 2, 35, ChatFormatting.RED.m_126665_().intValue(), true);
        }
    }

    @NotNull
    private String getString(Component requirementsText) {
        Object visibleText;
        int scrollSpeed = 15;
        int visibleChars = Math.min(30, requirementsText.getString().length());
        String textWithSpacing = requirementsText.getString() + "    ";
        int totalLength = textWithSpacing.length();
        int startPos = this.scrollTick / scrollSpeed % totalLength;
        if (startPos + visibleChars <= totalLength) {
            visibleText = textWithSpacing.substring(startPos, startPos + visibleChars);
        } else {
            int part1Length = totalLength - startPos;
            int part2Length = visibleChars - part1Length;
            visibleText = textWithSpacing.substring(startPos) + textWithSpacing.substring(0, part2Length);
        }
        return visibleText;
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, Quest quest) {
        int requirementsTitleWidth = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"quest.chang_sheng_jue.requirements"));
        int descriptionStartX = x + 18 + requirementsTitleWidth + 5;
        int rewardsTitleWidth = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"quest.chang_sheng_jue.rewards"));
        int rewardsDescriptionStartX = x + 18 + rewardsTitleWidth + 5;
        List<ItemStack> reqs = quest.getQuestRequirements();
        for (int i = 0; i < Math.min(3, reqs.size()); ++i) {
            if (!this.isMouseOverSlot(mouseX, mouseY, descriptionStartX + i * 18, y + 95 - 8, 18, 18)) continue;
            guiGraphics.m_280153_(this.f_96547_, reqs.get(i), mouseX, mouseY);
            return;
        }
        List<ItemStack> rewards = quest.getQuestRewards();
        for (int i = 0; i < Math.min(3, rewards.size()); ++i) {
            if (!this.isMouseOverSlot(mouseX, mouseY, rewardsDescriptionStartX + i * 18, y + 99 + 8, 18, 18)) continue;
            guiGraphics.m_280153_(this.f_96547_, rewards.get(i), mouseX, mouseY);
            return;
        }
    }

    private boolean isMouseOverSlot(int mouseX, int mouseY, int slotX, int slotY, int width, int height) {
        return mouseX >= slotX && mouseX <= slotX + width && mouseY >= slotY && mouseY <= slotY + height;
    }

    public void refreshUI() {
        this.m_169413_();
        this.f_169369_.clear();
        ((PlayerQuestMenu)this.f_97732_).refreshQuests();
        ((PlayerQuestMenu)this.f_97732_).adjustPageAfterQuestRemoval();
        ((PlayerQuestMenu)this.f_97732_).refreshQuests();
        this.m_7856_();
        this.m_267719_();
    }

    public static class TexturedButtonWithLabel
    extends ImageButton {
        private Component label;

        public TexturedButtonWithLabel(int x, int y, int width, int height, int texX, int texY, int yDiffText, ResourceLocation resource, int texWidth, int texHeight, Button.OnPress onPress, Component label) {
            super(x, y, width, height, texX, texY, yDiffText, resource, texWidth, texHeight, onPress);
            this.label = label;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
            Font font = Minecraft.m_91087_().f_91062_;
            int textWidth = font.m_92852_((FormattedText)this.label);
            int textX = this.m_252754_() + (this.f_93618_ - textWidth) / 2;
            int textY = this.m_252907_() + (this.f_93619_ - 8) / 2;
            guiGraphics.m_280614_(font, this.label, textX, textY, this.f_93623_ ? 0xFFFFFF : 0xA0A0A0, true);
        }
    }
}

