/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.worker;

import com.mojang.blaze3d.systems.RenderSystem;
import com.shengchanshe.chang_sheng_jue.block.ChangShengJueBlocks;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.button.TexturedButtonWithText;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.worker.KilnWorkerMenu;
import com.shengchanshe.chang_sheng_jue.network.ChangShengJueMessages;
import com.shengchanshe.chang_sheng_jue.network.packet.gui.KilnWorkerSetTradeTypePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KilnWorkerScreen
extends AbstractContainerScreen<KilnWorkerMenu> {
    private static final ResourceLocation VILLAGER_LOCATION = new ResourceLocation("chang_sheng_jue", "textures/gui/container/worker_trading.png");
    private static final ResourceLocation BOTTON = new ResourceLocation("chang_sheng_jue", "textures/gui/botton.png");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 512;
    private static final int MERCHANT_MENU_PART_X = 99;
    private static final int PROGRESS_BAR_X = 136;
    private static final int PROGRESS_BAR_Y = 59;
    private static final int SELL_ITEM_1_X = 5;
    private static final int SELL_ITEM_2_X = 35;
    private static final int BUY_ITEM_X = 68;
    private static final int LABEL_Y = 6;
    private static final int NUMBER_OF_OFFER_BUTTONS = 7;
    private static final int TRADE_BUTTON_X = 7;
    private static final int TRADE_BUTTON_HEIGHT = 20;
    private static final int TRADE_BUTTON_WIDTH = 87;
    private static final int SCROLLER_HEIGHT = 27;
    private static final int SCROLLER_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 139;
    private static final int SCROLL_BAR_TOP_POS_Y = 61;
    private static final int SCROLL_BAR_START_X = 95;
    private static final Component TRADES_LABEL = Component.m_237115_((String)"merchant.trades");
    private static final Component LEVEL_SEPARATOR = Component.m_237113_((String)" - ");
    private static final Component DEPRECATED_TOOLTIP = Component.m_237115_((String)"merchant.deprecated");
    private int shopItem;
    private final TradeOfferButton[] tradeOfferButtons = new TradeOfferButton[7];
    int scrollOff;
    private boolean isDragging;
    private TradeType currentTradeType = TradeType.GRE;
    private ImageButton greButton;
    private ImageButton redButton;
    private ImageButton blackButton;
    private ImageButton blueButton;
    private ImageButton goldenButton;

    public KilnWorkerScreen(KilnWorkerMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 276;
        this.f_97727_ = 209;
        this.f_97730_ = 107;
        this.f_97731_ = this.f_97727_ - 94;
    }

    private void postButtonClick() {
        ((KilnWorkerMenu)this.f_97732_).setSelectionHint(this.shopItem);
        ((KilnWorkerMenu)this.f_97732_).tryMoveItems(this.shopItem);
        this.f_96541_.m_91403_().m_104955_((Packet)new ServerboundSelectTradePacket(this.shopItem));
    }

    protected void m_7856_() {
        super.m_7856_();
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        int buttonY = top + 59 + 2;
        for (int i = 0; i < 7; ++i) {
            this.tradeOfferButtons[i] = (TradeOfferButton)this.m_142416_((GuiEventListener)new TradeOfferButton(left + 7, buttonY, i, button -> {
                if (button instanceof TradeOfferButton) {
                    this.shopItem = ((TradeOfferButton)button).getIndex() + this.scrollOff;
                    this.postButtonClick();
                }
            }));
            buttonY += 20;
        }
        this.greButton = ((TexturedButtonWithText)this.m_142416_((GuiEventListener)new TexturedButtonWithText(left - 32, top + 48, 35, 25, 0, 0, 25, BOTTON, 256, 256, button -> {
            this.setCurrentTradeType(TradeType.GRE);
            this.sendTradeTypeUpdate(TradeType.GRE);
        }, (Component)Component.m_237115_((String)"button.chang_sheng_jue.gre_button.tips"), 0, 0, 1.0f, 1.0f, 1.0f, 1.0f).setItemIcon(new ItemStack((ItemLike)ChangShengJueBlocks.GRE_CYLINDER_TILE_BLOCK_2.get())))).setItemIconPosition(TexturedButtonWithText.IconPosition.CENTER).setItemIconScale(1.2f);
        this.redButton = ((TexturedButtonWithText)this.m_142416_((GuiEventListener)new TexturedButtonWithText(left - 32, top + 48 + 25, 35, 25, 0, 0, 25, BOTTON, 256, 256, button -> {
            this.setCurrentTradeType(TradeType.RED);
            this.sendTradeTypeUpdate(TradeType.RED);
        }, (Component)Component.m_237115_((String)"button.chang_sheng_jue.red_button.tips"), 0, 0, 1.0f, 1.0f, 1.0f, 1.0f).setItemIcon(new ItemStack((ItemLike)ChangShengJueBlocks.RED_CYLINDER_TILE_BLOCK_2.get())))).setItemIconPosition(TexturedButtonWithText.IconPosition.CENTER).setItemIconScale(1.2f);
        this.blackButton = ((TexturedButtonWithText)this.m_142416_((GuiEventListener)new TexturedButtonWithText(left - 32, top + 48 + 50, 35, 25, 0, 0, 25, BOTTON, 256, 256, button -> {
            this.setCurrentTradeType(TradeType.BLACK);
            this.sendTradeTypeUpdate(TradeType.BLACK);
        }, (Component)Component.m_237115_((String)"button.chang_sheng_jue.black_button.tips"), 0, 0, 1.0f, 1.0f, 1.0f, 1.0f).setItemIcon(new ItemStack((ItemLike)ChangShengJueBlocks.BLACK_CYLINDER_TILE_BLOCK_2.get())))).setItemIconPosition(TexturedButtonWithText.IconPosition.CENTER).setItemIconScale(1.2f);
        this.blueButton = ((TexturedButtonWithText)this.m_142416_((GuiEventListener)new TexturedButtonWithText(left - 32, top + 48 + 75, 35, 25, 0, 0, 25, BOTTON, 256, 256, button -> {
            this.setCurrentTradeType(TradeType.BLUE);
            this.sendTradeTypeUpdate(TradeType.BLUE);
        }, (Component)Component.m_237115_((String)"button.chang_sheng_jue.blue_button.tips"), 0, 0, 1.0f, 1.0f, 1.0f, 1.0f).setItemIcon(new ItemStack((ItemLike)ChangShengJueBlocks.BLUE_CYLINDER_TILE_BLOCK_2.get())))).setItemIconPosition(TexturedButtonWithText.IconPosition.CENTER).setItemIconScale(1.2f);
        this.goldenButton = ((TexturedButtonWithText)this.m_142416_((GuiEventListener)new TexturedButtonWithText(left - 32, top + 48 + 100, 35, 25, 0, 0, 25, BOTTON, 256, 256, button -> {
            this.setCurrentTradeType(TradeType.GOLDEN);
            this.sendTradeTypeUpdate(TradeType.GOLDEN);
        }, (Component)Component.m_237115_((String)"button.chang_sheng_jue.golden_button.tips"), 0, 0, 1.0f, 1.0f, 1.0f, 1.0f).setItemIcon(new ItemStack((ItemLike)ChangShengJueBlocks.GOLDEN_CYLINDER_TILE_BLOCK_2.get())))).setItemIconPosition(TexturedButtonWithText.IconPosition.CENTER).setItemIconScale(1.2f);
        this.goldenButton = ((TexturedButtonWithText)this.m_142416_((GuiEventListener)new TexturedButtonWithText(left - 32, top + 48 + 125, 35, 25, 0, 0, 25, BOTTON, 256, 256, button -> {
            this.setCurrentTradeType(TradeType.WOOD);
            this.sendTradeTypeUpdate(TradeType.WOOD);
        }, (Component)Component.m_237115_((String)"button.chang_sheng_jue.wood_button.tips"), 0, 0, 1.0f, 1.0f, 1.0f, 1.0f).setItemIcon(new ItemStack((ItemLike)ChangShengJueBlocks.OAK_BALUSTRADE.get())))).setItemIconPosition(TexturedButtonWithText.IconPosition.CENTER).setItemIconScale(1.2f);
    }

    private void sendTradeTypeUpdate(TradeType tradeType) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            ChangShengJueMessages.sendToServer(new KilnWorkerSetTradeTypePacket(tradeType));
        }
    }

    private void refreshTradeOffers() {
        MerchantOffers offers = ((KilnWorkerMenu)this.f_97732_).getOffers();
        if (offers != null) {
            this.shopItem = 0;
            this.scrollOff = 0;
            for (TradeOfferButton button : this.tradeOfferButtons) {
                button.f_93624_ = false;
            }
        }
    }

    public void setCurrentTradeType(TradeType currentTradeType) {
        this.currentTradeType = currentTradeType;
        this.refreshTradeOffers();
    }

    protected void m_280003_(GuiGraphics transform, int x, int y) {
        boolean isChinese = Minecraft.m_91087_().f_91066_.f_92075_.startsWith("zh_");
        if (!isChinese) {
            int level = ((KilnWorkerMenu)this.f_97732_).getTraderLevel();
            if (level > 0 && level <= 5 && ((KilnWorkerMenu)this.f_97732_).showProgressBar()) {
                MutableComponent component = this.f_96539_.m_6881_().m_7220_(LEVEL_SEPARATOR).m_7220_((Component)Component.m_237115_((String)("merchant.level." + level)));
                int fontWidth = this.f_96547_.m_92852_((FormattedText)component);
                int k = 49 + this.f_97726_ / 2 - fontWidth / 2;
                transform.m_280614_(this.f_96547_, (Component)component, k, 6, 0x404040, false);
            } else {
                transform.m_280614_(this.f_96547_, this.f_96539_, 49 + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 48, 0x404040, false);
            }
        }
        transform.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
        int l = this.f_96547_.m_92852_((FormattedText)TRADES_LABEL);
        transform.m_280614_(this.f_96547_, TRADES_LABEL, 5 - l / 2 + 48, 48, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics transform, float partialTicks, int x, int y) {
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        transform.m_280398_(VILLAGER_LOCATION, left, top, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 512);
        MerchantOffers merchantoffers = ((KilnWorkerMenu)this.f_97732_).getOffers();
        if (!merchantoffers.isEmpty()) {
            int k = this.shopItem;
            if (k < 0 || k >= merchantoffers.size()) {
                return;
            }
            MerchantOffer merchantoffer = (MerchantOffer)merchantoffers.get(k);
            if (merchantoffer.m_45380_()) {
                transform.m_280398_(VILLAGER_LOCATION, this.f_97735_ + 83 + 99, this.f_97736_ + 35, 0, 311.0f, 0.0f, 28, 21, 512, 512);
            }
        }
    }

    private void renderProgressBar(GuiGraphics transform, int x, int y) {
        int level = ((KilnWorkerMenu)this.f_97732_).getTraderLevel();
        int xp = ((KilnWorkerMenu)this.f_97732_).getTraderXp();
        if (level < 5) {
            transform.m_280398_(VILLAGER_LOCATION, x + 136, y + 59, 0, 0.0f, 186.0f, 102, 5, 512, 512);
            int k = 15;
            if (xp >= k && level > 1) {
                float f = 100.0f / (float)(300 - k);
                int progress = Math.min(Mth.m_14143_((float)(f * (float)(xp - k))), 100);
                transform.m_280398_(VILLAGER_LOCATION, x + 136, y + 59, 0, 0.0f, 191.0f, progress + 1, 5, 512, 512);
                int addXp = ((KilnWorkerMenu)this.f_97732_).getFutureTraderXp();
                if (addXp > 0) {
                    int addProgress = Math.min(Mth.m_14143_((float)((float)addXp * f)), 100 - progress);
                    transform.m_280398_(VILLAGER_LOCATION, x + 136 + progress + 1, y + 59 + 1, 0, 2.0f, 182.0f, addProgress, 3, 512, 512);
                }
            }
        }
    }

    private void renderScroller(GuiGraphics transform, int x, int y, MerchantOffers offers) {
        int overSize = offers.size() + 1 - 7;
        if (overSize > 1) {
            int scrollableRange = 112;
            float scrollProgress = (float)this.scrollOff / (float)(overSize - 1);
            int scrollY = (int)(scrollProgress * (float)scrollableRange);
            scrollY = Mth.m_14045_((int)scrollY, (int)0, (int)scrollableRange);
            transform.m_280398_(VILLAGER_LOCATION, x + 95, y + 61 + scrollY, 0, 0.0f, 210.0f, 6, 27, 512, 512);
        } else {
            transform.m_280398_(VILLAGER_LOCATION, x + 95, y + 61, 0, 6.0f, 210.0f, 6, 27, 512, 512);
        }
    }

    public void m_88315_(GuiGraphics transform, int x, int y, float partialTicks) {
        this.m_280273_(transform);
        super.m_88315_(transform, x, y, partialTicks);
        MerchantOffers merchantoffers = ((KilnWorkerMenu)this.f_97732_).getOffers();
        if (!merchantoffers.isEmpty()) {
            int left = (this.f_96543_ - this.f_97726_) / 2;
            int top = (this.f_96544_ - this.f_97727_) / 2;
            int merchantY = top + 59 + 1;
            int costAX = left + 7 + 5;
            this.renderScroller(transform, left, top, merchantoffers);
            int index = 0;
            for (MerchantOffer merchantoffer : merchantoffers) {
                if (!this.canScroll(merchantoffers.size()) || index >= this.scrollOff && index < 7 + this.scrollOff) {
                    ItemStack baseCostA = merchantoffer.m_45352_();
                    ItemStack costA = merchantoffer.m_45358_();
                    ItemStack costB = merchantoffer.m_45364_();
                    ItemStack result = merchantoffer.m_45368_();
                    transform.m_280168_().m_85836_();
                    transform.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
                    int itemY = merchantY + 2;
                    this.renderAndDecorateCostA(transform, costA, baseCostA, costAX, itemY);
                    if (!costB.m_41619_()) {
                        transform.m_280203_(costB, left + 5 + 35, itemY);
                        transform.m_280370_(this.f_96547_, costB, left + 5 + 35, itemY);
                    }
                    this.renderButtonArrows(transform, merchantoffer, left, itemY);
                    transform.m_280203_(result, left + 5 + 68, itemY);
                    transform.m_280370_(this.f_96547_, result, left + 5 + 68, itemY);
                    transform.m_280168_().m_85849_();
                    merchantY += 20;
                }
                ++index;
            }
            MerchantOffer currentOffer = (MerchantOffer)merchantoffers.get(this.shopItem);
            if (((KilnWorkerMenu)this.f_97732_).showProgressBar()) {
                this.renderProgressBar(transform, left, top);
            }
            if (currentOffer.m_45380_() && this.m_6774_(186, 35, 22, 21, x, y) && ((KilnWorkerMenu)this.f_97732_).canRestock()) {
                transform.m_280557_(this.f_96547_, DEPRECATED_TOOLTIP, x, y);
            }
            for (TradeOfferButton tradeOfferButton : this.tradeOfferButtons) {
                if (tradeOfferButton.m_198029_()) {
                    tradeOfferButton.renderToolTip(transform, x, y);
                }
                tradeOfferButton.f_93624_ = tradeOfferButton.index < ((KilnWorkerMenu)this.f_97732_).getOffers().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.m_280072_(transform, x, y);
    }

    private void renderButtonArrows(GuiGraphics transform, MerchantOffer offer, int x, int y) {
        if (offer.m_45380_()) {
            transform.m_280398_(VILLAGER_LOCATION, x + 5 + 35 + 20, y + 3, 0, 10.0f, 238.0f, 10, 9, 512, 512);
        } else {
            transform.m_280398_(VILLAGER_LOCATION, x + 5 + 35 + 20, y + 3, 0, 0.0f, 238.0f, 10, 9, 512, 512);
        }
    }

    private void renderAndDecorateCostA(GuiGraphics transform, ItemStack baseCostA, ItemStack costA, int x, int y) {
        transform.m_280203_(baseCostA, x, y);
        if (costA.m_41613_() == baseCostA.m_41613_()) {
            transform.m_280370_(this.f_96547_, baseCostA, x, y);
        } else {
            transform.m_280302_(this.f_96547_, costA, x, y, costA.m_41613_() == 1 ? "1" : null);
            transform.m_280168_().m_85836_();
            transform.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            String count = baseCostA.m_41613_() == 1 ? "1" : String.valueOf(baseCostA.m_41613_());
            this.f_96547_.m_272078_(count, (float)(x + 14) + 19.0f - 2.0f - (float)this.f_96547_.m_92895_(count), (float)(y + 6) + 3.0f, 0xFFFFFF, true, transform.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)transform.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0, false);
            transform.m_280168_().m_85849_();
            transform.m_280168_().m_85836_();
            transform.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
            transform.m_280398_(VILLAGER_LOCATION, x + 7, y + 12, 0, 0.0f, 286.0f, 9, 2, 512, 512);
            transform.m_280168_().m_85849_();
        }
    }

    private boolean canScroll(int size) {
        return size > 7;
    }

    public boolean m_6050_(double x, double y, double delta) {
        int size = ((KilnWorkerMenu)this.f_97732_).getOffers().size();
        if (this.canScroll(size)) {
            int overSize = size - 7;
            this.scrollOff = Mth.m_14045_((int)((int)((double)this.scrollOff - delta)), (int)0, (int)overSize);
        }
        return true;
    }

    public boolean m_7979_(double fromX, double fromY, int activeButton, double toX, double toY) {
        int size = ((KilnWorkerMenu)this.f_97732_).getOffers().size();
        if (this.isDragging) {
            int scrollTop = this.f_97736_ + 61;
            int overSize = size - 7;
            if (overSize > 0) {
                float relativeY = (float)(fromY - (double)scrollTop - 13.5);
                float scrollableHeight = 112.0f;
                float scrollProgress = Mth.m_14036_((float)(relativeY / scrollableHeight), (float)0.0f, (float)1.0f);
                this.scrollOff = (int)(scrollProgress * (float)overSize);
                this.scrollOff = Mth.m_14045_((int)this.scrollOff, (int)0, (int)overSize);
            }
            return true;
        }
        return super.m_7979_(fromX, fromY, activeButton, toX, toY);
    }

    public boolean m_6375_(double x, double y, int mouseButton) {
        this.isDragging = false;
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        if (this.canScroll(((KilnWorkerMenu)this.f_97732_).getOffers().size()) && x > (double)(left + 95) && x < (double)(left + 95 + 6) && y > (double)(top + 61) && y <= (double)(top + 61 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.m_6375_(x, y, mouseButton);
    }

    @OnlyIn(value=Dist.CLIENT)
    class TradeOfferButton
    extends Button {
        final int index;

        public TradeOfferButton(int x, int y, int index, Button.OnPress onPress) {
            super(x, y, 87, 20, CommonComponents.f_237098_, onPress, f_252438_);
            this.index = index;
            this.f_93624_ = false;
        }

        public int getIndex() {
            return this.index;
        }

        protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            Minecraft minecraft = Minecraft.m_91087_();
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            pGuiGraphics.m_280027_(BOTTON, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, this.m_274533_());
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            int i = this.getFGColor();
            this.m_280139_(pGuiGraphics, minecraft.f_91062_, i | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        }

        private int m_274533_() {
            int i = 1;
            if (!this.f_93623_) {
                i = 0;
            } else if (this.m_198029_()) {
                i = 2;
            }
            return 46 + i * 20;
        }

        public void renderToolTip(GuiGraphics transform, int x, int y) {
            if (this.f_93622_ && ((KilnWorkerMenu)KilnWorkerScreen.this.f_97732_).getOffers().size() > this.index + KilnWorkerScreen.this.scrollOff) {
                if (x < this.m_252754_() + 20) {
                    ItemStack itemstack = ((MerchantOffer)((KilnWorkerMenu)KilnWorkerScreen.this.f_97732_).getOffers().get(this.index + KilnWorkerScreen.this.scrollOff)).m_45358_();
                    transform.m_280153_(KilnWorkerScreen.this.f_96547_, itemstack, x, y);
                } else if (x < this.m_252754_() + 50 && x > this.m_252754_() + 30) {
                    ItemStack itemstack2 = ((MerchantOffer)((KilnWorkerMenu)KilnWorkerScreen.this.f_97732_).getOffers().get(this.index + KilnWorkerScreen.this.scrollOff)).m_45364_();
                    if (!itemstack2.m_41619_()) {
                        transform.m_280153_(KilnWorkerScreen.this.f_96547_, itemstack2, x, y);
                    }
                } else if (x > this.m_252754_() + 65) {
                    ItemStack itemstack1 = ((MerchantOffer)((KilnWorkerMenu)KilnWorkerScreen.this.f_97732_).getOffers().get(this.index + KilnWorkerScreen.this.scrollOff)).m_45368_();
                    transform.m_280153_(KilnWorkerScreen.this.f_96547_, itemstack1, x, y);
                }
            }
        }
    }

    public static enum TradeType {
        GRE((Component)Component.m_237115_((String)"gui.chang_sheng_jue.trade.gre")),
        RED((Component)Component.m_237115_((String)"gui.chang_sheng_jue.trade.red")),
        BLACK((Component)Component.m_237115_((String)"gui.chang_sheng_jue.trade.black")),
        BLUE((Component)Component.m_237115_((String)"gui.chang_sheng_jue.trade.blue")),
        GOLDEN((Component)Component.m_237115_((String)"gui.chang_sheng_jue.trade.golden")),
        WOOD((Component)Component.m_237115_((String)"gui.chang_sheng_jue.trade.wood"));

        private final Component displayName;

        private TradeType(Component displayName) {
            this.displayName = displayName;
        }

        public Component getDisplayName() {
            return this.displayName;
        }
    }
}

