/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Formatter;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.joml.Math;

public class CSJDisplayHud {
    public static void displayHudPermanent(GuiGraphics guiGraphics, ResourceLocation pAtlasLocation, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)pAtlasLocation);
        guiGraphics.m_280398_(pAtlasLocation, x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public static void displayHudPermanent(GuiGraphics guiGraphics, ResourceLocation pAtlasLocation, int x, int y, int frameTime) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)pAtlasLocation);
        guiGraphics.m_280398_(pAtlasLocation, x, y, 1000, 0.0f, 0.0f, 16, frameTime + 16, 16, 16);
    }

    public static void displayHudPermanent(GuiGraphics guiGraphics, Font font, float frameTime, float frameTimeMax, int x, int y) {
        guiGraphics.m_280137_(font, new Formatter().format(frameTime * frameTimeMax > 10.0f ? "%.0f" : "%.1f", Float.valueOf(frameTime * frameTimeMax)).toString(), x + 8, y + 4, ChatFormatting.AQUA.m_126665_().intValue());
    }

    public static void displayHudPermanent(GuiGraphics guiGraphics, Font font, String text, int x, int y, Integer color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float scale = 0.5f;
        poseStack.m_85841_(scale, scale, scale);
        guiGraphics.m_280137_(font, text, x + 22, 2 * y + 36, color.intValue());
        poseStack.m_85849_();
    }

    public static void displayHudPermanent(GuiGraphics guiGraphics, Font font, int x, int y, String text) {
        guiGraphics.m_280488_(font, text, x + 8, y + 8, ChatFormatting.BLACK.m_126665_().intValue());
    }

    public static void displayHudPermanent(int kungFuLevel, int maxKungFuLevel, float frameTime, float frameTimeMax, boolean playerCanOpened, GuiGraphics guiGraphics, ResourceLocation normalTexture, ResourceLocation maxLevelTexture, ResourceLocation disabledTexture, ResourceLocation cooldownMask, Font font, int x, int y) {
        if (guiGraphics == null || normalTexture == null || maxLevelTexture == null || disabledTexture == null || cooldownMask == null || font == null) {
            return;
        }
        if (kungFuLevel <= 0) {
            CSJDisplayHud.renderDisabledSkill(guiGraphics, disabledTexture, x, y);
            return;
        }
        ResourceLocation baseTexture = CSJDisplayHud.getBaseTexture(kungFuLevel, maxKungFuLevel, normalTexture, maxLevelTexture);
        CSJDisplayHud.renderBaseIcon(guiGraphics, baseTexture, x, y);
        if (!playerCanOpened) {
            CSJDisplayHud.handleCooldown(guiGraphics, cooldownMask, x, y);
        }
        if (frameTime > 0.0f) {
            CSJDisplayHud.handleCooldown(guiGraphics, frameTime, frameTimeMax, cooldownMask, font, x, y);
        }
    }

    private static void renderDisabledSkill(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        guiGraphics.m_280163_(texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private static ResourceLocation getBaseTexture(int currentLevel, int maxLevel, ResourceLocation normal, ResourceLocation maxed) {
        return currentLevel < maxLevel ? normal : maxed;
    }

    private static void renderBaseIcon(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        guiGraphics.m_280163_(texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.disableBlend();
    }

    private static void handleCooldown(GuiGraphics guiGraphics, float currentTime, float maxTime, ResourceLocation maskTexture, Font font, int x, int y) {
        if (maxTime <= 0.0f) {
            return;
        }
        float progress = Math.min((float)1.0f, (float)Math.max((float)0.0f, (float)(currentTime / maxTime)));
        CSJDisplayHud.renderCooldownMask(guiGraphics, maskTexture, x, y, progress);
        CSJDisplayHud.renderCooldownText(guiGraphics, font, currentTime, x, y);
    }

    private static void handleCooldown(GuiGraphics guiGraphics, ResourceLocation maskTexture, int x, int y) {
        float progress = 16.0f;
        CSJDisplayHud.renderCooldownMask(guiGraphics, maskTexture, x, y, progress);
    }

    private static void renderCooldownMask(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, float progress) {
        int height = (int)(16.0f * progress);
        if ((height = Math.min((int)16, (int)Math.max((int)0, (int)height))) <= 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        int renderY = y + (16 - height);
        if (renderY < y) {
            renderY = y;
        }
        if (height > 16) {
            height = 16;
        }
        guiGraphics.m_280163_(texture, x, renderY, 0.0f, (float)(16 - height), 16, height, 16, 16);
        RenderSystem.disableBlend();
    }

    private static void renderCooldownText(GuiGraphics guiGraphics, Font font, float remainingTime, int x, int y) {
        String text = String.format(remainingTime / 20.0f >= 10.0f ? "%.0f" : "%.1f", Float.valueOf(remainingTime / 20.0f));
        int textWidth = font.m_92895_(text);
        int textX = x + 8 - textWidth / 2;
        int textY = y + 4;
        textX = Math.max((int)x, (int)Math.min((int)(x + 16 - textWidth), (int)textX));
        Objects.requireNonNull(font);
        textY = Math.max((int)y, (int)Math.min((int)(y + 16 - 9), (int)textY));
        guiGraphics.m_280056_(font, text, textX + 1, textY + 1, 0, false);
        guiGraphics.m_280056_(font, text, textX, textY, 0xFFFFFF, false);
    }
}

