/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.hud.kungfu;

import com.shengchanshe.chang_sheng_jue.martial_arts.IKungFu;
import com.shengchanshe.chang_sheng_jue.martial_arts.IKungFuUpgradable;
import com.shengchanshe.chang_sheng_jue.martial_arts.KungFuRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class KungFuClientData {
    private static final KungFuClientData INSTANCE = new KungFuClientData();
    private final ConcurrentHashMap<String, IKungFu> clientData = new ConcurrentHashMap();

    public static KungFuClientData get() {
        return INSTANCE;
    }

    public void handleKungFuSync(CompoundTag data) {
        this.clientData.clear();
        ListTag kungFuList = data.m_128437_("LearnedKungFu", 10);
        for (Tag t : kungFuList) {
            CompoundTag kungFuTag = (CompoundTag)t;
            String id = kungFuTag.m_128461_("KungFuId");
            KungFuRegistry.getInstance().getKungFu(id).ifPresent(kungFu -> {
                kungFu.deserializeNBT(kungFuTag);
                this.clientData.put(id, (IKungFu)kungFu);
            });
        }
    }

    public Optional<IKungFu> getKungFu(String id) {
        return Optional.ofNullable(this.clientData.get(id));
    }

    public Set<String> getCoolingDownKungFu() {
        return this.clientData.entrySet().stream().filter(entry -> ((IKungFu)entry.getValue()).getCoolDown() > 0).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<String> getComprehendTickKungFu() {
        return this.clientData.entrySet().stream().filter(entry -> ((IKungFu)entry.getValue()).getLevelUpTick() >= 0).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public int kungFuComprehend(String id) {
        return Optional.ofNullable(this.clientData.get(id)).map(IKungFu::getLevelUpTick).orElse(0);
    }

    public Set<String> getLevelUpTickKungFu() {
        return this.clientData.entrySet().stream().filter(entry -> ((IKungFu)entry.getValue()).getDachengTick() >= 0).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public int kungFuLevelUpTick(String id) {
        return Optional.ofNullable(this.clientData.get(id)).map(IKungFu::getDachengTick).orElse(0);
    }

    public boolean isCoolingDown(String id) {
        return Optional.ofNullable(this.clientData.get(id)).map(kungFu -> kungFu.getCoolDown() > 0).orElse(false);
    }

    public boolean knowsKungFu(String id) {
        return this.clientData.containsKey(id);
    }

    public boolean isKnows(String id) {
        return Optional.ofNullable(this.clientData.get(id)).map(IKungFu::isComprehend).orElse(false);
    }

    public boolean isStart(String id) {
        return Optional.ofNullable(this.clientData.get(id)).map(IKungFu::isStart).orElse(false);
    }

    public int getKungFuLevel(String id) {
        return Optional.ofNullable(this.clientData.get(id)).filter(kungFu -> kungFu instanceof IKungFuUpgradable).map(kungFu -> (IKungFuUpgradable)((Object)kungFu)).map(IKungFuUpgradable::getLevel).orElse(0);
    }

    public int getMaxKungFuLevel(String id) {
        return Optional.ofNullable(this.clientData.get(id)).filter(kungFu -> kungFu instanceof IKungFuUpgradable).map(kungFu -> (IKungFuUpgradable)((Object)kungFu)).map(IKungFuUpgradable::getMaxLevel).orElse(0);
    }

    public int getMaxCoolDown(String id) {
        return Optional.ofNullable(this.clientData.get(id)).map(IKungFu::getMaxCoolDown).orElse(5);
    }

    public int kungFuCoolDown(String id) {
        return Optional.ofNullable(this.clientData.get(id)).map(IKungFu::getCoolDown).orElse(0);
    }

    public void clear() {
        this.clientData.clear();
    }
}

