/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.cilent.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.shengchanshe.chang_sheng_jue.item.combat.lance.Lance;
import com.shengchanshe.chang_sheng_jue.item.combat.throwingknives.ThrowingKnives;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class EntityExtraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation CHARGE_TEXTURE = new ResourceLocation("chang_sheng_jue", "textures/entity/charge.png");
    private final LivingEntityRenderer<T, M> renderer;
    private final Map<LivingEntity, Integer> animationStartTicks = new WeakHashMap<LivingEntity, Integer>();

    public EntityExtraLayer(LivingEntityRenderer<T, M> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (this.shouldRender(pLivingEntity)) {
            if (!this.animationStartTicks.containsKey(pLivingEntity)) {
                this.animationStartTicks.put((LivingEntity)pLivingEntity, ((LivingEntity)pLivingEntity).f_19797_);
            }
            float fadeInProgress = this.calculateFadeInProgress(pLivingEntity, pPartialTicks);
            float time = (float)((LivingEntity)pLivingEntity).f_19797_ + pPartialTicks;
            float uOffset = this.xOffset(time) % 1.0f;
            VertexConsumer buffer = pBuffer.m_6299_(RenderType.m_110436_((ResourceLocation)this.getTextureLocation(), (float)uOffset, (float)(time * 0.01f % 1.0f)));
            EntityModel model = this.renderer.m_7200_();
            model.m_6839_(pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTicks);
            this.m_117386_().m_102624_(model);
            model.m_6973_(pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            Item item = pLivingEntity.m_21205_().m_41720_();
            if (item instanceof Lance) {
                Lance lance = (Lance)item;
                if (lance.isThrowing && !pLivingEntity.m_6144_()) {
                    model.m_7695_(pPoseStack, buffer, pPackedLight, OverlayTexture.f_118083_, fadeInProgress, fadeInProgress, fadeInProgress, fadeInProgress);
                }
            } else {
                model.m_7695_(pPoseStack, buffer, pPackedLight, OverlayTexture.f_118083_, fadeInProgress, fadeInProgress, fadeInProgress, fadeInProgress);
            }
        } else {
            this.animationStartTicks.remove(pLivingEntity);
        }
    }

    private boolean shouldRender(T entity) {
        if (ModList.get().isLoaded("arsenal_core") && entity instanceof Player) {
            Player player = (Player)entity;
            return (player.m_36324_().m_38702_() > 8 || player.m_150110_().f_35937_) && player.m_6117_() && player.m_21205_().m_41720_() instanceof SwordItem && !(player.m_21205_().m_41720_() instanceof ThrowingKnives);
        }
        return entity.m_6117_() && entity.m_21205_().m_41720_() instanceof SwordItem && !(entity.m_21205_().m_41720_() instanceof ThrowingKnives);
    }

    private float calculateFadeInProgress(T entity, float partialTicks) {
        int startTick = this.animationStartTicks.getOrDefault(entity, ((LivingEntity)entity).f_19797_);
        float elapsed = (float)(((LivingEntity)entity).f_19797_ - startTick) + partialTicks;
        return Math.min(elapsed / 6.0f, 1.0f) * 0.5f;
    }

    protected float xOffset(float pTickCount) {
        return pTickCount * 0.01f;
    }

    protected ResourceLocation getTextureLocation() {
        return CHARGE_TEXTURE;
    }
}

