/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class CustomRecipeBuilder {
    private final String recipeType;
    private final ResourceLocation id;
    private final String group;
    private final List<Ingredient> ingredients;
    private final ItemStack result;
    private final ICondition[] conditions;

    private CustomRecipeBuilder(String recipeType, ResourceLocation id, String group, List<Ingredient> ingredients, ItemStack result, ICondition ... conditions) {
        this.recipeType = recipeType;
        this.id = id;
        this.group = group;
        this.ingredients = ingredients;
        this.result = result;
        this.conditions = conditions;
    }

    public static CustomRecipeBuilder customRecipe(String recipeType, ResourceLocation id, String group, List<Ingredient> ingredients, ItemStack result) {
        return new CustomRecipeBuilder(recipeType, id, group, ingredients, result, new ICondition[0]);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Result(this.recipeType, this.id, this.group, this.ingredients, this.result, this.conditions));
    }

    private static class Result
    implements FinishedRecipe {
        private final String recipeType;
        private final ResourceLocation id;
        private final String group;
        private final List<Ingredient> ingredients;
        private final ItemStack result;
        private final ICondition[] conditions;

        public Result(String recipeType, ResourceLocation id, String group, List<Ingredient> ingredients, ItemStack result, ICondition ... conditions) {
            this.recipeType = recipeType;
            this.id = id;
            this.group = group;
            this.ingredients = ingredients;
            this.result = result;
            this.conditions = conditions;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("type", this.recipeType);
            if (this.group != null && !this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray ingredientsJson = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredientsJson.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredientsJson);
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", this.result.m_41720_().toString());
            if (this.result.m_41613_() > 1) {
                resultJson.addProperty("count", (Number)this.result.m_41613_());
            }
            json.add("result", (JsonElement)resultJson);
            if (this.conditions != null && this.conditions.length > 0) {
                JsonArray conditionsJson = new JsonArray();
                for (ICondition condition : this.conditions) {
                    conditionsJson.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                json.add("conditions", (JsonElement)conditionsJson);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44076_;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

