/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.entity.custom.cicada;

import com.shengchanshe.chang_sheng_jue.sound.ChangShengJueSound;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Cicada
extends Animal
implements GeoEntity,
FlyingAnimal {
    private AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isHovering = false;

    public Cicada(EntityType<? extends Cicada> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, false);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22280_, 0.6).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CicadaWanderGoal((PathfinderMob)this, 0.6));
    }

    protected PathNavigation m_6037_(Level p_29417_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_29417_);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public int m_213860_() {
        return 0;
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    @javax.annotation.Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ChangShengJueSound.CICADA_SOUND.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ChangShengJueSound.CICADA_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ChangShengJueSound.CICADA_HURT.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        Level world = this.m_9236_();
        BlockPos pos = this.m_20183_();
        boolean north = Cicada.hasBlock(world, pos.m_122012_());
        boolean south = Cicada.hasBlock(world, pos.m_122019_());
        boolean east = Cicada.hasBlock(world, pos.m_122029_());
        boolean west = Cicada.hasBlock(world, pos.m_122024_());
        if (this.isHovering) {
            event.setAnimation(RawAnimation.begin().then("idle01", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.setAnimation(RawAnimation.begin().then("idle02", Animation.LoopType.LOOP));
        } else if (north || south || east || west) {
            event.setAnimation(RawAnimation.begin().then("idle01", Animation.LoopType.LOOP));
        } else {
            event.setAnimation(RawAnimation.begin().then("idle02", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7840_(double p_29370_, boolean p_29371_, BlockState p_29372_, BlockPos p_29373_) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.checkSideLeaves()) {
            this.isHovering = true;
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, 0.0, 0.0);
        } else {
            this.isHovering = false;
        }
        this.updateLook((Mob)this);
    }

    private boolean checkSideLeaves() {
        BlockPos pos;
        Level world = this.m_9236_();
        return Cicada.hasBlock(world, (pos = this.m_20183_()).m_122012_()) || Cicada.hasBlock(world, pos.m_122019_()) || Cicada.hasBlock(world, pos.m_122029_()) || Cicada.hasBlock(world, pos.m_122024_());
    }

    public void updateLook(Mob mob) {
        Level world = mob.m_9236_();
        BlockPos pos = mob.m_20183_();
        Vec3 lookAt = null;
        double minDistance = Double.MAX_VALUE;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                double distance;
                BlockPos blockPos = pos.m_7918_(x, 0, z);
                Block block = world.m_8055_(blockPos).m_60734_();
                if (!(block instanceof LeavesBlock) && !block.equals(BlockTags.f_13106_) || !((distance = mob.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5)) < minDistance)) continue;
                Vec3 center = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                Vec3 blockCenter = new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
                Vec3 offset = blockCenter.m_82546_(center);
                lookAt = center.m_82549_(offset.m_82541_());
                minDistance = distance;
            }
        }
        if (lookAt != null) {
            mob.m_21563_().m_24946_(lookAt.f_82479_, lookAt.f_82480_, lookAt.f_82481_);
        }
    }

    private static boolean hasBlock(Level world, BlockPos pos) {
        Block block = world.m_8055_(pos).m_60734_();
        return block instanceof LeavesBlock || block.equals(BlockTags.f_13106_);
    }

    static class CicadaWanderGoal
    extends WaterAvoidingRandomFlyingGoal {
        public CicadaWanderGoal(PathfinderMob p_186224_, double p_186225_) {
            super(p_186224_, p_186225_);
        }

        @javax.annotation.Nullable
        protected Vec3 m_7037_() {
            Vec3 vec3 = null;
            if (this.f_25725_.m_20069_()) {
                vec3 = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)15, (int)15);
            }
            if (this.f_25725_.m_217043_().m_188501_() >= this.f_25985_) {
                vec3 = this.getTreePos();
            }
            return vec3 == null ? super.m_7037_() : vec3;
        }

        @javax.annotation.Nullable
        private Vec3 getTreePos() {
            BlockPos blockpos = this.f_25725_.m_20183_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (BlockPos blockpos1 : BlockPos.m_121976_((int)Mth.m_14107_((double)(this.f_25725_.m_20185_() - 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20186_() - 6.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20189_() - 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20185_() + 3.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20186_() + 6.0)), (int)Mth.m_14107_((double)(this.f_25725_.m_20189_() + 3.0)))) {
                BlockState blockstate;
                boolean flag;
                if (blockpos.equals((Object)blockpos1) || !(flag = (blockstate = this.f_25725_.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos1.m_122159_((Vec3i)blockpos1, Direction.DOWN))).m_60734_() instanceof LeavesBlock || blockstate.m_204336_(BlockTags.f_13106_)) || !this.f_25725_.m_9236_().m_46859_(blockpos1) || !this.f_25725_.m_9236_().m_46859_((BlockPos)blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, Direction.UP))) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }
}

