/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.entity.custom.monkey;

import com.shengchanshe.chang_sheng_jue.entity.ChangShengJueEntity;
import com.shengchanshe.chang_sheng_jue.entity.custom.tiger.Tiger;
import com.shengchanshe.chang_sheng_jue.item.ChangShengJueItems;
import com.shengchanshe.chang_sheng_jue.sound.ChangShengJueSound;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Monkey
extends TamableAnimal
implements GeoEntity,
NeutralMob {
    private AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int performing = 0;
    protected int xpReward;
    @Nullable
    private UUID persistentAngerTarget;
    public boolean attackTick;
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Monkey.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);

    public Monkey(EntityType<? extends Monkey> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_7105_(false);
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22279_, 0.6).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Tiger.class, 8.0f, 0.7, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.7, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ChangShengJueItems.BANANA.get()}), false));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.7, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 0.7, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new BreedGoal((Animal)this, 0.6));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_21678_(pCompound);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), false);
        }
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public InteractionResult m_7111_(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        if (pPlayer.m_21120_(pHand).m_41619_() && !this.m_6162_()) {
            int rand = this.f_19796_.m_188503_(100);
            if (pHand == InteractionHand.MAIN_HAND && this.m_21824_()) {
                this.performing = rand < 30 ? 1 : (rand < 60 ? 2 : (rand < 90 ? 3 : 4));
            }
        }
        return super.m_7111_(pPlayer, pVec, pHand);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)pPlayer) || this.m_21824_() || itemstack.m_150930_((Item)ChangShengJueItems.BANANA.get()) && !this.m_21824_() && !this.m_21660_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
            if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)pPlayer)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (itemstack.m_150930_((Item)ChangShengJueItems.BANANA.get()) && !this.m_21660_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                this.m_21828_(pPlayer);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        if (pOtherAnimal == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(pOtherAnimal instanceof Monkey)) {
            return false;
        }
        Monkey monkey = (Monkey)pOtherAnimal;
        if (!monkey.m_21824_()) {
            return false;
        }
        if (monkey.m_21825_()) {
            return false;
        }
        return this.m_27593_() && monkey.m_27593_();
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving()) {
            event.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.setAnimation(RawAnimation.begin().thenPlay("idle"));
        return PlayState.CONTINUE;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity attacker;
        if (this.m_21824_() && (attacker = source.m_7639_()) != null && attacker.m_20148_().equals(this.m_21805_())) {
            this.m_7105_(false);
            this.m_21816_(null);
            this.m_21839_(false);
            this.m_7870_(0);
            this.m_6925_(null);
            this.m_5849_();
        }
        return super.m_6469_(source, amount);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (f_21798_.equals(data)) {
            this.m_5849_();
        }
        super.m_7350_(data);
    }

    public boolean m_7327_(Entity pEntity) {
        return super.m_7327_(pEntity);
    }

    public int m_213860_() {
        int i;
        this.xpReward = i = this.f_19796_.m_188503_(2) + 1;
        return this.xpReward;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)ChangShengJueEntity.MONKEY.get()).m_20615_((Level)level);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_41720_() == ChangShengJueItems.BANANA.get();
    }

    private <E extends GeoAnimatable> PlayState performingPredicate(AnimationState<E> event) {
        if (this.performing == 1) {
            event.setAnimation(RawAnimation.begin().thenPlay("play1"));
        } else if (this.performing == 2) {
            event.setAnimation(RawAnimation.begin().thenPlay("play2"));
        } else if (this.performing == 3) {
            event.setAnimation(RawAnimation.begin().thenPlay("play3"));
        } else if (this.performing == 4) {
            event.setAnimation(RawAnimation.begin().thenPlay("play4"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "performing", 0, this::performingPredicate).setSoundKeyframeHandler(state -> {
            Player player = ClientUtils.getClientPlayer();
            if (player != null) {
                if (this.performing == 1) {
                    player.m_5496_((SoundEvent)ChangShengJueSound.MONKEY_PLAY_1.get(), 1.0f, 1.0f);
                } else if (this.performing == 2) {
                    player.m_5496_((SoundEvent)ChangShengJueSound.MONKEY_PLAY_2.get(), 1.0f, 1.0f);
                } else if (this.performing == 3) {
                    player.m_5496_((SoundEvent)ChangShengJueSound.MONKEY_PLAY_3.get(), 1.0f, 1.0f);
                } else if (this.performing == 4) {
                    player.m_5496_((SoundEvent)ChangShengJueSound.MONKEY_PLAY_4.get(), 1.0f, 1.0f);
                }
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
    }

    private PlayState attackPredicate(AnimationState animationEvent) {
        if (this.f_20911_ && animationEvent.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            animationEvent.getController().forceAnimationReset();
            animationEvent.setAndContinue(RawAnimation.begin().thenPlay("attack"));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int i) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)i);
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    protected SoundEvent m_7515_() {
        if (this.performing != 0) {
            return null;
        }
        return this.m_6162_() ? (SoundEvent)ChangShengJueSound.MONKEY_BABY_SOUND.get() : (this.attackTick ? (SoundEvent)ChangShengJueSound.MONKEY_ANGRY_SOUND.get() : (SoundEvent)ChangShengJueSound.MONKEY_SOUND.get());
    }

    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ChangShengJueSound.MONKEY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ChangShengJueSound.MONKEY_DEATH.get();
    }

    protected float m_6121_() {
        return 0.5f;
    }
}

