/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.entity.custom.wuxia;

import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.AbstractWuXia;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;

public class AbstractWuXiaMerchant
extends AbstractWuXia {
    private long lastRestockGameTime;
    private int numberOfRestocksToday;
    private long lastRestockCheckDayTime;

    public AbstractWuXiaMerchant(EntityType<? extends AbstractWuXia> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected int m_7302_(int pAir) {
        return pAir;
    }

    public boolean m_7826_() {
        return false;
    }

    protected void startTrading(Player pPlayer) {
        this.m_7189_(pPlayer);
        this.m_45301_(pPlayer, this.m_5446_(), 1);
    }

    public void m_7189_(@Nullable Player pPlayer) {
        boolean flag = this.m_7962_() != null && pPlayer == null;
        super.m_7189_(pPlayer);
        if (flag) {
            this.m_7996_();
        }
    }

    public boolean m_7862_() {
        return true;
    }

    public void restock() {
        this.updateDemand();
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45372_();
        }
        this.resendOffersToTradingPlayer();
        this.lastRestockGameTime = this.m_9236_().m_46467_();
        ++this.numberOfRestocksToday;
    }

    private boolean needsToRestock() {
        MerchantOffer merchantoffer;
        Iterator var1 = this.m_6616_().iterator();
        do {
            if (var1.hasNext()) continue;
            return false;
        } while (!(merchantoffer = (MerchantOffer)var1.next()).m_45382_());
        return true;
    }

    private boolean allowedToRestock() {
        long currentTime = this.m_9236_().m_46467_();
        long timeSinceLastRestock = currentTime - this.lastRestockGameTime;
        long oneGameDayInTicks = 24000L;
        return this.numberOfRestocksToday == 0 && timeSinceLastRestock >= oneGameDayInTicks;
    }

    public boolean shouldRestock() {
        long i = this.lastRestockGameTime + 12000L;
        long j = this.m_9236_().m_46467_();
        boolean flag = j > i;
        long k = this.m_9236_().m_46468_();
        if (this.lastRestockCheckDayTime > 0L) {
            long i1 = k / 24000L;
            long l = this.lastRestockCheckDayTime / 24000L;
            flag |= i1 > l;
        }
        this.lastRestockCheckDayTime = k;
        if (flag) {
            this.lastRestockGameTime = j;
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.needsToRestock();
    }

    private void resetNumberOfRestocks() {
        this.catchUpDemand();
        this.numberOfRestocksToday = 0;
    }

    private void updateDemand() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45369_();
        }
    }

    private void catchUpDemand() {
        int i = this.numberOfRestocksToday;
        if (i == 0) {
            for (MerchantOffer merchantoffer : this.m_6616_()) {
                merchantoffer.m_45372_();
            }
            this.updateDemand();
            this.resendOffersToTradingPlayer();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.shouldRestock()) {
            this.restock();
        }
    }

    private void resendOffersToTradingPlayer() {
        MerchantOffers merchantoffers = this.m_6616_();
        Player player = this.m_7962_();
        if (player != null && !merchantoffers.isEmpty()) {
            player.m_7662_(player.f_36096_.f_38840_, merchantoffers, 1, this.m_7809_(), this.m_7826_(), this.m_7862_());
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128356_("LastRestock", this.lastRestockGameTime);
        pCompound.m_128405_("RestocksToday", this.numberOfRestocksToday);
        pCompound.m_128356_("LastRestockCheckDayTime", this.lastRestockCheckDayTime);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("LastRestock")) {
            this.lastRestockGameTime = pCompound.m_128454_("LastRestock");
        }
        if (pCompound.m_128441_("RestocksToday")) {
            this.numberOfRestocksToday = pCompound.m_128451_("RestocksToday");
        }
        if (pCompound.m_128441_("LastRestockCheckDayTime")) {
            this.lastRestockCheckDayTime = pCompound.m_128454_("LastRestockCheckDayTime");
        }
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    @Override
    protected void m_8058_(MerchantOffer pOffer) {
        if (pOffer.m_45383_()) {
            int $$1 = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), $$1));
        }
    }
}

