/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.entity.custom.wuxia;

import com.shengchanshe.chang_sheng_jue.entity.custom.goal.WuXiaAttackGoalMonster;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.AbstractWuXia;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.assassin.Assassin;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.bandit.Bandit;
import com.shengchanshe.chang_sheng_jue.item.ChangShengJueItems;
import com.shengchanshe.chang_sheng_jue.kungfu.externalkunfu.ExternalKungFuCapability;
import com.shengchanshe.chang_sheng_jue.kungfu.externalkunfu.ExternalKungFuManager;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.InterfaceKungFuManager;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.InternalKungFuCapability;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.kungfu.GoldenBellJar;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.kungfu.ImmortalMiracle;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.kungfu.QianKunDaNuoYi;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.kungfu.TheClassicsOfTendonChanging;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.kungfu.TurtleBreathWork;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class AbstractWuXiaMonster
extends Monster {
    protected static final List<ItemStack> SWORDS;
    protected static final List<ItemStack> KNIFE;
    protected static final List<ItemStack> INTERNAL_KUNGFU;
    protected ExternalKungFuCapability externalKungFuCapability;
    protected InternalKungFuCapability internalKungFuCapability;
    private static final EntityDataAccessor<Boolean> ATTACKING;

    public AbstractWuXiaMonster(EntityType<? extends AbstractWuXiaMonster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WuXiaAttackGoalMonster((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractWuXia.class, 15, true, false, entity -> !(entity instanceof Assassin)));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.externalKungFuCapability != null && !this.externalKungFuCapability.isExternalKungFuCooldownOver()) {
            this.externalKungFuCapability.updateExternalKungFuCooldown();
        }
        if (this.internalKungFuCapability != null && !this.internalKungFuCapability.isInternalKungFuCooldownOver()) {
            this.internalKungFuCapability.updateInternalKungFuCooldown();
        }
    }

    protected float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    public boolean m_7327_(Entity pEntity) {
        if (this.externalKungFuCapability != null && this.externalKungFuCapability.isExternalKungFuCooldownOver() && this.f_19796_.m_188503_(100) < 75) {
            if (this.internalKungFuCapability instanceof TheClassicsOfTendonChanging) {
                this.externalKungFuCapability.applyAttackEffect((LivingEntity)this, pEntity, 2);
            } else {
                this.externalKungFuCapability.applyAttackEffect((LivingEntity)this, pEntity, 0);
            }
            this.m_21205_().m_41720_().m_5929_(this.m_9236_(), (LivingEntity)this, this.m_21205_(), 0);
            return true;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float attackDamage = this.getAttackDamage();
        float v = (int)attackDamage > 0 ? attackDamage / 2.0f + (float)this.f_19796_.m_188503_((int)attackDamage) : attackDamage;
        boolean hurt = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), v);
        if (hurt) {
            float f1 = (float)this.m_21133_(Attributes.f_22282_);
            if (f1 > 0.0f && pEntity instanceof LivingEntity) {
                ((LivingEntity)pEntity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, pEntity);
            this.m_21335_(pEntity);
        }
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return hurt;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.internalKungFuCapability != null && this.internalKungFuCapability.isInternalKungFuCooldownOver()) {
            if (this.internalKungFuCapability instanceof GoldenBellJar) {
                this.internalKungFuCapability.applyAttackEffect((LivingEntity)this);
            } else if (this.internalKungFuCapability instanceof ImmortalMiracle) {
                if (pAmount > this.m_21223_()) {
                    pAmount = 0.0f;
                    ((ImmortalMiracle)this.internalKungFuCapability).applyHurtEffect(pSource, (LivingEntity)this);
                }
            } else if (this.internalKungFuCapability instanceof QianKunDaNuoYi) {
                ((QianKunDaNuoYi)this.internalKungFuCapability).applyHurtEffect((LivingEntity)this, pSource, pAmount);
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.externalKungFuCapability != null) {
            pCompound.m_128359_("ExternalKungFuType", this.externalKungFuCapability.getExternalKungFuID());
            this.externalKungFuCapability.saveNBTData(pCompound);
        }
        if (this.internalKungFuCapability != null) {
            pCompound.m_128359_("InternalKungFuType", this.internalKungFuCapability.getInternalKungFuID());
            this.internalKungFuCapability.saveNBTData(pCompound);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        String kungFuType;
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ExternalKungFuType")) {
            kungFuType = pCompound.m_128461_("ExternalKungFuType");
            this.externalKungFuCapability = ExternalKungFuManager.createExternalKungFuCapabilityFromTag(kungFuType);
            if (this.externalKungFuCapability != null) {
                this.externalKungFuCapability.loadNBTData(pCompound);
            }
        }
        if (pCompound.m_128441_("InternalKungFuType")) {
            kungFuType = pCompound.m_128461_("InternalKungFuType");
            this.internalKungFuCapability = InterfaceKungFuManager.createInterfaceKungFuCapabilityFromTag(kungFuType);
            if (this.internalKungFuCapability != null) {
                this.internalKungFuCapability.loadNBTData(pCompound);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
    }

    private ItemStack getInternalKungFuItem(ItemStack item, ItemStack item1, ItemStack item2, ItemStack item3, ItemStack item4, ItemStack item5) {
        if (this.internalKungFuCapability instanceof GoldenBellJar) {
            return this.getRandomItem(item, item1);
        }
        if (this.internalKungFuCapability instanceof ImmortalMiracle) {
            return this.getRandomItem(item, item2);
        }
        if (this.internalKungFuCapability instanceof QianKunDaNuoYi) {
            return this.getRandomItem(item, item3);
        }
        if (this.internalKungFuCapability instanceof TurtleBreathWork) {
            this.internalKungFuCapability.applyAttackEffect((LivingEntity)this);
            return this.getRandomItem(item, item4);
        }
        if (this.internalKungFuCapability instanceof TheClassicsOfTendonChanging) {
            return this.getRandomItem(item, item5);
        }
        return item;
    }

    protected ItemStack getRandomItem(ItemStack item1, ItemStack item2) {
        return this.f_19796_.m_188499_() ? item1 : item2;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        Horse horse;
        SpawnGroupData $$5 = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        RandomSource $$6 = pLevel.m_213780_();
        this.m_213945_($$6, pDifficulty);
        this.m_213946_($$6, pDifficulty);
        if (this instanceof Bandit && $$6.m_188503_(100) >= 50 && (horse = (Horse)EntityType.f_20457_.m_20615_(this.m_9236_())) != null) {
            horse.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            horse.m_6518_(pLevel, pDifficulty, pReason, null, null);
            horse.m_30651_(true);
            this.m_9236_().m_7967_((Entity)horse);
            this.m_20329_((Entity)horse);
        }
        return $$5;
    }

    static {
        ATTACKING = SynchedEntityData.m_135353_(AbstractWuXiaMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SWORDS = Arrays.asList(new ItemStack((ItemLike)ChangShengJueItems.HAN_JIAN.get()), new ItemStack((ItemLike)Items.f_42388_), new ItemStack((ItemLike)Items.f_42383_), new ItemStack((ItemLike)Items.f_42430_), new ItemStack((ItemLike)Items.f_42425_), new ItemStack((ItemLike)Items.f_42420_));
        INTERNAL_KUNGFU = Arrays.asList(new ItemStack((ItemLike)ChangShengJueItems.GOLDEN_BELL_JAR.get()), new ItemStack((ItemLike)ChangShengJueItems.IMMORTAL_MIRACLE.get()), new ItemStack((ItemLike)ChangShengJueItems.QIAN_KUN_DA_NUO_YI.get()), new ItemStack((ItemLike)ChangShengJueItems.TURTLE_BREATH_WORK.get()), new ItemStack((ItemLike)ChangShengJueItems.THE_CLASSICS_OF_TENDON_CHANGING.get()));
        KNIFE = Arrays.asList(new ItemStack((ItemLike)ChangShengJueItems.HENG_DAO.get()), new ItemStack((ItemLike)ChangShengJueItems.LARGE_KNIFE.get()));
    }
}

