/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.gangleader;

import com.shengchanshe.chang_sheng_jue.ChangShengJue;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.AbstractWuXia;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.AbstractWuXiaMerchant;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AbstractGangLeader
extends AbstractWuXiaMerchant {
    private final Map<UUID, List<Quest>> playerQuests = new ConcurrentHashMap<UUID, List<Quest>>();

    public AbstractGangLeader(EntityType<? extends AbstractWuXia> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void resetOffers() {
        this.f_35261_ = null;
    }

    public void m_45301_(Player pPlayer, Component pDisplayName, int pLevel) {
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        if (this.m_6084_() && !this.m_35306_() && !this.m_6162_()) {
            if (pHand == InteractionHand.MAIN_HAND) {
                pPlayer.m_36220_(Stats.f_12940_);
            }
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_) {
                this.startTrading(pPlayer);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void removeQuest(UUID playerId, UUID questId) {
        if (this.playerQuests.containsKey(playerId)) {
            this.playerQuests.get(playerId).removeIf(quest -> quest.getQuestId().equals(questId));
            ChangShengJue.LOGGER.info("\u5df2\u79fb\u9664\u73a9\u5bb6{}\u7684\u4efb\u52a1: {}", (Object)playerId, (Object)questId);
        }
    }

    public void removeUnacceptedQuests(UUID playerId) {
        if (this.playerQuests.containsKey(playerId)) {
            this.playerQuests.get(playerId).removeIf(quest -> quest.getAcceptedBy() == null);
        }
    }

    public void clearPlayerQuests(UUID playerId) {
        this.playerQuests.remove(playerId);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ListTag playerQuestsTag = new ListTag();
        for (Map.Entry<UUID, List<Quest>> entry : this.playerQuests.entrySet()) {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("PlayerId", entry.getKey());
            ListTag questsTag = new ListTag();
            for (Quest quest : entry.getValue()) {
                CompoundTag questTag = quest.toNbt();
                questsTag.add((Object)questTag);
            }
            playerTag.m_128365_("Quests", (Tag)questsTag);
            playerQuestsTag.add((Object)playerTag);
        }
        pCompound.m_128365_("PlayerQuests", (Tag)playerQuestsTag);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("PlayerQuests", 9)) {
            ListTag playerQuestsTag = pCompound.m_128437_("PlayerQuests", 10);
            for (Tag tag : playerQuestsTag) {
                CompoundTag playerTag = (CompoundTag)tag;
                UUID playerId = playerTag.m_128342_("PlayerId");
                ArrayList<Quest> quests = new ArrayList<Quest>();
                ListTag questsTag = playerTag.m_128437_("Quests", 10);
                for (Tag questTag : questsTag) {
                    Quest quest = new Quest((CompoundTag)questTag);
                    quests.add(quest);
                }
                this.playerQuests.put(playerId, quests);
            }
        }
    }

    public List<Quest> getPlayerQuests(UUID playerId) {
        return this.playerQuests.computeIfAbsent(playerId, k -> new ArrayList());
    }

    public void addQuestForPlayer(UUID playerId, Quest quest) {
        if (quest == null) {
            return;
        }
        List<Quest> quests = this.getPlayerQuests(playerId);
        for (int i = 0; i < quests.size(); ++i) {
            Quest existingQuest = quests.get(i);
            if (existingQuest == null || !existingQuest.getQuestId().equals(quest.getQuestId())) continue;
            quests.set(i, quest);
            ChangShengJue.LOGGER.debug("\u66f4\u65b0\u73a9\u5bb6 {} \u7684\u73b0\u6709\u4efb\u52a1: {}", (Object)playerId, (Object)quest.getQuestId());
            return;
        }
        quests.add(quest);
        ChangShengJue.LOGGER.debug("\u4e3a\u73a9\u5bb6 {} \u6dfb\u52a0\u65b0\u4efb\u52a1: {}", (Object)playerId, (Object)quest.getQuestId());
    }

    public Map<UUID, List<Quest>> getAllPlayerQuests() {
        return Collections.unmodifiableMap(this.playerQuests);
    }
}

