/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.entity.villagers.warrior;

import com.shengchanshe.chang_sheng_jue.item.ChangShengJueItems;
import com.shengchanshe.chang_sheng_jue.kungfu.externalkunfu.ExternalKungFuCapability;
import com.shengchanshe.chang_sheng_jue.kungfu.externalkunfu.ExternalKungFuManager;
import com.shengchanshe.chang_sheng_jue.kungfu.externalkunfu.kungfu.DuguNineSwords;
import com.shengchanshe.chang_sheng_jue.kungfu.externalkunfu.kungfu.GaoMarksmanship;
import com.shengchanshe.chang_sheng_jue.kungfu.externalkunfu.kungfu.GeShanDaNiu;
import com.shengchanshe.chang_sheng_jue.kungfu.externalkunfu.kungfu.GoldenBlackKnifeMethod;
import com.shengchanshe.chang_sheng_jue.kungfu.externalkunfu.kungfu.ShaolinStickMethod;
import com.shengchanshe.chang_sheng_jue.kungfu.externalkunfu.kungfu.SunflowerPointCaveman;
import com.shengchanshe.chang_sheng_jue.kungfu.externalkunfu.kungfu.XuannuSwordsmanship;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.InterfaceKungFuManager;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.InternalKungFuCapability;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.kungfu.GoldenBellJar;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.kungfu.ImmortalMiracle;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.kungfu.QianKunDaNuoYi;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.kungfu.TheClassicsOfTendonChanging;
import com.shengchanshe.chang_sheng_jue.kungfu.internalkungfu.kungfu.TurtleBreathWork;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class Warrior
extends PathfinderMob
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Warrior.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState attackAnimationState = new AnimationState();
    private int attackAnimationTimeout = 0;
    private static final List<ItemStack> SWORDS;
    private static final List<ItemStack> INTERNAL_KUNGFU;
    private ExternalKungFuCapability externalKungFuCapability;
    private InternalKungFuCapability internalKungFuCapability;
    private static final UniformInt PERSISTENT_ANGER_TIME;
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public Warrior(EntityType<? extends Warrior> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 17.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22278_, 1.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new WarriorAttackGoal(this, 0.7f, false));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(2, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.6, false));
        this.f_21345_.m_25352_(4, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new DefendVillageTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Warrior)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, livingEntity -> livingEntity instanceof Enemy && !(livingEntity instanceof Creeper)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected int m_7302_(int pAir) {
        return pAir;
    }

    public boolean m_7327_(Entity pEntity) {
        if (this.externalKungFuCapability != null && this.externalKungFuCapability.isExternalKungFuCooldownOver() && this.f_19796_.m_188503_(100) < 75) {
            if (this.internalKungFuCapability instanceof TheClassicsOfTendonChanging) {
                this.externalKungFuCapability.applyAttackEffect((LivingEntity)this, pEntity, 2);
            } else {
                this.externalKungFuCapability.applyAttackEffect((LivingEntity)this, pEntity, 0);
            }
            this.m_21205_().m_41720_().m_5929_(this.m_9236_(), (LivingEntity)this, this.m_21205_(), 0);
            return true;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float attackDamage = this.getAttackDamage();
        float v = (int)attackDamage > 0 ? attackDamage / 2.0f + (float)this.f_19796_.m_188503_((int)attackDamage) : attackDamage;
        boolean hurt = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), v);
        if (hurt) {
            float f1 = (float)this.m_21133_(Attributes.f_22282_);
            if (f1 > 0.0f && pEntity instanceof LivingEntity) {
                ((LivingEntity)pEntity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, pEntity);
            this.m_21335_(pEntity);
        }
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return hurt;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.internalKungFuCapability != null && this.internalKungFuCapability.isInternalKungFuCooldownOver()) {
            if (this.internalKungFuCapability instanceof GoldenBellJar) {
                this.internalKungFuCapability.applyAttackEffect((LivingEntity)this);
            } else if (this.internalKungFuCapability instanceof ImmortalMiracle) {
                if (pAmount > this.m_21223_()) {
                    pAmount = 0.0f;
                    ((ImmortalMiracle)this.internalKungFuCapability).applyHurtEffect(pSource, (LivingEntity)this);
                }
            } else if (this.internalKungFuCapability instanceof QianKunDaNuoYi) {
                ((QianKunDaNuoYi)this.internalKungFuCapability).applyHurtEffect((LivingEntity)this, pSource, pAmount);
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        } else {
            if (this.externalKungFuCapability != null && !this.externalKungFuCapability.isExternalKungFuCooldownOver()) {
                this.externalKungFuCapability.updateExternalKungFuCooldown();
            }
            if (this.internalKungFuCapability != null && !this.internalKungFuCapability.isInternalKungFuCooldownOver()) {
                this.internalKungFuCapability.updateInternalKungFuCooldown();
            }
        }
    }

    private void setupAnimationStates() {
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 80;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.externalKungFuCapability != null) {
            pCompound.m_128359_("ExternalKungFuType", this.externalKungFuCapability.getExternalKungFuID());
            this.externalKungFuCapability.saveNBTData(pCompound);
        }
        if (this.internalKungFuCapability != null) {
            pCompound.m_128359_("InternalKungFuType", this.internalKungFuCapability.getInternalKungFuID());
            this.internalKungFuCapability.saveNBTData(pCompound);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        String kungFuType;
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ExternalKungFuType")) {
            kungFuType = pCompound.m_128461_("ExternalKungFuType");
            this.externalKungFuCapability = ExternalKungFuManager.createExternalKungFuCapabilityFromTag(kungFuType);
            if (this.externalKungFuCapability != null) {
                this.externalKungFuCapability.loadNBTData(pCompound);
            }
        }
        if (pCompound.m_128441_("InternalKungFuType")) {
            kungFuType = pCompound.m_128461_("InternalKungFuType");
            this.internalKungFuCapability = InterfaceKungFuManager.createInterfaceKungFuCapabilityFromTag(kungFuType);
            if (this.internalKungFuCapability != null) {
                this.internalKungFuCapability.loadNBTData(pCompound);
            }
        }
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
        this.externalKungFuCapability = new ExternalKungFuManager().getRandomExternalKungFuCapability((LivingEntity)this);
        this.internalKungFuCapability = new InterfaceKungFuManager().getRandomInterfaceKungFuCapability();
        if (this.externalKungFuCapability != null && this.internalKungFuCapability != null) {
            if (this.externalKungFuCapability instanceof DuguNineSwords) {
                ItemStack randomSword = SWORDS.get(this.f_19796_.m_188503_(SWORDS.size()));
                this.m_8061_(EquipmentSlot.MAINHAND, randomSword);
                this.m_8061_(EquipmentSlot.CHEST, Objects.requireNonNull(this.getInternalKungFuItem(new ItemStack((ItemLike)ChangShengJueItems.DUGU_NINE_SWORDS.get()), INTERNAL_KUNGFU.get(0), INTERNAL_KUNGFU.get(1), INTERNAL_KUNGFU.get(2), INTERNAL_KUNGFU.get(3), INTERNAL_KUNGFU.get(4))));
            } else if (this.externalKungFuCapability instanceof GaoMarksmanship) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ChangShengJueItems.RED_TASSELLED_SPEAR.get()));
                this.m_8061_(EquipmentSlot.CHEST, Objects.requireNonNull(this.getInternalKungFuItem(new ItemStack((ItemLike)ChangShengJueItems.GAO_MARKSMANSHIP.get()), INTERNAL_KUNGFU.get(0), INTERNAL_KUNGFU.get(1), INTERNAL_KUNGFU.get(2), INTERNAL_KUNGFU.get(3), INTERNAL_KUNGFU.get(4))));
            } else if (this.externalKungFuCapability instanceof GoldenBlackKnifeMethod) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ChangShengJueItems.LARGE_KNIFE.get()));
                this.m_8061_(EquipmentSlot.CHEST, Objects.requireNonNull(this.getInternalKungFuItem(new ItemStack((ItemLike)ChangShengJueItems.GOLDEN_BLACK_KNIFE_METHOD.get()), INTERNAL_KUNGFU.get(0), INTERNAL_KUNGFU.get(1), INTERNAL_KUNGFU.get(2), INTERNAL_KUNGFU.get(3), INTERNAL_KUNGFU.get(4))));
            } else if (this.externalKungFuCapability instanceof ShaolinStickMethod) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ChangShengJueItems.PAN_HUA_GUN.get()));
                this.m_8061_(EquipmentSlot.CHEST, Objects.requireNonNull(this.getInternalKungFuItem(new ItemStack((ItemLike)ChangShengJueItems.SHAOLIN_STICK_METHOD.get()), INTERNAL_KUNGFU.get(0), INTERNAL_KUNGFU.get(1), INTERNAL_KUNGFU.get(2), INTERNAL_KUNGFU.get(3), INTERNAL_KUNGFU.get(4))));
            } else if (this.externalKungFuCapability instanceof XuannuSwordsmanship) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ChangShengJueItems.SOFT_SWORD.get()));
                this.m_8061_(EquipmentSlot.CHEST, Objects.requireNonNull(this.getInternalKungFuItem(new ItemStack((ItemLike)ChangShengJueItems.XUANNU_SWORDSMANSHIP.get()), INTERNAL_KUNGFU.get(0), INTERNAL_KUNGFU.get(1), INTERNAL_KUNGFU.get(2), INTERNAL_KUNGFU.get(3), INTERNAL_KUNGFU.get(4))));
            } else if (this.externalKungFuCapability instanceof GeShanDaNiu) {
                this.m_8061_(EquipmentSlot.CHEST, Objects.requireNonNull(this.getInternalKungFuItem(new ItemStack((ItemLike)ChangShengJueItems.GE_SHAN_DA_NIU.get()), INTERNAL_KUNGFU.get(0), INTERNAL_KUNGFU.get(1), INTERNAL_KUNGFU.get(2), INTERNAL_KUNGFU.get(3), INTERNAL_KUNGFU.get(4))));
            } else if (this.externalKungFuCapability instanceof SunflowerPointCaveman) {
                this.m_8061_(EquipmentSlot.CHEST, Objects.requireNonNull(this.getInternalKungFuItem(new ItemStack((ItemLike)ChangShengJueItems.SUNFLOWER_POINT_CAVEMAN.get()), INTERNAL_KUNGFU.get(0), INTERNAL_KUNGFU.get(1), INTERNAL_KUNGFU.get(2), INTERNAL_KUNGFU.get(3), INTERNAL_KUNGFU.get(4))));
            }
        }
    }

    private ItemStack getInternalKungFuItem(ItemStack item, ItemStack item1, ItemStack item2, ItemStack item3, ItemStack item4, ItemStack item5) {
        if (this.internalKungFuCapability instanceof GoldenBellJar) {
            return this.getRandomItem(item, item1);
        }
        if (this.internalKungFuCapability instanceof ImmortalMiracle) {
            return this.getRandomItem(item, item2);
        }
        if (this.internalKungFuCapability instanceof QianKunDaNuoYi) {
            return this.getRandomItem(item, item3);
        }
        if (this.internalKungFuCapability instanceof TurtleBreathWork) {
            this.internalKungFuCapability.applyAttackEffect((LivingEntity)this);
            return this.getRandomItem(item, item4);
        }
        if (this.internalKungFuCapability instanceof TheClassicsOfTendonChanging) {
            return this.getRandomItem(item, item5);
        }
        return null;
    }

    private ItemStack getRandomItem(ItemStack item1, ItemStack item2) {
        return this.f_19796_.m_188499_() ? item1 : item2;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData $$5 = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        RandomSource $$6 = pLevel.m_213780_();
        this.m_213945_($$6, pDifficulty);
        this.m_213946_($$6, pDifficulty);
        return $$5;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int pTime) {
        this.remainingPersistentAngerTime = pTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public boolean okTarget(@Nullable LivingEntity livingEntity) {
        return livingEntity != null;
    }

    static {
        PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
        SWORDS = Arrays.asList(new ItemStack((ItemLike)ChangShengJueItems.HAN_JIAN.get()), new ItemStack((ItemLike)Items.f_42388_), new ItemStack((ItemLike)Items.f_42383_), new ItemStack((ItemLike)Items.f_42430_), new ItemStack((ItemLike)Items.f_42425_), new ItemStack((ItemLike)Items.f_42420_));
        INTERNAL_KUNGFU = Arrays.asList(new ItemStack((ItemLike)ChangShengJueItems.GOLDEN_BELL_JAR.get()), new ItemStack((ItemLike)ChangShengJueItems.IMMORTAL_MIRACLE.get()), new ItemStack((ItemLike)ChangShengJueItems.QIAN_KUN_DA_NUO_YI.get()), new ItemStack((ItemLike)ChangShengJueItems.TURTLE_BREATH_WORK.get()), new ItemStack((ItemLike)ChangShengJueItems.THE_CLASSICS_OF_TENDON_CHANGING.get()));
    }

    private static class WarriorAttackGoal
    extends MeleeAttackGoal {
        private final Warrior warrior;

        public WarriorAttackGoal(Warrior pWarrior, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)pWarrior, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.warrior = pWarrior;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.warrior.okTarget(this.warrior.m_5448_());
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.warrior.okTarget(this.warrior.m_5448_());
        }
    }

    static class DefendVillageTargetGoal
    extends TargetGoal {
        private final Warrior warrior;
        @Nullable
        private LivingEntity potentialTarget;
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);

        public DefendVillageTargetGoal(Warrior warrior) {
            super((Mob)warrior, false, true);
            this.warrior = warrior;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            AABB $$0 = this.warrior.m_20191_().m_82377_(10.0, 8.0, 10.0);
            List $$1 = this.warrior.m_9236_().m_45971_(Villager.class, this.attackTargeting, (LivingEntity)this.warrior, $$0);
            List $$2 = this.warrior.m_9236_().m_45955_(this.attackTargeting, (LivingEntity)this.warrior, $$0);
            for (LivingEntity $$3 : $$1) {
                Villager $$4 = (Villager)$$3;
                for (Player $$5 : $$2) {
                    int $$6 = $$4.m_35532_($$5);
                    if ($$6 > -100) continue;
                    this.potentialTarget = $$5;
                }
            }
            if (this.potentialTarget == null) {
                return false;
            }
            return !(this.potentialTarget instanceof Player) || !this.potentialTarget.m_5833_() && !((Player)this.potentialTarget).m_7500_();
        }

        public void m_8056_() {
            this.warrior.m_6710_(this.potentialTarget);
            super.m_8056_();
        }
    }
}

