/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.entity.villagers.worker;

import com.shengchanshe.chang_sheng_jue.ChangShengJue;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.worker.KilnWorkerMenu;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.worker.KilnWorkerScreen;
import com.shengchanshe.chang_sheng_jue.entity.custom.goal.ReturnToSpawnGoal;
import com.shengchanshe.chang_sheng_jue.item.ChangShengJueItems;
import com.shengchanshe.chang_sheng_jue.world.village.WuXiaMerahantTrades;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;

public class KilnWorker
extends AbstractVillager {
    private KilnWorkerScreen.TradeType currentTradeType = KilnWorkerScreen.TradeType.GRE;
    private long lastRestockGameTime;
    private int numberOfRestocksToday;
    private long lastRestockCheckDayTime;

    public KilnWorker(EntityType<? extends KilnWorker> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_7604_();
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.5).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(2, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.6, false));
        this.f_21345_.m_25352_(5, (Goal)new ReturnToSpawnGoal(this, 0.6, 16, 100));
        this.f_21345_.m_25352_(4, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_45301_(Player pPlayer, Component pDisplayName, int pLevel) {
        MerchantOffers merchantOffers;
        OptionalInt present = pPlayer.m_5893_((MenuProvider)new SimpleMenuProvider((i, inventory, player) -> new KilnWorkerMenu(i, inventory, (Merchant)this), pDisplayName));
        if (present.isPresent() && !(merchantOffers = this.m_6616_()).isEmpty()) {
            pPlayer.m_7662_(present.getAsInt(), merchantOffers, pLevel, this.m_7809_(), this.m_7826_(), this.m_7862_());
        }
    }

    public void setCurrentTradeType(KilnWorkerScreen.TradeType tradeType) {
        this.currentTradeType = tradeType;
        this.m_7604_();
    }

    protected void m_7604_() {
        VillagerTrades.ItemListing[] listings;
        HashMap<Integer, Integer> usesMap = new HashMap<Integer, Integer>();
        if (this.f_35261_ != null) {
            for (int i = 0; i < this.f_35261_.size(); ++i) {
                usesMap.put(i, ((MerchantOffer)this.f_35261_.get(i)).m_45371_());
            }
        }
        switch (this.currentTradeType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case GRE: {
                VillagerTrades.ItemListing[] itemListingArray = (VillagerTrades.ItemListing[])WuXiaMerahantTrades.KILN_WORKER_TRADES.get(1);
                break;
            }
            case RED: {
                VillagerTrades.ItemListing[] itemListingArray = (VillagerTrades.ItemListing[])WuXiaMerahantTrades.KILN_WORKER_TRADES.get(2);
                break;
            }
            case BLACK: {
                VillagerTrades.ItemListing[] itemListingArray = (VillagerTrades.ItemListing[])WuXiaMerahantTrades.KILN_WORKER_TRADES.get(3);
                break;
            }
            case BLUE: {
                VillagerTrades.ItemListing[] itemListingArray = (VillagerTrades.ItemListing[])WuXiaMerahantTrades.KILN_WORKER_TRADES.get(4);
                break;
            }
            case GOLDEN: {
                VillagerTrades.ItemListing[] itemListingArray = (VillagerTrades.ItemListing[])WuXiaMerahantTrades.KILN_WORKER_TRADES.get(5);
                break;
            }
            case WOOD: {
                VillagerTrades.ItemListing[] itemListingArray = listings = (VillagerTrades.ItemListing[])WuXiaMerahantTrades.KILN_WORKER_TRADES.get(6);
            }
        }
        if (listings != null) {
            MerchantOffers newOffers = new MerchantOffers();
            for (int i = 0; i < listings.length; ++i) {
                MerchantOffer originalOffer = listings[i].m_213663_((Entity)this, this.f_19796_);
                if (originalOffer == null) continue;
                MerchantOffer newOffer = new MerchantOffer(originalOffer.m_45352_(), originalOffer.m_45364_(), originalOffer.m_45368_(), usesMap.getOrDefault(i, 0).intValue(), originalOffer.m_45373_(), originalOffer.m_45379_(), originalOffer.m_45378_(), originalOffer.m_45375_());
                this.setSpecialPriceThroughReflection(newOffer, originalOffer.m_45377_());
                newOffers.add((Object)newOffer);
            }
            this.f_35261_ = newOffers;
            if (this.m_7962_() != null) {
                this.m_7962_().m_7662_(((KilnWorkerMenu)this.m_7962_().f_36096_).getContainerId(), this.f_35261_, 1, this.m_7809_(), this.m_7826_(), this.m_7862_());
            }
        }
    }

    private void setSpecialPriceThroughReflection(MerchantOffer offer, int specialPrice) {
        try {
            Field field = MerchantOffer.class.getDeclaredField("specialPriceDiff");
            field.setAccessible(true);
            field.setInt(offer, specialPrice);
        }
        catch (Exception e) {
            ChangShengJue.LOGGER.error("Could not set special price for merchant offer", (Throwable)e);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        if (!itemInHand.m_150930_((Item)ChangShengJueItems.KILN_WORKER_EGG.get()) && this.m_6084_() && !this.m_35306_() && !this.m_6162_()) {
            if (pHand == InteractionHand.MAIN_HAND) {
                pPlayer.m_36220_(Stats.f_12940_);
            }
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_) {
                this.startTrading(pPlayer);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected int m_7302_(int pAir) {
        return pAir;
    }

    public boolean m_7826_() {
        return false;
    }

    protected void startTrading(Player pPlayer) {
        this.m_7189_(pPlayer);
        this.m_45301_(pPlayer, this.m_5446_(), 1);
    }

    public void m_7189_(@Nullable Player pPlayer) {
        boolean flag = this.m_7962_() != null && pPlayer == null;
        super.m_7189_(pPlayer);
        if (flag) {
            this.m_7996_();
        }
    }

    public boolean m_7862_() {
        return true;
    }

    public void restock() {
        this.updateDemand();
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45372_();
        }
        this.resendOffersToTradingPlayer();
        this.lastRestockGameTime = this.m_9236_().m_46467_();
        ++this.numberOfRestocksToday;
    }

    private boolean needsToRestock() {
        MerchantOffer merchantoffer;
        Iterator var1 = this.m_6616_().iterator();
        do {
            if (var1.hasNext()) continue;
            return false;
        } while (!(merchantoffer = (MerchantOffer)var1.next()).m_45382_());
        return true;
    }

    private boolean allowedToRestock() {
        long currentTime = this.m_9236_().m_46467_();
        long timeSinceLastRestock = currentTime - this.lastRestockGameTime;
        long oneGameDayInTicks = 24000L;
        return this.numberOfRestocksToday == 0 && timeSinceLastRestock >= oneGameDayInTicks;
    }

    public boolean shouldRestock() {
        long i = this.lastRestockGameTime + 12000L;
        long j = this.m_9236_().m_46467_();
        boolean flag = j > i;
        long k = this.m_9236_().m_46468_();
        if (this.lastRestockCheckDayTime > 0L) {
            long i1 = k / 24000L;
            long l = this.lastRestockCheckDayTime / 24000L;
            flag |= i1 > l;
        }
        this.lastRestockCheckDayTime = k;
        if (flag) {
            this.lastRestockGameTime = j;
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.needsToRestock();
    }

    private void resetNumberOfRestocks() {
        this.catchUpDemand();
        this.numberOfRestocksToday = 0;
    }

    private void updateDemand() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45369_();
        }
    }

    private void catchUpDemand() {
        int i = this.numberOfRestocksToday;
        if (i == 0) {
            for (MerchantOffer merchantoffer : this.m_6616_()) {
                merchantoffer.m_45372_();
            }
            this.updateDemand();
            this.resendOffersToTradingPlayer();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.shouldRestock()) {
            this.restock();
        }
    }

    private void resendOffersToTradingPlayer() {
        MerchantOffers merchantoffers = this.m_6616_();
        Player player = this.m_7962_();
        if (player != null && !merchantoffers.isEmpty()) {
            player.m_7662_(player.f_36096_.f_38840_, merchantoffers, 1, this.m_7809_(), this.m_7826_(), this.m_7862_());
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128356_("LastRestock", this.lastRestockGameTime);
        pCompound.m_128405_("RestocksToday", this.numberOfRestocksToday);
        pCompound.m_128356_("LastRestockCheckDayTime", this.lastRestockCheckDayTime);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("LastRestock")) {
            this.lastRestockGameTime = pCompound.m_128454_("LastRestock");
        }
        if (pCompound.m_128441_("RestocksToday")) {
            this.numberOfRestocksToday = pCompound.m_128451_("RestocksToday");
        }
        if (pCompound.m_128441_("LastRestockCheckDayTime")) {
            this.lastRestockCheckDayTime = pCompound.m_128454_("LastRestockCheckDayTime");
        }
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    protected void m_8058_(MerchantOffer pOffer) {
        if (pOffer.m_45383_()) {
            int $$1 = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), $$1));
        }
    }

    public long getLastRestockGameTime() {
        return this.lastRestockGameTime;
    }

    public int getNumberOfRestocksToday() {
        return this.numberOfRestocksToday;
    }

    public long getLastRestockCheckDayTime() {
        return this.lastRestockCheckDayTime;
    }

    public void setLastRestockGameTime(long lastRestockGameTime) {
        this.lastRestockGameTime = lastRestockGameTime;
    }

    public void setNumberOfRestocksToday(int numberOfRestocksToday) {
        this.numberOfRestocksToday = numberOfRestocksToday;
    }

    public void setLastRestockCheckDayTime(long lastRestockCheckDayTime) {
        this.lastRestockCheckDayTime = lastRestockCheckDayTime;
    }
}

