/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.event;

import com.shengchanshe.chang_sheng_jue.ChangShengJueConfig;
import com.shengchanshe.chang_sheng_jue.entity.ChangShengJueEntity;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.AbstractWuXia;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.AbstractWuXiaMonster;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.bandit.Bandit;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.challenger.Challenger;
import com.shengchanshe.chang_sheng_jue.init.CSJAdvanceInit;
import com.shengchanshe.chang_sheng_jue.item.ChangShengJueItems;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import com.shengchanshe.chang_sheng_jue.world.CSJStructures;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chang_sheng_jue")
public class CSJAdvanceEvent {
    private static int COOLDOWN = 3;
    private static final Map<UUID, Integer> summonTracker = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Player player2 = event.player;
            CSJAdvanceEvent.checkForItem(player2);
            Level level = player2.m_9236_();
            BlockPos pos = player2.m_20183_();
            ServerLevel serverLevel = (ServerLevel)level;
            List<ResourceKey> villages = List.of(CSJStructures.PIT_YARD, CSJStructures.SANDSTONE_CASTLE, CSJStructures.SI_HE_YUAN, CSJStructures.SU_PAI_VILLAGE, CSJStructures.HUI_PAI_VILLAGE, BuiltinStructures.f_209865_, BuiltinStructures.f_209864_, BuiltinStructures.f_209866_, BuiltinStructures.f_209867_, BuiltinStructures.f_209868_);
            boolean isInAnyVillage = false;
            ChunkPos villageChunk = null;
            for (ResourceKey village : villages) {
                LocationPredicate predicate = LocationPredicate.m_220589_((ResourceKey)village);
                if (!predicate.m_52617_(serverLevel, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) continue;
                villageChunk = new ChunkPos(pos);
                isInAnyVillage = true;
                break;
            }
        }
    }

    private static void checkForItem(Player player) {
        boolean hasQiTianHelmet = false;
        boolean hasQiTianChestplate = false;
        boolean hasQiTianLeggings = false;
        boolean hasQiTianBoots = false;
        Level level = player.m_9236_();
        long worldTime = level.m_46468_();
        if (worldTime % 24000L == 0L) {
            if (COOLDOWN == 3) {
                if (player.m_150109_().m_18947_((Item)ChangShengJueItems.YI_GUAN_TONG_QIAN.get()) >= 9 || player.m_150109_().m_18947_((Item)ChangShengJueItems.SILVER_BULLIONS.get()) >= 3 || player.m_150109_().m_18947_((Item)ChangShengJueItems.GOLD_BULLIONS.get()) >= 1) {
                    System.out.println("0");
                    CSJAdvanceEvent.summonBandit(level, player);
                }
            } else {
                COOLDOWN = COOLDOWN >= 4 ? 0 : ++COOLDOWN;
            }
        }
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            Item item = itemStack.m_41720_();
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String biome = serverPlayer.m_9236_().m_204166_(player.m_20183_()).toString();
            if (item == ChangShengJueItems.MI_FAN.get()) {
                CSJAdvanceInit.HAS_MI_FAN.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.SILVER_BULLIONS.get()) {
                CSJAdvanceInit.HAS_SILVER_BULLIONS.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.GOLD_BULLIONS.get()) {
                CSJAdvanceInit.HASGOLD_BULLIONS.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.BA_BAO_ZHOU.get()) {
                CSJAdvanceInit.HAS_BA_BAO_ZHOU.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.GUI_HUA_TANG_OU.get()) {
                CSJAdvanceInit.HAS_GUI_HUA_TANG_OU.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.BRONZE_SWORD.get()) {
                CSJAdvanceInit.HAS_BRONZE_SWORD.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.LICHEE.get()) {
                CSJAdvanceInit.HAS_LICHEE.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.BILUOCHUN_TEAS.get() || item == ChangShengJueItems.LONG_JING_TEAS.get()) {
                CSJAdvanceInit.HAS_TEA.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.SHI_LI_XIANG.get() || item == ChangShengJueItems.FEN_JIU.get() || item == ChangShengJueItems.WHEAT_NUGGETS_TRIBUTE_WINE.get()) {
                CSJAdvanceInit.HAS_WINE.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.TOMATO_EGG.get()) {
                CSJAdvanceInit.HAS_TOMATO_EGG.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.TU_LONG_DAO.get() || item == ChangShengJueItems.YI_TIAN_JIAN.get() || item == ChangShengJueItems.BA_WANG_QIANG.get() || item == ChangShengJueItems.BEAT_DOG_STICK.get()) {
                CSJAdvanceInit.HAS_SWORD.trigger(serverPlayer);
                continue;
            }
            if (item == Items.f_42408_ || item == ChangShengJueItems.FEMALE_TAOIST_CHESTPLATE.get() || item == ChangShengJueItems.MALE_TAOIST_CHESTPLATE.get() || item == ChangShengJueItems.MALE_CHINESE_WEDDING_DRESS_KYLIN_BUFU.get() || item == ChangShengJueItems.FEMALE_CHINESE_WEDDING_DRESS_QUEEN_CLOTHING.get() || item == ChangShengJueItems.CONFUCIAN_INK_CHESTPLATE.get()) {
                CSJAdvanceInit.HAS_ARMOR.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.COTTON_CHESTPLATE.get() || item == ChangShengJueItems.MOUNTAIN_PATTERN_ARMOR.get() || item == ChangShengJueItems.FLY_FISH_CHESTPLATE.get() || item == ChangShengJueItems.WALKER_CHESTPLATE.get() || item == ChangShengJueItems.THE_GREAT_GENERAL_MING_GUANG_LIGHT_CHESTPLATE.get()) {
                CSJAdvanceInit.HAS_ADVANCED_ARRMOR.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.PHOENIX_FEATHER_CAP.get()) {
                hasQiTianHelmet = true;
                if (!hasQiTianHelmet || !hasQiTianChestplate || !hasQiTianLeggings || !hasQiTianBoots) continue;
                CSJAdvanceInit.HAS_QI_TIAN.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.OLDEN_CHAIN_MAIL_SHIRT.get()) {
                hasQiTianChestplate = true;
                if (!hasQiTianHelmet || !hasQiTianChestplate || !hasQiTianLeggings || !hasQiTianBoots) continue;
                CSJAdvanceInit.HAS_QI_TIAN.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.TIGER_SKIN_GARMENT.get()) {
                hasQiTianLeggings = true;
                if (!hasQiTianHelmet || !hasQiTianChestplate || !hasQiTianLeggings || !hasQiTianBoots) continue;
                CSJAdvanceInit.HAS_QI_TIAN.trigger(serverPlayer);
                continue;
            }
            if (item == ChangShengJueItems.CLOUD_WALKING_BOOTS.get()) {
                hasQiTianBoots = true;
                if (!hasQiTianHelmet || !hasQiTianChestplate || !hasQiTianLeggings || !hasQiTianBoots) continue;
                CSJAdvanceInit.HAS_QI_TIAN.trigger(serverPlayer);
                continue;
            }
            if (item != ChangShengJueItems.GANG_TOKEN.get() || itemStack.m_41613_() != 64) continue;
            CSJAdvanceInit.A_GROUP_GANG_TOKEN.trigger(serverPlayer);
        }
    }

    public static void summonBandit(Level level, Player player) {
        if (!((Boolean)ChangShengJueConfig.ENABLE_BANDIT_SPAWN.get()).booleanValue() || level.m_5776_()) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        int summonCount = summonTracker.getOrDefault(playerUUID, 0);
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (summonCount >= 3) {
            return;
        }
        BlockPos pos = player.m_20183_();
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos playerPos = player.m_20183_();
        RandomSource random = serverLevel.m_213780_();
        if (serverLevel.m_213780_().m_188503_(100) <= 20) {
            int numberOfBandits = RandomSource.m_216327_().m_188503_(3) + 1;
            for (int i = 0; i < numberOfBandits; ++i) {
                Bandit bandit;
                BlockPos spawnPos = CSJAdvanceEvent.findValidSpawnPosition(serverLevel, playerPos, random, 20);
                if (spawnPos == null) {
                    spawnPos = new BlockPos(playerPos.m_123341_() + random.m_188503_(10) - 5, playerPos.m_123342_() + random.m_188503_(10) - 5, playerPos.m_123343_());
                }
                if ((bandit = new Bandit((EntityType<? extends AbstractWuXiaMonster>)((EntityType)ChangShengJueEntity.BANDIT.get()), (Level)serverLevel)) == null) continue;
                bandit.m_20035_(spawnPos, 5.0f, 5.0f);
                bandit.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(pos), MobSpawnType.EVENT, null, null);
                serverLevel.m_7967_((Entity)bandit);
                COOLDOWN = 0;
                summonTracker.put(playerUUID, summonCount + 1);
            }
        }
    }

    public static void summonChallenger(Level level, Player player) {
        if (level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos playerPos = player.m_20183_();
        RandomSource random = serverLevel.m_213780_();
        if (random.m_188503_(100) <= 20) {
            int numberOfChallengers = 1;
            for (int i = 0; i < numberOfChallengers; ++i) {
                Challenger challenger;
                BlockPos spawnPos = CSJAdvanceEvent.findValidSpawnPosition(serverLevel, playerPos, random, 5);
                if (spawnPos == null) {
                    spawnPos = playerPos.m_7918_(random.m_188503_(31) - 15, 0, random.m_188503_(31) - 15);
                }
                if ((challenger = new Challenger((EntityType<? extends AbstractWuXia>)((EntityType)ChangShengJueEntity.CHALLENGER.get()), (Level)serverLevel)) == null) continue;
                challenger.m_20035_(spawnPos, random.m_188501_() * 360.0f, 0.0f);
                challenger.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(spawnPos), MobSpawnType.EVENT, null, null);
                serverLevel.m_7967_((Entity)challenger);
            }
        }
    }

    private static BlockPos findValidSpawnPosition(ServerLevel level, BlockPos playerPos, RandomSource random, int range) {
        for (int attempt = 0; attempt < 10; ++attempt) {
            int z;
            int x = playerPos.m_123341_() + random.m_188503_(2 * range + 1) - range;
            BlockPos surfacePos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z = playerPos.m_123343_() + random.m_188503_(2 * range + 1) - range));
            BlockState groundState = level.m_8055_(surfacePos.m_7495_());
            if (!groundState.m_60804_((BlockGetter)level, surfacePos.m_7495_()) || level.m_8055_(surfacePos).m_60804_((BlockGetter)level, surfacePos) || level.m_8055_(surfacePos.m_7494_()).m_60804_((BlockGetter)level, surfacePos.m_7494_())) continue;
            return surfacePos;
        }
        return null;
    }

    public static void CheckLevel(int level, ServerPlayer player, int count, int maxLevel) {
        if (level >= 1) {
            CSJAdvanceEvent.CheckLevel(level, player, maxLevel);
        }
        if (count == 1) {
            CSJAdvanceInit.USE_WAI_GONG.trigger(player);
        }
    }

    public static void CheckLevel(int level, ServerPlayer player, int maxLevel) {
        if (level == 1) {
            CSJAdvanceInit.MATER_GONG_FA.trigger(player);
        } else if (level >= maxLevel) {
            CSJAdvanceInit.MATER_GONG_FA.trigger(player);
            CSJAdvanceInit.GONG_FA_DONE.trigger(player);
        }
    }

    public static void handleSpecialQuestReward(ServerPlayer player, Quest quest) {
        int needCount;
        UUID TOU_MING_ZHUANG = UUID.fromString("c4ac1553-b219-4e7c-a54d-e274f9815109");
        UUID JIU_MING_XIA_YI = UUID.fromString("7dc9c671-ec29-4f3f-9467-5324fa026499");
        UUID ZHAI_FAN = UUID.fromString("33954498-78EF-492C-9338-B2E85C0AD184");
        UUID TIAN_RUO_YOU_QING = UUID.fromString("b005b283-34fa-4217-b417-866d830ccda8");
        UUID CHU_BAO_AN_LIANG = UUID.fromString("066905EA-4B2D-408D-A86E-9D37F450B729");
        UUID questId = quest.getQuestId();
        Set<UUID> firstGroupQuests = Set.of(TOU_MING_ZHUANG, JIU_MING_XIA_YI, ZHAI_FAN);
        if (firstGroupQuests.contains(questId)) {
            CSJAdvanceInit.FINISH_TASK.trigger(player);
        } else if (TIAN_RUO_YOU_QING.equals(questId)) {
            CSJAdvanceInit.DONE_FINAL_TASK.trigger(player);
        } else if (CHU_BAO_AN_LIANG.equals(questId) && (needCount = quest.getNeedCompletionCount()) == 5) {
            CSJAdvanceInit.DONE_FIVE_TASK.trigger(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerOpenBook(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack itemStack = event.getItemStack();
            if (!ModList.get().isLoaded("patchouli")) {
                return;
            }
            CompoundTag itemnbt = itemStack.m_41783_();
            if (itemnbt == null) {
                return;
            }
            if (itemnbt.m_128441_("patchouli:book") && itemnbt.m_128461_("patchouli:book").equals("chang_sheng_jue:wufanglu")) {
                CSJAdvanceInit.MI_CHANG_SHENG.trigger(player2);
            }
        }
    }
}

