/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.event.quest;

import com.shengchanshe.chang_sheng_jue.ChangShengJueConfig;
import com.shengchanshe.chang_sheng_jue.capability.quest.PlayerQuestCapabilityProvider;
import com.shengchanshe.chang_sheng_jue.effect.ChangShengJueEffects;
import com.shengchanshe.chang_sheng_jue.entity.custom.tiger.Tiger;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.AbstractWuXiaMonster;
import com.shengchanshe.chang_sheng_jue.entity.villagers.ChangShengJueVillagerEntity;
import com.shengchanshe.chang_sheng_jue.entity.villagers.ChangShengJueVillagers;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import com.shengchanshe.chang_sheng_jue.quest.QuestManager;
import com.shengchanshe.chang_sheng_jue.util.TimeDetection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class PlayerQuestEvent {
    public static final UUID FIRST_VILLAGER_QUEST_ID = UUID.fromString("2b0fedb0-2b4d-4b24-81fb-c4b6c8a47fa7");
    public static final UUID KUAI_YI_EN_CHOU_QUEST_ID = UUID.fromString("584DF3EE-BD1A-44C1-B66D-5F1015AF8A0E");
    private static final UUID WEI_MIN_CHU_HAI_QUEST_ID = UUID.fromString("3A54CDE8-91B4-42A8-9F37-9C40934A15C8");
    private static final UUID CHU_BAO_AN_LIANG_QUEST_ID = UUID.fromString("066905EA-4B2D-408D-A86E-9D37F450B729");
    private static final UUID LARGE_TRANSACTIONS_A_QUEST_ID = UUID.fromString("7C19EB4E-6E86-41B1-A397-36F7572D383B");
    private static final UUID LARGE_TRANSACTIONS_B_QUEST_ID = UUID.fromString("0A9301D6-0B79-4346-A700-35E7C8339658");
    public static final UUID MARTIAL_ARTS_QUEST_ID = UUID.fromString("C8DA8DB7-2AE8-4FB0-9956-179D9D9D1CA8");
    public static final UUID REN_WO_XING_QUEST_ID = UUID.fromString("dab3e694-291c-4b58-8ed2-4b215fbcf543");
    private static final UUID CHU_QIANG_FU_RUO_QUEST_ID = UUID.fromString("D8633102-1BC2-47D4-A9D4-311A28860F7D");
    private static final UUID JIANG_HU_ZHUI_SHA_LING_QUEST_ID = UUID.fromString("4ECF3936-B0F7-4F78-90FE-C7E613A08916");
    private static final UUID AO_QI_TINA_DI_JIAN_QUEST_ID = UUID.fromString("edd0cd54-c00c-43b7-aa4c-105e949cf883");
    private static final UUID TIAN_RUO_YOU_QIANG_TIN_YI_LAO_QUEST_ID = UUID.fromString("b005b283-34fa-4217-b417-866d830ccda8");
    public static final UUID VEGETARIAN_FOOD_QUEST_ID = UUID.fromString("33954498-78EF-492C-9338-B2E85C0AD184");

    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_9236_().f_46443_) {
                return;
            }
            player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
                List<Quest> quests = cap.getQuests(player.m_20148_());
                Optional<Quest> existingUncompleted = quests.stream().filter(Objects::nonNull).filter(quest -> quest.getQuestId().equals(AO_QI_TINA_DI_JIAN_QUEST_ID) || quest.getQuestId().equals(REN_WO_XING_QUEST_ID)).findFirst();
                if (existingUncompleted.isPresent()) {
                    Quest quest2 = existingUncompleted.get();
                    if (REN_WO_XING_QUEST_ID.equals(quest2.getQuestId())) {
                        quest2.setQuestCurrentDay(0);
                    }
                    if (AO_QI_TINA_DI_JIAN_QUEST_ID.equals(quest2.getQuestId()) && !quest2.canComplete(player) && quest2.getQuestCurrentTime() < quest2.getQuestTime()) {
                        cap.removeQuestFromPlayer(player.m_20148_(), quest2.getQuestId());
                        player.m_213846_(PlayerQuestEvent.getColoredTranslation("quest.chang_sheng_jue.fail", PlayerQuestEvent.getColoredTranslation(quest2.getQuestName(), new Object[0])));
                    }
                }
            });
        }
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        long currentTime = player.m_9236_().m_46468_() % 24000L;
        if (currentTime != 1L) {
            return;
        }
        player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
            int tianRuoYouQiangTinYiLaoCount;
            cap.triggerQuest(player, VEGETARIAN_FOOD_QUEST_ID, Float.valueOf(0.1f), null);
            if (!((Boolean)ChangShengJueConfig.ENABLE_QUESTS.get()).booleanValue()) {
                return;
            }
            cap.triggerQuest(player, JIANG_HU_ZHUI_SHA_LING_QUEST_ID, Float.valueOf(0.1f), null);
            cap.triggerQuest(player, REN_WO_XING_QUEST_ID, Float.valueOf(1.0f), null);
            int jiangHuZhuiShaLingCount = cap.getCompletionCount(JIANG_HU_ZHUI_SHA_LING_QUEST_ID);
            if (jiangHuZhuiShaLingCount >= 2) {
                cap.triggerQuest(player, TIAN_RUO_YOU_QIANG_TIN_YI_LAO_QUEST_ID, Float.valueOf(1.0f), null);
            }
            if ((tianRuoYouQiangTinYiLaoCount = cap.getCompletionCount(TIAN_RUO_YOU_QIANG_TIN_YI_LAO_QUEST_ID)) >= 1 && !player.m_21023_(ChangShengJueEffects.VILLAGER_CHARM_EFFECT.get())) {
                player.m_7292_(new MobEffectInstance(ChangShengJueEffects.VILLAGER_CHARM_EFFECT.get(), -1, 1, false, false, true));
            }
        });
    }

    public static void onEntityGenerate(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!((Boolean)ChangShengJueConfig.ENABLE_QUESTS.get()).booleanValue()) {
            return;
        }
        PlayerQuestEvent.entityGenerate(player, 200, JIANG_HU_ZHUI_SHA_LING_QUEST_ID, 3);
    }

    public static void entityGenerate(Player player, int tick, UUID questUUID, int count) {
        if (player.m_9236_().m_46467_() % (long)tick != 0L) {
            return;
        }
        player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
            Quest quest2;
            QuestManager instance = QuestManager.getInstance();
            List<Quest> quests = cap.getQuests(player.m_20148_());
            Optional<Quest> existingUncompleted = quests.stream().filter(Objects::nonNull).filter(quest -> quest.getQuestId().equals(questUUID)).findFirst();
            if (existingUncompleted.isPresent() && (quest2 = existingUncompleted.get()).getQuestCurrentTargetCount() < quest2.getQuestTargetCount() && !quest2.canComplete(player) && quest2.isComplete()) {
                instance.spawnTargetForQuest((ServerPlayer)player, quest2, quest2.getRequiredKills() / count);
                quest2.setQuestCurrentTargetCount(quest2.getQuestCurrentTargetCount() + 1);
            }
        });
    }

    public static void onVillagerInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof ChangShengJueVillagerEntity)) {
            return;
        }
        ChangShengJueVillagerEntity villager = (ChangShengJueVillagerEntity)entity;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!((Boolean)ChangShengJueConfig.ENABLE_QUESTS.get()).booleanValue()) {
            return;
        }
        if (villager.m_7141_().m_35571_() != ChangShengJueVillagers.CHANG_SHENG_JUE_CHIEF.get()) {
            return;
        }
        player2.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
            cap.triggerQuest((Player)player2, CHU_QIANG_FU_RUO_QUEST_ID, Float.valueOf(0.3f), null);
            if ((double)player2.m_217043_().m_188501_() < 0.5) {
                float triggerChance = cap.isQuestAccepted(CHU_BAO_AN_LIANG_QUEST_ID) ? 0.2f : 0.5f;
                cap.triggerQuest((Player)player2, CHU_BAO_AN_LIANG_QUEST_ID, Float.valueOf(triggerChance), null);
            } else {
                List<Quest> quests = cap.getQuests(player2.m_20148_());
                Optional<Quest> existingUncompleted = quests.stream().filter(Objects::nonNull).filter(quest -> quest.getQuestId().equals(LARGE_TRANSACTIONS_A_QUEST_ID) || quest.getQuestId().equals(LARGE_TRANSACTIONS_B_QUEST_ID)).findFirst();
                if (existingUncompleted.isEmpty()) {
                    float triggerChance = cap.isQuestAccepted(CHU_BAO_AN_LIANG_QUEST_ID) ? 0.2f : 0.5f;
                    UUID newQuestId = player2.m_217043_().m_188499_() ? LARGE_TRANSACTIONS_A_QUEST_ID : LARGE_TRANSACTIONS_B_QUEST_ID;
                    cap.triggerQuest((Player)player2, newQuestId, Float.valueOf(triggerChance), null);
                }
            }
        });
    }

    public static void onTrackingStart(PlayerEvent.StartTracking event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (!((Boolean)ChangShengJueConfig.ENABLE_QUESTS.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        Entity target = event.getTarget();
        BlockPos blockPos = player.m_20183_();
        ServerLevel level = (ServerLevel)player.m_9236_();
        if (target instanceof Villager) {
            player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> cap.triggerQuest(player, FIRST_VILLAGER_QUEST_ID, Float.valueOf(1.0f), null));
        }
        if (target instanceof Tiger) {
            player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
                float triggerChance = cap.isQuestAccepted(WEI_MIN_CHU_HAI_QUEST_ID) ? 0.05f : 0.75f;
                cap.triggerQuest(player, WEI_MIN_CHU_HAI_QUEST_ID, Float.valueOf(triggerChance), null);
            });
        } else if (target instanceof Zombie) {
            player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
                if (TimeDetection.isFullNight(player.m_9236_()) && (level.m_8802_(blockPos) || PlayerQuestEvent.isPlayerInVillage(player))) {
                    cap.triggerQuest(player, MARTIAL_ARTS_QUEST_ID, Float.valueOf(0.25f), null);
                }
            });
        }
    }

    public static boolean isPlayerInVillage(Player player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PoiManager poiManager = serverLevel.m_8904_();
            Optional nearestVillageCenter = poiManager.m_27192_(holder -> holder.m_203656_(PoiTypeTags.f_215876_), player.m_20183_(), 64, PoiManager.Occupancy.ANY);
            AABB searchBox = new AABB(player.m_20183_()).m_82400_(64.0);
            boolean hasVillager = !serverLevel.m_6443_(Villager.class, searchBox, v -> !v.m_6162_()).isEmpty();
            long beds = poiManager.m_27121_(holder -> holder.m_203565_(PoiTypes.f_218060_), player.m_20183_(), 64, PoiManager.Occupancy.HAS_SPACE);
            return nearestVillageCenter.isPresent() && beds >= 1L && hasVillager;
        }
        return false;
    }

    public static void onEntityHurt(LivingDamageEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (!((Boolean)ChangShengJueConfig.ENABLE_QUESTS.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Mob mob;
            Player player = (Player)livingEntity;
            Entity entity = event.getSource().m_7639_();
            if (!(!(entity instanceof Mob) || (mob = (Mob)entity) instanceof AbstractWuXiaMonster || mob instanceof Creeper || mob instanceof Spider || mob instanceof Silverfish || mob instanceof Endermite)) {
                player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> cap.triggerQuest(player, KUAI_YI_EN_CHOU_QUEST_ID, Float.valueOf(0.05f), mob.m_20148_()));
            }
        }
    }

    public static Component getColoredTranslation(String key, Object ... args) {
        String raw = Component.m_237110_((String)key, (Object[])args).getString();
        return Component.m_237113_((String)raw);
    }
}

