/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.event.quest;

import com.shengchanshe.chang_sheng_jue.ChangShengJue;
import com.shengchanshe.chang_sheng_jue.capability.quest.PlayerQuestCapabilityProvider;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.playerquest.ClientQuestDataCache;
import com.shengchanshe.chang_sheng_jue.effect.ChangShengJueEffects;
import com.shengchanshe.chang_sheng_jue.event.quest.PlayerQuestEvent;
import com.shengchanshe.chang_sheng_jue.init.CSJAdvanceInit;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import com.shengchanshe.chang_sheng_jue.quest.QuestManager;
import com.shengchanshe.chang_sheng_jue.util.TimeDetection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;

public class QuestEvent {
    public static final UUID PROTECT_THE_VILLAGE_QUEST_ID = UUID.fromString("85248ab7-ff1b-4d4d-8a05-92d5360e70eb");
    public static final UUID XING_XIA_ZHANG_YI_QUEST_ID = UUID.fromString("a35c7c77-6920-43c0-abaa-94763adfaa10");

    public static void onEntityDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_9236_().f_46443_) {
                return;
            }
            UUID playerId = player.m_20148_();
            player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
                LivingEntity entity = event.getEntity();
                List<Quest> currentQuest = cap.getQuests(playerId);
                for (Quest quest2 : currentQuest) {
                    ServerPlayer serverPlayer;
                    ServerLevel level;
                    BlockPos blockpos;
                    if (quest2 == null || quest2.getQuestType() != Quest.QuestType.KILL) continue;
                    if (quest2.getSecondTargetEntity() != null && !quest2.getSecondTargetEntity().isEmpty()) {
                        if (quest2.getCurrentKills() < quest2.getRequiredKills()) {
                            if (quest2.matchesEntity((Entity)entity)) {
                                if (quest2.getQuestId().equals(PlayerQuestEvent.MARTIAL_ARTS_QUEST_ID)) {
                                    blockpos = player.m_20183_();
                                    level = (ServerLevel)player.m_9236_();
                                    if (level.m_8802_(blockpos) && TimeDetection.isFullNight(player.m_9236_())) {
                                        quest2.incrementKills();
                                    }
                                } else {
                                    quest2.incrementKills();
                                }
                            } else if (quest2.getQuestId().equals(PlayerQuestEvent.KUAI_YI_EN_CHOU_QUEST_ID) && quest2.getQuestNpcId() != null && entity.m_20148_().equals(quest2.getQuestNpcId())) {
                                quest2.incrementKills();
                            }
                            if (!quest2.canComplete(player)) continue;
                            player.m_213846_(QuestEvent.getColoredTranslation("quest.chang_sheng_jue.finish", QuestEvent.getColoredTranslation(quest2.getQuestName(), new Object[0])));
                            if (!Objects.equals(quest2.getQuestName(), "\u6551\u6c11\u4fa0\u533b") || !Objects.equals(quest2.getQuestName(), "\u6295\u540d\u72b6") || !Objects.equals(quest2.getQuestName(), "\u658b\u996d") || !(player instanceof ServerPlayer)) continue;
                            serverPlayer = (ServerPlayer)player;
                            CSJAdvanceInit.FINISH_TASK.trigger(serverPlayer);
                            continue;
                        }
                        if (quest2.getSecondCurrentKills() >= quest2.getSecondRequiredKills()) continue;
                        if (quest2.matchesSecondEntity((Entity)entity)) {
                            quest2.secondIncrementKills();
                        }
                        if (!quest2.canComplete(player)) continue;
                        player.m_213846_(QuestEvent.getColoredTranslation("quest.chang_sheng_jue.finish", QuestEvent.getColoredTranslation(quest2.getQuestName(), new Object[0])));
                        continue;
                    }
                    if (quest2.getCurrentKills() >= quest2.getRequiredKills()) continue;
                    if (quest2.matchesEntity((Entity)entity)) {
                        if (quest2.getQuestId().equals(PlayerQuestEvent.MARTIAL_ARTS_QUEST_ID)) {
                            blockpos = player.m_20183_();
                            level = (ServerLevel)player.m_9236_();
                            if (level.m_8802_(blockpos) && TimeDetection.isFullNight(player.m_9236_())) {
                                quest2.incrementKills();
                            }
                        } else {
                            quest2.incrementKills();
                        }
                    } else if (quest2.getQuestId().equals(PlayerQuestEvent.KUAI_YI_EN_CHOU_QUEST_ID) && quest2.getQuestNpcId() != null && entity.m_20148_().equals(quest2.getQuestNpcId())) {
                        quest2.incrementKills();
                    }
                    if (!quest2.canComplete(player)) continue;
                    player.m_213846_(QuestEvent.getColoredTranslation("quest.chang_sheng_jue.finish", QuestEvent.getColoredTranslation(quest2.getQuestName(), new Object[0])));
                    if (!Objects.equals(quest2.getQuestName(), "\u6551\u6c11\u4fa0\u533b") || !Objects.equals(quest2.getQuestName(), "\u6295\u540d\u72b6") || !Objects.equals(quest2.getQuestName(), "\u658b\u996d") || !(player instanceof ServerPlayer)) continue;
                    serverPlayer = (ServerPlayer)player;
                    CSJAdvanceInit.FINISH_TASK.trigger(serverPlayer);
                }
                if (entity instanceof Villager && player.m_21023_(ChangShengJueEffects.VILLAGER_CHARM_EFFECT.get())) {
                    player.m_21195_(ChangShengJueEffects.VILLAGER_CHARM_EFFECT.get());
                    player.m_7292_(new MobEffectInstance(ChangShengJueEffects.INSTANT_DISFAVOR_EFFECT.get(), 1, 10, false, true));
                }
                if (entity instanceof Animal) {
                    QuestManager manager = QuestManager.getInstance();
                    if (manager == null) {
                        ChangShengJue.LOGGER.warn("QuestManager\u6216PlayerUUID\u4e3a\u7a7a");
                        return;
                    }
                    manager.getPlayerQuests(player.m_9236_(), playerId).stream().filter(Objects::nonNull).filter(quest -> PlayerQuestEvent.VEGETARIAN_FOOD_QUEST_ID.equals(quest.getQuestId())).findFirst().ifPresent(quest -> {
                        if (quest.canComplete(player)) {
                            quest.setQuestCurrentDay(0);
                        }
                    });
                }
                cap.syncToClient((ServerPlayer)player);
            });
        }
    }

    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            ServerLevel level = (ServerLevel)player.m_9236_();
            Raid raid = level.m_8832_(player.m_20183_());
            player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
                List<Quest> quests = cap.getQuests(player.m_20148_());
                Optional<Quest> existingUncompleted = quests.stream().filter(Objects::nonNull).findFirst();
                if (existingUncompleted.isPresent()) {
                    Quest quest = existingUncompleted.get();
                    if (quest.getAcceptedBy() != null && quest.getAcceptedBy().equals(player.m_20148_()) && quest.getQuestId().equals(PROTECT_THE_VILLAGE_QUEST_ID)) {
                        if (raid != null && raid.m_37767_() && !quest.isComplete()) {
                            quest.setComplete(true);
                            if (quest.canComplete((Player)player)) {
                                player.m_213846_(QuestEvent.getColoredTranslation("quest.chang_sheng_jue.finish", QuestEvent.getColoredTranslation(quest.getQuestName(), new Object[0])));
                            }
                        }
                    } else if (quest.getQuestId().equals(XING_XIA_ZHANG_YI_QUEST_ID) && quest.getAcceptedBy() != null && quest.getAcceptedBy().equals(player.m_20148_()) && !player.m_5833_()) {
                        if (!quest.isComplete() && !level.m_46461_()) {
                            if (level.m_8802_(player.m_20183_()) && !level.m_204166_(player.m_20183_()).m_203656_(BiomeTags.f_215805_)) {
                                float f = level.m_46942_(0.0f);
                                VillageSiege siege = new VillageSiege();
                                if ((double)f >= 0.5 && (double)f < 0.503) {
                                    siege.f_26999_ = VillageSiege.State.SIEGE_TONIGHT;
                                }
                                siege.m_7995_(level, true, false);
                            }
                        } else if (!quest.isComplete()) {
                            float f = level.m_46942_(0.0f);
                            if ((double)f >= 0.0 && level.m_8802_(player.m_20183_()) && !level.m_204166_(player.m_20183_()).m_203656_(BiomeTags.f_215805_)) {
                                quest.setComplete(true);
                            }
                            if (quest.canComplete((Player)player)) {
                                player.m_213846_(QuestEvent.getColoredTranslation("quest.chang_sheng_jue.finish", QuestEvent.getColoredTranslation(quest.getQuestName(), new Object[0])));
                            }
                        }
                    }
                }
            });
        }
    }

    public static void onGoldenAppleUse(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof ZombieVillager) {
            ZombieVillager zombie = (ZombieVillager)entity;
            if (event.getItemStack().m_150930_(Items.f_42436_) && (entity = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                zombie.getPersistentData().m_128362_("CuringPlayer", player.m_20148_());
            }
        }
    }

    public static void onCureComplete(LivingConversionEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ZombieVillager) {
            ZombieVillager oldZombie = (ZombieVillager)livingEntity;
            livingEntity = event.getOutcome();
            if (livingEntity instanceof Villager) {
                Villager villager = (Villager)livingEntity;
                UUID playerId = oldZombie.getPersistentData().m_128342_("CuringPlayer");
                ServerPlayer player = (ServerPlayer)villager.m_9236_().m_46003_(playerId);
                if (player != null) {
                    player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
                        Quest quest2;
                        List<Quest> quests = cap.getQuests(player.m_20148_());
                        Optional<Quest> existingUncompleted = quests.stream().filter(Objects::nonNull).filter(quest -> quest.getQuestType() == Quest.QuestType.TREAT).findFirst();
                        if (existingUncompleted.isPresent() && (quest2 = existingUncompleted.get()).getQuestType() == Quest.QuestType.TREAT && quest2.getAcceptedBy() != null && quest2.getAcceptedBy().equals(player.m_20148_())) {
                            quest2.setComplete(true);
                            if (quest2.canComplete((Player)player)) {
                                player.m_213846_(QuestEvent.getColoredTranslation("quest.chang_sheng_jue.finish", QuestEvent.getColoredTranslation(quest2.getQuestName(), new Object[0])));
                            }
                        }
                    });
                }
            }
        }
    }

    public static void onWorldUnload(LevelEvent.Unload event) {
        ClientQuestDataCache.get().clear();
    }

    public static Component getColoredTranslation(String key, Object ... args) {
        String raw = Component.m_237110_((String)key, (Object[])args).getString();
        return Component.m_237113_((String)raw);
    }
}

