/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.item.combat.armor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.shengchanshe.chang_sheng_jue.item.combat.armor.ArmorInterface;
import com.shengchanshe.chang_sheng_jue.item.combat.armor.inner_armor.GoldSilkSoftArmor;
import com.shengchanshe.chang_sheng_jue.item.combat.armor.inner_armor.InnerArmorInterface;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class ChangShengJueArmorItem
extends ArmorItem {
    private static final String INNER_ARMOR_TAG = "InnerArmorData";
    private static final String DAMAGE_REDUCTION_TAG = "DamageReduction";
    private static final String TRAUMA = "Trauma";
    private final RandomSource RANDOM_SOURCE = RandomSource.m_216327_();

    public ChangShengJueArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public ItemStack m_7968_() {
        CompoundTag tag;
        ItemStack stack = super.m_7968_();
        if (!(stack.m_41782_() && stack.m_41783_().m_128441_(DAMAGE_REDUCTION_TAG) || this.m_40402_() != EquipmentSlot.CHEST)) {
            tag = stack.m_41784_();
            tag.m_128350_(DAMAGE_REDUCTION_TAG, 30.0f);
        }
        if (!(stack.m_41782_() && stack.m_41783_().m_128441_(TRAUMA) || this.m_40402_() != EquipmentSlot.CHEST)) {
            tag = stack.m_41784_();
            tag.m_128350_(TRAUMA, 10.0f);
        }
        return stack;
    }

    private void ensureDamageReduction(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(DAMAGE_REDUCTION_TAG)) {
            float newReduction = (float)(150 + this.RANDOM_SOURCE.m_188503_(151)) / 10.0f;
            if (this.m_40402_() == EquipmentSlot.CHEST) {
                tag.m_128350_(DAMAGE_REDUCTION_TAG, Math.max(tag.m_128457_(DAMAGE_REDUCTION_TAG), newReduction));
            }
        }
    }

    private void ensureTrauma(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TRAUMA)) {
            float newReduction = (float)(50 + this.RANDOM_SOURCE.m_188503_(51)) / 10.0f;
            if (this.m_40402_() == EquipmentSlot.CHEST) {
                tag.m_128350_(TRAUMA, Math.max(tag.m_128457_(TRAUMA), newReduction));
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        this.ensureDamageReduction(stack);
        this.ensureTrauma(stack);
        return super.initCapabilities(stack, nbt);
    }

    public float getTrauma(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128457_(TRAUMA);
    }

    public boolean hasTrauma(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(TRAUMA);
    }

    public float getDamageReduction(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128457_(DAMAGE_REDUCTION_TAG) / 100.0f;
    }

    public boolean hasDamageReduction(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(DAMAGE_REDUCTION_TAG);
    }

    public boolean hasInnerArmor(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(INNER_ARMOR_TAG);
    }

    private void installInnerArmor(ItemStack armorStack, ItemStack innerArmor) {
        CompoundTag tag = armorStack.m_41784_();
        tag.m_128365_(INNER_ARMOR_TAG, (Tag)innerArmor.m_41739_(new CompoundTag()));
    }

    private Optional<ItemStack> getInnerArmorStack(ItemStack armorStack) {
        if (this.hasInnerArmor(armorStack)) {
            return Optional.of(ItemStack.m_41712_((CompoundTag)armorStack.m_41783_().m_128469_(INNER_ARMOR_TAG)));
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack armorStack = pPlayer.m_21120_(pHand);
        if (pLevel.f_46443_) return InteractionResultHolder.m_19096_((Object)armorStack);
        if (pPlayer.m_6144_()) {
            ItemStack stack = pPlayer.m_21206_();
            if (!this.hasInnerArmor(armorStack) && !stack.m_41619_() && stack.m_41720_() instanceof InnerArmorInterface) {
                if (this.m_40402_() == EquipmentSlot.CHEST) {
                    if (stack.m_41720_() instanceof GoldSilkSoftArmor && armorStack.m_41720_() instanceof ArmorInterface) {
                        pPlayer.m_5661_((Component)Component.m_237115_((String)"tooltip.chang_sheng_jue.inner_armor_data.no.lining").m_7220_((Component)stack.m_41786_().m_6881_()), true);
                        return InteractionResultHolder.m_19090_((Object)armorStack);
                    }
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"tooltip.chang_sheng_jue.inner_armor_data").m_7220_((Component)stack.m_41786_().m_6881_()), true);
                    this.installInnerArmor(armorStack, stack.m_255036_(1));
                    if (pPlayer.m_150110_().f_35937_) return InteractionResultHolder.m_19096_((Object)armorStack);
                    stack.m_41774_(1);
                    return InteractionResultHolder.m_19096_((Object)armorStack);
                } else {
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"tooltip.chang_sheng_jue.inner_armor_data.no.lining1").m_7220_((Component)stack.m_41786_().m_6881_()), true);
                }
                return InteractionResultHolder.m_19096_((Object)armorStack);
            } else {
                if (!this.hasInnerArmor(armorStack)) return super.m_7203_(pLevel, pPlayer, pHand);
                this.getInnerArmorStack(armorStack).ifPresent(innerStack -> {
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"tooltip.chang_sheng_jue.inner_armor_data.no.unload").m_7220_((Component)innerStack.m_41786_().m_6881_()), true);
                    if (!pPlayer.m_150109_().m_36054_(innerStack)) {
                        pPlayer.m_36176_(innerStack, false);
                    }
                    armorStack.m_41783_().m_128473_(INNER_ARMOR_TAG);
                });
            }
            return InteractionResultHolder.m_19096_((Object)armorStack);
        } else {
            ItemStack itemBySlot = pPlayer.m_6844_(EquipmentSlot.CHEST);
            if (!(itemBySlot.m_41720_() instanceof InnerArmorInterface) || this.m_40402_() != EquipmentSlot.CHEST) return super.m_7203_(pLevel, pPlayer, pHand);
            this.installInnerArmor(armorStack, itemBySlot.m_255036_(1));
            pPlayer.m_5661_((Component)Component.m_237115_((String)"tooltip.chang_sheng_jue.inner_armor_data").m_7220_((Component)itemBySlot.m_41786_().m_6881_()), true);
            if (pPlayer.m_150110_().f_35937_) return super.m_7203_(pLevel, pPlayer, pHand);
            itemBySlot.m_41774_(1);
            return super.m_7203_(pLevel, pPlayer, pHand);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        modifiers.putAll(super.getAttributeModifiers(slot, stack));
        if (slot == this.m_40402_() && this.hasInnerArmor(stack)) {
            this.getInnerArmorStack(stack).ifPresent(arg_0 -> this.lambda$getAttributeModifiers$1(stack, slot, (Multimap)modifiers, arg_0));
        }
        return modifiers;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (this.hasInnerArmor(pStack)) {
            ItemStack innerArmor = ItemStack.m_41712_((CompoundTag)pStack.m_41783_().m_128469_(INNER_ARMOR_TAG));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.chang_sheng_jue.inner_armor_data").m_7220_((Component)innerArmor.m_41786_().m_6881_()).m_130940_(ChatFormatting.GRAY));
        }
        if (this.hasDamageReduction(pStack)) {
            float reduction = pStack.m_41783_().m_128457_(DAMAGE_REDUCTION_TAG);
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.chang_sheng_jue.damage_reduction", (Object[])new Object[]{Float.valueOf(reduction)}).m_130940_(ChatFormatting.BLUE));
        }
        if (this.hasTrauma(pStack)) {
            float aFloat = pStack.m_41783_().m_128457_(TRAUMA);
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.chang_sheng_jue.trauma", (Object[])new Object[]{Float.valueOf(aFloat)}).m_130940_(ChatFormatting.BLUE));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    private /* synthetic */ void lambda$getAttributeModifiers$1(ItemStack stack, EquipmentSlot slot, Multimap modifiers, ItemStack innerItem) {
        Item patt8543$temp = innerItem.m_41720_();
        if (patt8543$temp instanceof ArmorItem) {
            ArmorItem innerArmor = (ArmorItem)patt8543$temp;
            double totalArmor = this.m_40401_().m_7366_(this.m_266204_()) + innerArmor.m_40404_();
            double totalToughness = this.m_40401_().m_6651_() + innerArmor.m_40401_().m_6651_();
            UUID slotUUID = UUID.nameUUIDFromBytes((stack.m_41778_() + slot.m_20751_()).getBytes());
            if (innerArmor instanceof GoldSilkSoftArmor) {
                totalArmor += 2.0;
                totalToughness += 4.0;
            }
            modifiers.replaceValues((Object)Attributes.f_22284_, (Iterable)ImmutableList.of((Object)new AttributeModifier(slotUUID, "CombinedArmor", totalArmor, AttributeModifier.Operation.ADDITION)));
            modifiers.replaceValues((Object)Attributes.f_22285_, (Iterable)ImmutableList.of((Object)new AttributeModifier(slotUUID, "CombinedToughness", totalToughness, AttributeModifier.Operation.ADDITION)));
        }
    }
}

