/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.item.combat.armor.qi_tian_da_sheng;

import com.shengchanshe.chang_sheng_jue.item.combat.armor.qi_tian_da_sheng.QiTianDaShengRender;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class QiTianDaSheng
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final String DAMAGE_REDUCTION_TAG = "DamageReduction";
    private static final String TRAUMA = "Trauma";
    private final int durabilityMultiplier;
    private final RandomSource RANDOM_SOURCE = RandomSource.m_216327_();

    public QiTianDaSheng(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties, int durabilityMultiplier) {
        super(pMaterial, pType, pProperties);
        this.durabilityMultiplier = durabilityMultiplier;
    }

    public int m_6473_() {
        return 15;
    }

    public int getMaxDamage(ItemStack stack) {
        int[] baseDurability = new int[]{13, 15, 16, 11};
        EquipmentSlot slot = this.m_40402_();
        return baseDurability[slot.m_20749_()] * this.durabilityMultiplier;
    }

    public ItemStack m_7968_() {
        CompoundTag tag;
        ItemStack stack = super.m_7968_();
        if (!(stack.m_41782_() && stack.m_41783_().m_128441_(DAMAGE_REDUCTION_TAG) || this.m_40402_() != EquipmentSlot.CHEST)) {
            tag = stack.m_41784_();
            tag.m_128350_(DAMAGE_REDUCTION_TAG, 40.0f);
        }
        if (!(stack.m_41782_() && stack.m_41783_().m_128441_(TRAUMA) || this.m_40402_() != EquipmentSlot.CHEST)) {
            tag = stack.m_41784_();
            tag.m_128350_(TRAUMA, 15.0f);
        }
        return stack;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    private void ensureTrauma(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (this.m_40402_() != EquipmentSlot.CHEST) {
            return;
        }
        if (!tag.m_128441_(TRAUMA)) {
            float newReduction = (float)(70 + this.RANDOM_SOURCE.m_188503_(81)) / 10.0f;
            tag.m_128350_(TRAUMA, Math.max(tag.m_128457_(TRAUMA), newReduction));
        }
    }

    private void ensureDamageReduction(ItemStack stack) {
        if (this.m_40402_() != EquipmentSlot.CHEST) {
            return;
        }
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(DAMAGE_REDUCTION_TAG)) {
            float newReduction = (float)(200 + this.RANDOM_SOURCE.m_188503_(201)) / 10.0f;
            CompoundTag tag = stack.m_41784_();
            tag.m_128350_(DAMAGE_REDUCTION_TAG, Math.max(newReduction, tag.m_128457_(DAMAGE_REDUCTION_TAG)));
        }
    }

    public float getDamageReduction(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128457_(DAMAGE_REDUCTION_TAG) / 100.0f;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        this.ensureDamageReduction(stack);
        this.ensureTrauma(stack);
        return super.initCapabilities(stack, nbt);
    }

    public boolean hasDamageReduction(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(DAMAGE_REDUCTION_TAG);
    }

    public float getTrauma(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128457_(TRAUMA);
    }

    public boolean hasTrauma(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(TRAUMA);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new QiTianDaShengRender();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 0, state -> state.setAndContinue(DefaultAnimations.IDLE))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (this.hasDamageReduction(pStack)) {
            float reduction = pStack.m_41783_().m_128457_(DAMAGE_REDUCTION_TAG);
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.chang_sheng_jue.damage_reduction", (Object[])new Object[]{Float.valueOf(reduction)}).m_130940_(ChatFormatting.BLUE));
        }
        if (this.hasTrauma(pStack)) {
            float aFloat = pStack.m_41783_().m_128457_(TRAUMA);
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.chang_sheng_jue.trauma", (Object[])new Object[]{Float.valueOf(aFloat)}).m_130940_(ChatFormatting.BLUE));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

