/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.item.combat.throwingknives;

import com.shengchanshe.chang_sheng_jue.ChangShengJueConfig;
import com.shengchanshe.chang_sheng_jue.capability.ChangShengJueCapabiliy;
import com.shengchanshe.chang_sheng_jue.entity.combat.throwingknives.ThrowingKnivesEntity;
import com.shengchanshe.chang_sheng_jue.item.ChangShengJueItems;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.external_kunfu.RelentlessThrowingKnives;
import com.shengchanshe.chang_sheng_jue.sound.ChangShengJueSound;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class FlyingDaggerPouch
extends Item {
    private static final String TAG_ITEMS = "StoredDaggers";

    public FlyingDaggerPouch() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.m_21120_(pUsedHand);
        if (!pPlayer.m_9236_().f_46443_) {
            List<ItemStack> daggers = FlyingDaggerPouch.getDaggers(itemstack);
            if (pPlayer.m_6144_()) {
                return this.tryTakeOutDagger(pPlayer.m_9236_(), pPlayer, itemstack, daggers);
            }
            pPlayer.m_6672_(pUsedHand);
        }
        return InteractionResultHolder.m_19098_((Object)pPlayer.m_21120_(pUsedHand));
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseDuration) {
        List<ItemStack> daggers = FlyingDaggerPouch.getDaggers(stack);
        if (user instanceof Player) {
            Player player = (Player)user;
            if (!world.f_46443_) {
                int usedTicks = this.m_8105_(stack) - remainingUseDuration;
                player.getCapability(ChangShengJueCapabiliy.KUNGFU).ifPresent(cap -> {
                    int swingTick = cap.getSwingTick((ServerPlayer)player, RelentlessThrowingKnives.KUNG_FU_ID.toString());
                    if (usedTicks >= swingTick && usedTicks >= 3) {
                        this.tryThrowDagger(player.m_9236_(), player, stack, daggers);
                    }
                });
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    private InteractionResultHolder<ItemStack> tryThrowDagger(Level level, Player player, ItemStack pouch, List<ItemStack> daggers) {
        if (daggers.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.chang_sheng_jue.dagger_pouch.empty"), true);
            return InteractionResultHolder.m_19100_((Object)pouch);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ChangShengJueSound.THROWING_KNIVES_SOUND.get(), SoundSource.PLAYERS, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
        if (!level.m_5776_()) {
            player.getCapability(ChangShengJueCapabiliy.KUNGFU).ifPresent(cap -> {
                cap.comprehendKungFu((ServerPlayer)player, RelentlessThrowingKnives.KUNG_FU_ID.toString(), (LivingEntity)player);
                if (cap.getKungFuLevel(RelentlessThrowingKnives.KUNG_FU_ID.toString()) >= 1 && cap.getCooldownTick(RelentlessThrowingKnives.KUNG_FU_ID.toString()) <= 0 && player.m_36324_().m_38702_() > 8 && player.m_36324_().m_38722_() > 0.0f) {
                    int throwingKnivesCount = cap.getThrowingKnivesCount(RelentlessThrowingKnives.KUNG_FU_ID.toString());
                    int i1 = Math.min(daggers.size(), throwingKnivesCount);
                    for (int i = 0; i < i1; ++i) {
                        ItemStack daggerStack = (ItemStack)daggers.get(daggers.size() - 1);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)daggerStack.m_41720_()));
                        daggerStack.m_41622_(1, (LivingEntity)player, pPlayer1 -> pPlayer1.m_21190_(player.m_7655_()));
                        ThrowingKnivesEntity dagger = new ThrowingKnivesEntity(level, (LivingEntity)player, daggerStack.m_41777_().m_41620_(1));
                        dagger.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f, 1.5f);
                        level.m_7967_((Entity)dagger);
                        if (!player.m_150110_().f_35937_) {
                            daggers.remove(daggers.size() - 1);
                        }
                        FlyingDaggerPouch.setDaggers(pouch, daggers);
                    }
                } else {
                    ItemStack daggerStack = (ItemStack)daggers.get(daggers.size() - 1);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)daggerStack.m_41720_()));
                    daggerStack.m_41622_(1, (LivingEntity)player, pPlayer1 -> pPlayer1.m_21190_(player.m_7655_()));
                    ThrowingKnivesEntity dagger = new ThrowingKnivesEntity(level, (LivingEntity)player, daggerStack.m_41777_().m_41620_(1));
                    dagger.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                    level.m_7967_((Entity)dagger);
                    if (!player.m_150110_().f_35937_) {
                        daggers.remove(daggers.size() - 1);
                    }
                    FlyingDaggerPouch.setDaggers(pouch, daggers);
                }
            });
        }
        return InteractionResultHolder.m_19090_((Object)pouch);
    }

    private InteractionResultHolder<ItemStack> tryTakeOutDagger(Level level, Player player, ItemStack pouch, List<ItemStack> daggers) {
        if (daggers.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.chang_sheng_jue.dagger_pouch.empty"), true);
            return InteractionResultHolder.m_19100_((Object)pouch);
        }
        if (!level.m_5776_()) {
            ItemStack daggerToGive = daggers.remove(daggers.size() - 1).m_41777_();
            if (player.m_150109_().m_36054_(daggerToGive)) {
                FlyingDaggerPouch.setDaggers(pouch, daggers);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
                return InteractionResultHolder.m_19090_((Object)pouch);
            }
        }
        return InteractionResultHolder.m_19098_((Object)pouch);
    }

    public static List<ItemStack> getDaggers(ItemStack pouch) {
        ArrayList<ItemStack> daggers = new ArrayList<ItemStack>();
        CompoundTag tag = pouch.m_41784_();
        if (tag.m_128441_(TAG_ITEMS)) {
            ListTag itemsTag = tag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < itemsTag.size(); ++i) {
                daggers.add(ItemStack.m_41712_((CompoundTag)itemsTag.m_128728_(i)));
            }
        }
        return daggers;
    }

    public static void setDaggers(ItemStack pouch, List<ItemStack> daggers) {
        CompoundTag tag = pouch.m_41784_();
        ListTag itemsTag = new ListTag();
        for (ItemStack stack : daggers) {
            if (stack.m_41720_() != ChangShengJueItems.THROWING_KNIVES.get()) continue;
            itemsTag.add((Object)stack.m_41739_(new CompoundTag()));
        }
        tag.m_128365_(TAG_ITEMS, (Tag)itemsTag);
    }

    public static boolean tryAddDagger(ItemStack pouch, ItemStack dagger) {
        if (dagger.m_41720_() != ChangShengJueItems.THROWING_KNIVES.get()) {
            return false;
        }
        List<ItemStack> daggers = FlyingDaggerPouch.getDaggers(pouch);
        if (daggers.size() >= (Integer)ChangShengJueConfig.FLYING_DAGGER_POUCH_MAX_SLOTS.get()) {
            return false;
        }
        daggers.add(dagger.m_41777_().m_41620_(1));
        FlyingDaggerPouch.setDaggers(pouch, daggers);
        return true;
    }

    public boolean m_142207_(ItemStack pStack, Slot pSlot, ClickAction pAction, Player pPlayer) {
        ItemStack stackInSlot;
        if (pAction == ClickAction.SECONDARY && (stackInSlot = pSlot.m_7993_()).m_41720_() == ChangShengJueItems.THROWING_KNIVES.get() && FlyingDaggerPouch.tryAddDagger(pStack, stackInSlot)) {
            stackInSlot.m_41774_(1);
            pPlayer.m_9236_().m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack pouch, ItemStack carriedStack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && carriedStack.m_41720_() == ChangShengJueItems.THROWING_KNIVES.get() && FlyingDaggerPouch.tryAddDagger(pouch, carriedStack)) {
            carriedStack.m_41774_(1);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        List<ItemStack> daggers = FlyingDaggerPouch.getDaggers(stack);
        tooltip.add((Component)Component.m_237110_((String)"tooltip.chang_sheng_jue.dagger_pouch.count", (Object[])new Object[]{daggers.size(), ChangShengJueConfig.FLYING_DAGGER_POUCH_MAX_SLOTS.get()}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.chang_sheng_jue.flying_dagger_pouch.right_click.tooltip").m_130940_(ChatFormatting.GRAY));
        if (Screen.m_96638_()) {
            if (daggers.isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)"message.chang_sheng_jue.dagger_pouch.empty"));
            } else {
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.chang_sheng_jue.dagger_pouch.contents").m_130940_(ChatFormatting.GOLD));
                for (ItemStack dagger : daggers) {
                    Map enchants;
                    tooltip.add((Component)Component.m_237113_((String)" - ").m_7220_(dagger.m_41786_()));
                    if (dagger.m_41763_()) {
                        int damage = dagger.m_41773_();
                        int maxDurability = dagger.m_41776_();
                        tooltip.add((Component)Component.m_237113_((String)"   ").m_7220_((Component)Component.m_237110_((String)"tooltip.chang_sheng_jue.durability", (Object[])new Object[]{maxDurability - damage, maxDurability}).m_130940_(ChatFormatting.DARK_GREEN)));
                    }
                    if ((enchants = EnchantmentHelper.m_44831_((ItemStack)dagger)).isEmpty()) continue;
                    for (Map.Entry entry : enchants.entrySet()) {
                        tooltip.add((Component)Component.m_237113_((String)"   ").m_7220_(((Enchantment)entry.getKey()).m_44700_(((Integer)entry.getValue()).intValue())));
                    }
                }
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.chang_sheng_jue.hold_shift.tooltip"));
        }
    }
}

