/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.item.items;

import com.shengchanshe.chang_sheng_jue.item.ChangShengJueItems;
import com.shengchanshe.chang_sheng_jue.item.combat.armor.cotton.CottonArmor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Parcel
extends Item {
    private static final String TYPE_TAG = "ParcelType";
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final List<Supplier<Item>>[] PARCEL_CONTENTS = new List[ParcelType.values().length];

    public Parcel() {
        super(new Item.Properties().m_41487_(1));
    }

    public static ItemStack createParcel(ParcelType type) {
        ItemStack stack = new ItemStack((ItemLike)ChangShengJueItems.ARMOR_PARCEL.get());
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(TYPE_TAG, type.ordinal());
        return stack;
    }

    private ParcelType getParcelType(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(TYPE_TAG)) {
            return ParcelType.COTTON_ARMOR;
        }
        int typeOrdinal = stack.m_41783_().m_128451_(TYPE_TAG);
        return ParcelType.values()[typeOrdinal];
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            ParcelType type = this.getParcelType(stack);
            List<Supplier<Item>> contents = PARCEL_CONTENTS[type.ordinal()];
            for (Supplier<Item> itemSupplier : contents) {
                Item item;
                ItemStack itemStack = new ItemStack((ItemLike)itemSupplier.get());
                if (stack.m_41782_() && stack.m_41783_().m_128471_("ForceGolden") && (item = itemStack.m_41720_()) instanceof CottonArmor) {
                    CottonArmor cottonArmor = (CottonArmor)item;
                    cottonArmor.m_41115_(itemStack, 16766720);
                }
                if (player.m_36356_(itemStack)) continue;
                Containers.m_18992_((Level)level, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)itemStack);
            }
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public String m_5671_(ItemStack stack) {
        ParcelType type = this.getParcelType(stack);
        return "item.chang_sheng_jue.armor_parcel." + type.name().toLowerCase();
    }

    public static Collection<ItemStack> createParcel() {
        return new ArrayList<ItemStack>(Arrays.asList(Parcel.createCottonParcel(), Parcel.createMountainParcel(), Parcel.createMingguangParcel(), Parcel.createQitianParcel(), Parcel.createMaleTaoistParcel(), Parcel.createFemaleTaoistParcel(), Parcel.createMaleWeddingDressParcel(), Parcel.createFemaleWeddingDressParcel()));
    }

    public static ItemStack createCottonParcel() {
        return Parcel.createParcel(ParcelType.COTTON_ARMOR);
    }

    public static ItemStack createMountainParcel() {
        return Parcel.createParcel(ParcelType.MOUNTAIN_PATTERN);
    }

    public static ItemStack createMingguangParcel() {
        return Parcel.createParcel(ParcelType.MINGGUANG_ARMOR);
    }

    public static ItemStack createQitianParcel() {
        return Parcel.createParcel(ParcelType.QI_TIAN_DA_SHENG);
    }

    public static ItemStack createMaleTaoistParcel() {
        return Parcel.createParcel(ParcelType.MALE_TAOIST);
    }

    public static ItemStack createFemaleTaoistParcel() {
        return Parcel.createParcel(ParcelType.FEMALE_TAOIST);
    }

    public static ItemStack createMaleWeddingDressParcel() {
        return Parcel.createParcel(ParcelType.MALE_WEDDING_DRESS);
    }

    public static ItemStack createFemaleWeddingDressParcel() {
        return Parcel.createParcel(ParcelType.FEMALE_WEDDING_DRESS);
    }

    static {
        Parcel.PARCEL_CONTENTS[ParcelType.COTTON_ARMOR.ordinal()] = Arrays.asList(() -> RANDOM.m_188499_() ? (Item)ChangShengJueItems.COTTON_HELMET.get() : (Item)ChangShengJueItems.WHITE_COTTON_HELMET.get(), ChangShengJueItems.COTTON_CHESTPLATE, ChangShengJueItems.COTTON_LEGGINGS, ChangShengJueItems.COTTON_BOOTS);
        Parcel.PARCEL_CONTENTS[ParcelType.MOUNTAIN_PATTERN.ordinal()] = Arrays.asList(ChangShengJueItems.MOUNTAIN_PATTERN_HELMET_GUN_HOOD, ChangShengJueItems.MOUNTAIN_PATTERN_ARMOR, ChangShengJueItems.MOUNTAIN_PATTERN_DEERSKIN_TIBIAL_ARMOR, ChangShengJueItems.MOUNTAIN_PATTERN_CLOUD_BLACK_BOOTS);
        Parcel.PARCEL_CONTENTS[ParcelType.MINGGUANG_ARMOR.ordinal()] = Arrays.asList(ChangShengJueItems.THE_GREAT_GENERAL_MING_GUANG_PHOENIX_WINGS_HELMET, ChangShengJueItems.THE_GREAT_GENERAL_MING_GUANG_LIGHT_CHESTPLATE, ChangShengJueItems.THE_GREAT_GENERAL_MING_GUANG_LAZULI_KNEE_PADS, ChangShengJueItems.THE_GREAT_GENERAL_MING_GUANG_ANIMAL_SKIN_BOOTS);
        Parcel.PARCEL_CONTENTS[ParcelType.QI_TIAN_DA_SHENG.ordinal()] = Arrays.asList(ChangShengJueItems.PHOENIX_FEATHER_CAP, ChangShengJueItems.OLDEN_CHAIN_MAIL_SHIRT, ChangShengJueItems.TIGER_SKIN_GARMENT, ChangShengJueItems.CLOUD_WALKING_BOOTS);
        Parcel.PARCEL_CONTENTS[ParcelType.MALE_TAOIST.ordinal()] = Arrays.asList(ChangShengJueItems.MALE_TAOIST_HELMET, ChangShengJueItems.MALE_TAOIST_CHESTPLATE, ChangShengJueItems.TAOIST_LEGGINGS, ChangShengJueItems.TAOIST_BOOTS);
        Parcel.PARCEL_CONTENTS[ParcelType.FEMALE_TAOIST.ordinal()] = Arrays.asList(ChangShengJueItems.FEMALE_TAOIST_HELMET, ChangShengJueItems.FEMALE_TAOIST_CHESTPLATE, ChangShengJueItems.TAOIST_LEGGINGS, ChangShengJueItems.TAOIST_BOOTS);
        Parcel.PARCEL_CONTENTS[ParcelType.MALE_WEDDING_DRESS.ordinal()] = Arrays.asList(ChangShengJueItems.MALE_CHINESE_WEDDING_DRESS_BLACK_GAUZE_CAP, ChangShengJueItems.MALE_CHINESE_WEDDING_DRESS_KYLIN_BUFU, ChangShengJueItems.TAOIST_LEGGINGS, ChangShengJueItems.CHINESE_WEDDING_DRESS_GOLDEN_THREAD_SHOES);
        Parcel.PARCEL_CONTENTS[ParcelType.FEMALE_WEDDING_DRESS.ordinal()] = Arrays.asList(ChangShengJueItems.FEMALE_CHINESE_WEDDING_DRESS_PHOENIX_CORONET, ChangShengJueItems.FEMALE_CHINESE_WEDDING_DRESS_QUEEN_CLOTHING, ChangShengJueItems.TAOIST_LEGGINGS, ChangShengJueItems.CHINESE_WEDDING_DRESS_GOLDEN_THREAD_SHOES);
    }

    public static enum ParcelType {
        COTTON_ARMOR,
        MOUNTAIN_PATTERN,
        MINGGUANG_ARMOR,
        QI_TIAN_DA_SHENG,
        MALE_TAOIST,
        FEMALE_TAOIST,
        MALE_WEDDING_DRESS,
        FEMALE_WEDDING_DRESS;

    }
}

