/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.item.items;

import com.shengchanshe.chang_sheng_jue.tags.CSJTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class StructureIntelligence
extends Item {
    public static final int PIT_YARD_TYPE = 0;
    public static final int SANDSTONE_CASTLE_TYPE = 1;
    public static final int SI_HE_YUAN_TYPE = 2;
    public static final int SU_PAI_VILLAGE_TYPE = 3;
    public static final int HUI_PAI_VILLAGE_TYPE = 4;
    public static final int FORTRESSES_TYPE = 5;

    public StructureIntelligence(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        BlockPos pos;
        TagKey<Structure> structureTag;
        Player player;
        if (level.f_46443_) {
            return;
        }
        if (!(!(entity instanceof Player) || !(player = (Player)entity).m_21205_().equals(stack) && !player.m_21206_().equals(stack) || stack.m_41782_() && stack.m_41784_().m_128471_("found") || (structureTag = this.getStructureTag(stack)) == null || (pos = ((ServerLevel)level).m_215011_(structureTag, entity.m_20183_(), 100, false)) == null)) {
            this.bindPosition(stack, pos);
            this.sendDiscoveryMessage(entity, this.getStructureName(stack), pos);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && stack.m_41782_()) {
            BlockPos pos = new BlockPos(stack.m_41783_().m_128451_("posX"), player.m_146904_(), stack.m_41783_().m_128451_("posZ"));
            this.sendDiscoveryMessage((Entity)player, this.getStructureName(stack), pos);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private void bindPosition(ItemStack stack, BlockPos pos) {
        stack.m_41784_().m_128405_("posX", pos.m_123341_());
        stack.m_41784_().m_128405_("posZ", pos.m_123343_());
        stack.m_41784_().m_128379_("found", true);
    }

    private void sendDiscoveryMessage(Entity entity, Component structureName, BlockPos pos) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tooltip.chang_sheng_jue.structural_location", (Object[])new Object[]{pos.m_123341_(), pos.m_123343_(), structureName}).m_130940_(ChatFormatting.AQUA), true);
        }
    }

    private TagKey<Structure> getStructureTag(ItemStack stack) {
        return switch (stack.m_41773_()) {
            case 0 -> CSJTags.StructureTypes.PIT_YARD;
            case 1 -> CSJTags.StructureTypes.SANDSTONE_CASTLE;
            case 2 -> CSJTags.StructureTypes.SI_HE_YUAN;
            case 3 -> CSJTags.StructureTypes.SU_PAI_VILLAGE;
            case 4 -> CSJTags.StructureTypes.HUI_PAI_VILLAGE;
            case 5 -> CSJTags.StructureTypes.FORTRESSES;
            default -> null;
        };
    }

    private Component getStructureName(ItemStack stack) {
        return switch (stack.m_41773_()) {
            case 0 -> Component.m_237115_((String)"tooltip.chang_sheng_jue.pit_yard.tooltip");
            case 1 -> Component.m_237115_((String)"tooltip.chang_sheng_jue.sandstone_castle.tooltip");
            case 2 -> Component.m_237115_((String)"tooltip.chang_sheng_jue.si_he_yuan.tooltip");
            case 3 -> Component.m_237115_((String)"tooltip.chang_sheng_jue.su_pai_village.tooltip");
            case 4 -> Component.m_237115_((String)"tooltip.chang_sheng_jue.hui_pai_village.tooltip");
            case 5 -> Component.m_237115_((String)"tooltip.chang_sheng_jue.fortresses_type.tooltip");
            default -> Component.m_237115_((String)"tooltip.chang_sheng_jue.null.structure.tooltip");
        };
    }

    public Component m_7626_(ItemStack pStack) {
        int damage = pStack.m_41773_();
        return Component.m_237110_((String)(this.m_5524_() + "." + damage), (Object[])new Object[]{this.getStructureName(pStack)});
    }
}

