/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.martial_arts;

import com.shengchanshe.chang_sheng_jue.martial_arts.IKungFu;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.external_kunfu.DuguNineSwords;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.external_kunfu.GaoMarksmanship;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.external_kunfu.GeShanDaNiu;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.external_kunfu.GoldenBlackKnifeMethod;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.external_kunfu.RelentlessThrowingKnives;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.external_kunfu.ShaolinStickMethod;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.external_kunfu.SunflowerPointCaveman;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.external_kunfu.TurtleBreathWork;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.external_kunfu.XuannuSwordsmanship;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.internal_kungfu.GoldenBellJar;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.internal_kungfu.Hercules;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.internal_kungfu.ImmortalMiracle;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.internal_kungfu.Paoding;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.internal_kungfu.QianKunDaNuoYi;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.internal_kungfu.TheClassicsOfTendonChanging;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.internal_kungfu.WuGangCutGui;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.internal_kungfu.YugongMovesMountains;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.light_kungfu.TreadTheSnowWithoutTrace;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.mental_kungfu.WheatNuggetEncyclopedia;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.mental_kungfu.ZhangMenXinXue;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class KungFuRegistry {
    private final Map<String, Supplier<IKungFu>> registry = new ConcurrentHashMap<String, Supplier<IKungFu>>();

    private KungFuRegistry() {
        this.registerDefaults();
    }

    public static KungFuRegistry getInstance() {
        return Holder.INSTANCE;
    }

    public void register(String id, Supplier<IKungFu> supplier) {
        this.registry.put(id, supplier);
    }

    public Optional<IKungFu> getKungFu(String id) {
        return Optional.ofNullable(this.registry.get(id)).map(Supplier::get);
    }

    private void registerDefaults() {
        this.register(DuguNineSwords.KUNG_FU_ID.toString(), DuguNineSwords::new);
        this.register(GaoMarksmanship.KUNG_FU_ID.toString(), GaoMarksmanship::new);
        this.register(GeShanDaNiu.KUNG_FU_ID.toString(), GeShanDaNiu::new);
        this.register(GoldenBlackKnifeMethod.KUNG_FU_ID.toString(), GoldenBlackKnifeMethod::new);
        this.register(ShaolinStickMethod.KUNG_FU_ID.toString(), ShaolinStickMethod::new);
        this.register(SunflowerPointCaveman.KUNG_FU_ID.toString(), SunflowerPointCaveman::new);
        this.register(TurtleBreathWork.KUNG_FU_ID.toString(), TurtleBreathWork::new);
        this.register(XuannuSwordsmanship.KUNG_FU_ID.toString(), XuannuSwordsmanship::new);
        this.register(RelentlessThrowingKnives.KUNG_FU_ID.toString(), RelentlessThrowingKnives::new);
        this.register(GoldenBellJar.KUNG_FU_ID.toString(), GoldenBellJar::new);
        this.register(Hercules.KUNG_FU_ID.toString(), Hercules::new);
        this.register(ImmortalMiracle.KUNG_FU_ID.toString(), ImmortalMiracle::new);
        this.register(QianKunDaNuoYi.KUNG_FU_ID.toString(), QianKunDaNuoYi::new);
        this.register(TheClassicsOfTendonChanging.KUNG_FU_ID.toString(), TheClassicsOfTendonChanging::new);
        this.register(Paoding.KUNG_FU_ID.toString(), Paoding::new);
        this.register(WuGangCutGui.KUNG_FU_ID.toString(), WuGangCutGui::new);
        this.register(YugongMovesMountains.KUNG_FU_ID.toString(), YugongMovesMountains::new);
        this.register(WheatNuggetEncyclopedia.KUNG_FU_ID.toString(), WheatNuggetEncyclopedia::new);
        this.register(ZhangMenXinXue.KUNG_FU_ID.toString(), ZhangMenXinXue::new);
        this.register(TreadTheSnowWithoutTrace.KUNG_FU_ID.toString(), TreadTheSnowWithoutTrace::new);
    }

    public Set<String> getAllKungFuIds() {
        return Collections.unmodifiableSet(this.registry.keySet());
    }

    private static final class Holder {
        static final KungFuRegistry INSTANCE = new KungFuRegistry();

        private Holder() {
        }
    }
}

