/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.internal_kungfu;

import com.shengchanshe.chang_sheng_jue.effect.ChangShengJueEffects;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.KungFuConfig;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.KungFuType;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.internal_kungfu.AbstractionInternalkungfu;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class QianKunDaNuoYi
extends AbstractionInternalkungfu {
    public static final ResourceLocation KUNG_FU_ID = new ResourceLocation("chang_sheng_jue", "qian_kun_da_nuo_yi");
    private int recordTime = 0;
    private float recordDamage = 0.0f;
    private UUID recordDamageSource = UUID.randomUUID();
    private int maxCooldown = (Integer)KungFuConfig.QIAN_KUN_DA_NUO_YI_MAX_COOLDOWN.get();
    private int extraCooldown = 0;

    public QianKunDaNuoYi() {
        super(KUNG_FU_ID.toString(), (Component)Component.m_237115_((String)("item.chang_sheng_jue." + KUNG_FU_ID.m_135815_())).m_130940_(ChatFormatting.YELLOW), KungFuType.INTERNAL_KUNGFU, (Component)Component.m_237115_((String)"message.kungfu.chang_sheng_jue.hand_and_glove.type"), 0.15f, 2, 0.0f);
    }

    @Override
    public void onEntityTick(LivingEntity player) {
        if (this.recordTime > 0 && this.recordDamageSource != null && this.recordDamage != 0.0f) {
            --this.recordTime;
        }
        if (this.recordTime <= 0) {
            Optional<Entity> entityOpt = Optional.ofNullable(((ServerLevel)player.m_9236_()).m_8791_(this.recordDamageSource));
            entityOpt.ifPresent(entity -> {
                entity.m_6469_(new DamageSource((Holder)player.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(this.getDamageType()), (Entity)player), this.recordDamage);
                this.recordTime = (Integer)KungFuConfig.QIAN_KUN_DA_NUO_YI_BOUNCE_DAMAGE_TICK.get();
                this.recordDamage = 0.0f;
                this.recordDamageSource = UUID.randomUUID();
                this.extraCooldown = (Integer)KungFuConfig.QIAN_KUN_DA_NUO_YI_MAX_COOLDOWN_EXTRA_TICK.get();
                this.addMaxCoolDown();
            });
        }
        if (this.extraCooldown > 0) {
            --this.extraCooldown;
        }
    }

    @Override
    public void onEntityHurt(LivingDamageEvent event) {
    }

    @Override
    public void onAttackHurt(LivingAttackEvent event) {
        Entity entity;
        if (!this.isReady()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (this.randomSource.m_188501_() < this.getBounceDamageProbability(livingEntity) && (entity = event.getSource().m_7639_()) != null) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (!player.m_150110_().f_35937_) {
                    this.cooldown = this.maxCooldown - this.wheatNuggetsTributeWineEffect((LivingEntity)player);
                    int foodLevel = player.m_21023_(ChangShengJueEffects.SHI_LI_XIANG.get()) ? this.hunger - 1 : this.hunger;
                    player.m_36324_().m_38707_(-foodLevel, this.getSaturation());
                }
                this.addExp((LivingEntity)player, !player.m_150110_().f_35937_ ? 1 : this.getMaxExp());
                this.biluochunTeasAndLongJingTeasEffect((LivingEntity)player);
            }
            this.recordDamageSource = entity.m_20148_();
            this.recordTime = (Integer)KungFuConfig.QIAN_KUN_DA_NUO_YI_BOUNCE_DAMAGE_TICK.get();
            this.recordDamage = event.getAmount() * this.getBounceDamageMultiplier();
        }
    }

    @Override
    public void onInteranKungFu(Level pLevel, LivingEntity pEntity) {
    }

    public float getBounceDamageProbability(LivingEntity livingEntity) {
        float healthMax = livingEntity.m_21233_();
        float baseChance = (float)((Integer)KungFuConfig.QIAN_KUN_DA_NUO_YI_BOUNCE_DAMAGE_PROBABILITY.get()).intValue() / 100.0f;
        float healthBonus = (healthMax - 20.0f) * ((float)((Integer)KungFuConfig.QIAN_KUN_DA_NUO_YI_BOUNCE_DAMAGE_EXTRA_PROBABILITY.get()).intValue() / 100.0f);
        float totalChance = baseChance + Math.max(0.0f, healthBonus);
        return this.level < this.getMaxLevel() ? baseChance : totalChance;
    }

    public float getBounceDamageMultiplier() {
        if (this.level <= 2) {
            return (float)((Integer)KungFuConfig.QIAN_KUN_DA_NUO_YI_BOUNCE_DAMAGE_MULTIPLIER.get()).intValue() / 100.0f;
        }
        return (float)this.level * ((float)((Integer)KungFuConfig.QIAN_KUN_DA_NUO_YI_BOUNCE_DAMAGE_MULTIPLIER.get()).intValue() / 100.0f);
    }

    public void addMaxCoolDown() {
        this.maxCooldown += 20;
    }

    @Override
    public int getMaxCoolDown() {
        return this.maxCooldown;
    }

    @Override
    public int getMaxLevel() {
        return (Integer)KungFuConfig.QIAN_KUN_DA_NUO_YI_MAX_LEVEL.get();
    }

    @Override
    public int getMaxExp() {
        return (Integer)KungFuConfig.QIAN_KUN_DA_NUO_YI_MAX_EXP.get();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128405_("RecordTime", this.recordTime);
        tag.m_128350_("RecordDamage", this.recordDamage);
        tag.m_128362_("RecordDamageSource", this.recordDamageSource);
        tag.m_128405_("MaxCooldown", this.maxCooldown);
        tag.m_128405_("ExtraCooldown", this.extraCooldown);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.recordTime = tag.m_128451_("RecordTime");
        this.recordDamage = tag.m_128457_("RecordDamage");
        this.recordDamageSource = !tag.m_128441_("RecordDamageSource") ? UUID.randomUUID() : tag.m_128342_("RecordDamageSource");
        this.maxCooldown = tag.m_128451_("MaxCooldown");
        this.extraCooldown = tag.m_128451_("ExtraCooldown");
    }
}

