/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.light_kungfu;

import com.shengchanshe.chang_sheng_jue.effect.ChangShengJueEffects;
import com.shengchanshe.chang_sheng_jue.event.CSJAdvanceEvent;
import com.shengchanshe.chang_sheng_jue.init.CSJAdvanceInit;
import com.shengchanshe.chang_sheng_jue.martial_arts.IKungFuUpgradable;
import com.shengchanshe.chang_sheng_jue.martial_arts.ILightKungfu;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.KungFuType;
import com.shengchanshe.chang_sheng_jue.sound.ChangShengJueSound;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractionLightKungfu
implements ILightKungfu,
IKungFuUpgradable {
    protected String id;
    protected Component name;
    protected KungFuType type;
    protected Component description;
    protected boolean isComprehend;
    protected float comprehendProbability;
    protected int levelUpTick;
    protected float damage;
    protected int hunger;
    protected float saturation;
    protected float effectProbability;
    protected int level;
    protected int dachengTick;
    protected int exp;
    protected int cooldown;
    protected float cooldownFactor;
    protected boolean isStart;
    public RandomSource randomSource = RandomSource.m_216327_();

    public AbstractionLightKungfu(String id, Component name, KungFuType type, Component description, float comprehendProbability) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.description = description;
        this.comprehendProbability = comprehendProbability;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public KungFuType getKungFuType() {
        return this.type;
    }

    @Override
    public boolean isComprehend() {
        return this.isComprehend;
    }

    @Override
    public void comprehendKungFu(LivingEntity entity) {
        if (!this.isComprehend && this.level == 0 && this.randomSource.m_188501_() <= this.getComprehendProbability(entity)) {
            this.levelUp(entity);
            this.isStart = true;
            this.isComprehend = true;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ChangShengJueSound.COMPREHEND_SOUND.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_213846_((Component)Component.m_237110_((String)"message.kungfu.chang_sheng_jue.succeed.comprehend.internal_kungfu", (Object[])new Object[]{this.name}));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CSJAdvanceInit.LEARN_GONG_FA.trigger(serverPlayer);
                }
            }
        }
    }

    @Override
    public void attackEffect(LivingEntity source, Entity target) {
    }

    @Override
    public float getComprehendProbability(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                return 1.0f;
            }
        }
        return this.comprehendProbability;
    }

    @Override
    public ResourceKey<DamageType> getDamageType() {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("chang_sheng_jue:martial_arts"));
    }

    @Override
    public boolean isReady() {
        return this.cooldown <= 0 && this.isStart && this.isComprehend && this.level > 0;
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public void setHunger(int hunger) {
        this.hunger = hunger;
    }

    @Override
    public float getSaturation() {
        return this.saturation;
    }

    @Override
    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }

    @Override
    public float getEffectProbability() {
        return this.effectProbability;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getLevelUpTick() {
        if (this.levelUpTick >= 80) {
            this.levelUpTick = 0;
        }
        return this.levelUpTick;
    }

    @Override
    public void setLevelUpTick() {
        ++this.levelUpTick;
    }

    @Override
    public int getDachengTick() {
        if (this.dachengTick >= 30) {
            this.dachengTick = 0;
        }
        return this.dachengTick;
    }

    @Override
    public void setDachengTick() {
        ++this.dachengTick;
    }

    public void clampLevelToMax() {
        if (this.level > this.getMaxLevel()) {
            this.level = this.getMaxLevel();
            this.exp = 0;
        }
        if (this.exp > this.getMaxExp()) {
            this.exp = this.getMaxExp();
        }
    }

    @Override
    public void levelUp(LivingEntity entity) {
        ++this.level;
        if (this.level >= this.getMaxLevel()) {
            this.dachengTick = 1;
        } else {
            this.levelUpTick = 1;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            CSJAdvanceEvent.CheckLevel(this.level, player, this.exp, this.getMaxLevel());
        }
        this.exp = 0;
        this.onLevelUp(entity);
    }

    public void onLevelUp(LivingEntity livingEntity) {
    }

    @Override
    public void onLightKungfu(Player player) {
    }

    @Override
    public int getExp() {
        return this.exp;
    }

    @Override
    public void addExp(LivingEntity entity, int amount) {
        this.exp += amount;
        while (this.exp >= this.getMaxExp() && this.level < this.getMaxLevel()) {
            this.levelUp(entity);
            if (this.level >= this.getMaxLevel()) {
                entity.m_213846_((Component)Component.m_237110_((String)"message.kungfu.chang_sheng_jue.succeed.dacheng.kungfu", (Object[])new Object[]{this.name}).m_130940_(ChatFormatting.YELLOW));
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ChangShengJueSound.DACHENG_SOUND.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                continue;
            }
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ChangShengJueSound.COMPREHEND_SOUND.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public int getCoolDown() {
        return this.cooldown;
    }

    @Override
    public void tickCooldown() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    @Override
    public float getCoolDownFactor() {
        return this.cooldownFactor;
    }

    @Override
    public boolean isStart() {
        return this.isStart;
    }

    @Override
    public void startKungFu(boolean isStart) {
        this.isStart = isStart;
    }

    @Override
    public void biluochunTeasAndLongJingTeasEffect(LivingEntity source) {
        if (source.m_21023_(ChangShengJueEffects.BILUOCHUN_TEAS.get())) {
            source.m_21153_(source.m_21223_() + 1.0f);
        }
        if (source.m_21023_(ChangShengJueEffects.LONG_JING_TEAS.get()) && source instanceof Player) {
            Player player = (Player)source;
            player.m_36324_().m_38707_(1, 0.0f);
        }
    }

    @Override
    public float funJiuEffect(LivingEntity source, float damage) {
        if (source.m_21023_(ChangShengJueEffects.FEN_JIU.get())) {
            if (source instanceof Player) {
                Player player = (Player)source;
                player.m_36324_().m_38707_(-1, 0.0f);
            }
            return damage + 2.0f;
        }
        return damage;
    }

    @Override
    public int wheatNuggetsTributeWineEffect(LivingEntity source) {
        if (source.m_21023_(ChangShengJueEffects.WHEAT_NUGGETS_TRIBUTE_WINE.get())) {
            return 30;
        }
        return 0;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.id != null) {
            tag.m_128359_("KungFuId", this.id);
        }
        if (this.name != null) {
            tag.m_128359_("KungFuName", Component.Serializer.m_130703_((Component)this.name));
        }
        if (this.description != null) {
            tag.m_128359_("KungFuDescription", Component.Serializer.m_130703_((Component)this.description));
        }
        if (this.type != null) {
            tag.m_128359_("KungFuType", this.type.name());
        }
        tag.m_128379_("KungFuIsComprehend", this.isComprehend);
        tag.m_128405_("KungFuComprehendTick", this.levelUpTick);
        tag.m_128350_("KungFuDamage", this.damage);
        tag.m_128405_("KungFuHunger", this.hunger);
        tag.m_128350_("KungFuSaturation", this.saturation);
        tag.m_128350_("KungFuEffectProbability", this.effectProbability);
        tag.m_128405_("KungFuLevel", this.level);
        tag.m_128405_("KungFuLevelUpTick", this.dachengTick);
        tag.m_128405_("KungFuExp", this.exp);
        tag.m_128405_("KungFuCooldown", this.cooldown);
        tag.m_128350_("KungFuCooldownFactor", this.cooldownFactor);
        tag.m_128379_("KungFuIsStart", this.isStart);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        this.id = tag.m_128461_("KungFuId");
        this.name = Component.Serializer.m_130701_((String)tag.m_128461_("KungFuName"));
        if (tag.m_128425_("KungFuDescription", 8)) {
            String desc = tag.m_128461_("KungFuDescription");
            this.description = desc.startsWith("{") && desc.endsWith("}") ? Component.Serializer.m_130701_((String)desc) : this.getDescription();
        }
        this.type = KungFuType.valueOf(tag.m_128461_("KungFuType"));
        this.isComprehend = tag.m_128471_("KungFuIsComprehend");
        this.levelUpTick = tag.m_128451_("KungFuComprehendTick");
        this.damage = tag.m_128457_("KungFuDamage");
        this.hunger = tag.m_128451_("KungFuHunger");
        this.saturation = tag.m_128457_("KungFuSaturation");
        this.effectProbability = tag.m_128457_("KungFuEffectProbability");
        this.level = tag.m_128451_("KungFuLevel");
        this.dachengTick = tag.m_128451_("KungFuLevelUpTick");
        this.exp = tag.m_128451_("KungFuExp");
        this.cooldown = tag.m_128451_("KungFuCooldown");
        this.cooldownFactor = tag.m_128457_("KungFuCooldownFactor");
        this.isStart = tag.m_128471_("KungFuIsStart");
        this.clampLevelToMax();
    }
}

