/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.network.packet.gui.craftitem;

import com.shengchanshe.chang_sheng_jue.block.custom.forgeblock.ForgeBlockEntity;
import com.shengchanshe.chang_sheng_jue.recipe.ForgeBlockRecipe;
import io.netty.handler.codec.DecoderException;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ForgeSyncRecipePacket {
    private final BlockPos pos;
    private final ResourceLocation recipeId;

    public ForgeSyncRecipePacket(BlockPos pos, ForgeBlockRecipe recipe) {
        this.pos = pos;
        this.recipeId = recipe != null ? recipe.m_6423_() : null;
    }

    public ForgeSyncRecipePacket(BlockPos pos, ResourceLocation recipeId) {
        this.pos = pos;
        this.recipeId = recipeId;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        if (this.recipeId != null) {
            buf.writeBoolean(true);
            buf.m_130070_(this.recipeId.toString());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static ForgeSyncRecipePacket fromBytes(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        ResourceLocation recipeId = null;
        if (buf.readBoolean()) {
            String recipeIdStr = buf.m_130277_();
            try {
                recipeId = new ResourceLocation(recipeIdStr);
            }
            catch (ResourceLocationException e) {
                throw new DecoderException("Invalid ResourceLocation in packet: " + recipeIdStr, (Throwable)e);
            }
        }
        return new ForgeSyncRecipePacket(pos, recipeId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity patt2697$temp;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (patt2697$temp = player.m_9236_().m_7702_(this.pos)) instanceof ForgeBlockEntity) {
                Optional optionalRecipe;
                ForgeBlockEntity blockEntity = (ForgeBlockEntity)patt2697$temp;
                ForgeBlockRecipe recipe = null;
                if (this.recipeId != null && (optionalRecipe = player.m_9236_().m_7465_().m_44043_(this.recipeId)).isPresent() && optionalRecipe.get() instanceof ForgeBlockRecipe) {
                    recipe = (ForgeBlockRecipe)optionalRecipe.get();
                }
                blockEntity.setCurrentRecipe(recipe);
                blockEntity.m_6596_();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

