/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.network.packet.gui.craftitem;

import com.shengchanshe.chang_sheng_jue.block.custom.tailoringcase.TailoringCaseEntity;
import com.shengchanshe.chang_sheng_jue.recipe.TailoringCaseRecipe;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class TailoringSyncRecipePacket {
    private final BlockPos pos;
    private final ResourceLocation recipeId;

    public TailoringSyncRecipePacket(BlockPos pos, TailoringCaseRecipe recipe) {
        this.pos = pos;
        this.recipeId = recipe != null ? recipe.m_6423_() : null;
        System.out.println("\u521b\u5efa\u540c\u6b65\u5305\uff0c\u914d\u65b9ID: " + (Comparable)(this.recipeId != null ? this.recipeId : "\u65e0"));
    }

    public TailoringSyncRecipePacket(BlockPos pos, ResourceLocation recipeId) {
        this.pos = pos;
        this.recipeId = recipeId;
        System.out.println("\u901a\u8fc7ResourceLocation\u521b\u5efa\u540c\u6b65\u5305\uff0c\u914d\u65b9ID: " + (Comparable)(recipeId != null ? recipeId : "\u65e0"));
    }

    public TailoringSyncRecipePacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.recipeId = TailoringSyncRecipePacket.readResourceLocationFromBuffer(buf);
        System.out.println("\u89e3\u7801\u540c\u6b65\u5305\uff0c\u914d\u65b9ID: " + (Comparable)(this.recipeId != null ? this.recipeId : "\u65e0"));
    }

    public void toBytes(FriendlyByteBuf buf) {
        try {
            buf.m_130064_(this.pos);
            TailoringSyncRecipePacket.writeResourceLocationToBuffer(buf, this.recipeId);
            System.out.println("\u7f16\u7801\u540c\u6b65\u5305\uff0c\u914d\u65b9ID: " + (Comparable)(this.recipeId != null ? this.recipeId : "\u65e0"));
        }
        catch (Exception e) {
            System.out.println("Error encoding recipe ID: " + (Comparable)(this.recipeId != null ? this.recipeId : "null"));
            e.printStackTrace();
        }
    }

    public static TailoringSyncRecipePacket fromBytes(FriendlyByteBuf buf) {
        try {
            BlockPos pos = buf.m_130135_();
            ResourceLocation recipeId = TailoringSyncRecipePacket.readResourceLocationFromBuffer(buf);
            return new TailoringSyncRecipePacket(pos, recipeId);
        }
        catch (Exception e) {
            System.out.println("Error decoding recipe packet");
            e.printStackTrace();
            try {
                buf.skipBytes(buf.readableBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new TailoringSyncRecipePacket(buf.m_130135_(), (ResourceLocation)null);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BlockEntity patt3560$temp;
            ServerPlayer player = context.getSender();
            if (player != null && (patt3560$temp = player.m_9236_().m_7702_(this.pos)) instanceof TailoringCaseEntity) {
                TailoringCaseEntity blockEntity = (TailoringCaseEntity)patt3560$temp;
                TailoringCaseRecipe recipe = null;
                if (this.recipeId != null) {
                    Optional optionalRecipe = player.m_9236_().m_7465_().m_44043_(this.recipeId);
                    recipe = optionalRecipe.isPresent() && optionalRecipe.get() instanceof TailoringCaseRecipe ? (TailoringCaseRecipe)optionalRecipe.get() : null;
                }
                blockEntity.setCurrentRecipe(recipe);
                blockEntity.m_6596_();
            }
        });
        context.setPacketHandled(true);
    }

    private static ResourceLocation readResourceLocationFromBuffer(FriendlyByteBuf buf) {
        int length;
        if (buf.readBoolean() && (length = buf.readInt()) >= 0) {
            byte[] bytes = new byte[length];
            buf.readBytes(bytes);
            return ResourceLocation.m_135820_((String)new String(bytes, StandardCharsets.UTF_8));
        }
        return null;
    }

    private static void writeResourceLocationToBuffer(FriendlyByteBuf buf, ResourceLocation location) {
        buf.writeBoolean(location != null);
        if (location != null) {
            String idString = location.toString();
            byte[] bytes = idString.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
        }
    }
}

