/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.network.packet.gui.playerquest;

import com.shengchanshe.chang_sheng_jue.capability.quest.PlayerQuestCapabilityProvider;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.playerquest.PlayerQuestMenu;
import com.shengchanshe.chang_sheng_jue.network.packet.gui.playerquest.PlayerQuestHandler;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public record AbandonPlayerQuestPacket(UUID questId, int page) {
    public static void encode(AbandonPlayerQuestPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.questId());
        buf.writeInt(packet.page());
    }

    public static AbandonPlayerQuestPacket decode(FriendlyByteBuf buf) {
        return new AbandonPlayerQuestPacket(buf.m_130259_(), buf.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
                    Optional<Quest> quest = cap.getQuests(player.m_20148_()).stream().filter(q -> q != null && this.questId.equals(q.getQuestId())).findFirst();
                    if (quest.isPresent() && player.f_36096_ instanceof PlayerQuestMenu) {
                        PlayerQuestHandler.handleAbandonPlayerQuest(player, quest.get());
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

