/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.network.packet.gui.playerquest;

import com.shengchanshe.chang_sheng_jue.capability.quest.PlayerQuestCapabilityProvider;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.playerquest.PlayerQuestMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public record OpenPlayerQuestScreenPacket(int newPage, Component title) {
    public static void encode(OpenPlayerQuestScreenPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.newPage);
        buf.m_130083_(packet.title);
    }

    public static OpenPlayerQuestScreenPacket decode(FriendlyByteBuf buf) {
        return new OpenPlayerQuestScreenPacket(buf.readInt(), buf.m_130238_());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayer != null) {
                serverPlayer.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> cap.syncToClient(serverPlayer));
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(PlayerQuestMenu::new, (Component)Component.m_237115_((String)"menu.title.quests")));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

