/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.network.packet.gui.quest;

import com.shengchanshe.chang_sheng_jue.capability.quest.PlayerQuestCapabilityProvider;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.gangleader.GangQuestsMenu;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.gangleader.GangleaderTradingMenu;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.gangleader.AbstractGangLeader;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.trading.Merchant;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public record OpenGangQuestScreenPacket(UUID playerId) {
    public static void encode(OpenGangQuestScreenPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.playerId());
    }

    public static OpenGangQuestScreenPacket decode(FriendlyByteBuf buf) {
        return new OpenGangQuestScreenPacket(buf.m_130259_());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            GangleaderTradingMenu menu;
            Merchant patt1542$temp;
            AbstractContainerMenu patt1463$temp;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (patt1463$temp = player.f_36096_) instanceof GangleaderTradingMenu && (patt1542$temp = (menu = (GangleaderTradingMenu)patt1463$temp).getTrader()) instanceof AbstractGangLeader) {
                AbstractGangLeader abstractGangLeader = (AbstractGangLeader)patt1542$temp;
                player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(playerQuest -> {
                    List<Quest> quests = abstractGangLeader.getPlayerQuests(this.playerId);
                    ArrayList<Quest> availableQuests = new ArrayList<Quest>();
                    for (Quest quest : quests) {
                        if (quest == null) continue;
                        if (quest.isNeedRefresh()) {
                            abstractGangLeader.clearPlayerQuests(this.playerId);
                            availableQuests.clear();
                        }
                        if (!quest.isValid() || quest.isNeedRefresh() || quest.getAcceptedBy() != null) continue;
                        availableQuests.add(quest);
                    }
                    List<Quest> newQuests = playerQuest.triggerGangQuest((Player)player, abstractGangLeader, Float.valueOf(1.0f));
                    if (newQuests != null) {
                        for (Quest newQuest : newQuests) {
                            if (newQuest == null || !newQuest.isValid()) continue;
                            boolean alreadyExists = false;
                            for (int i = 0; i < availableQuests.size(); ++i) {
                                Quest existingQuest = (Quest)availableQuests.get(i);
                                if (!existingQuest.getQuestId().equals(newQuest.getQuestId()) || existingQuest.getAcceptedBy() != null) continue;
                                availableQuests.set(i, newQuest);
                                abstractGangLeader.addQuestForPlayer(this.playerId, newQuest);
                                alreadyExists = true;
                                break;
                            }
                            if (alreadyExists || newQuest.getAcceptedBy() != null) continue;
                            abstractGangLeader.addQuestForPlayer(this.playerId, newQuest);
                            availableQuests.add(newQuest);
                        }
                    }
                    NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, inv, p) -> new GangQuestsMenu(windowId, inv, (Merchant)abstractGangLeader, availableQuests), (Component)Component.m_237115_((String)"quest.chang_sheng_jue.button")), buf -> {
                        buf.writeInt(availableQuests.size());
                        for (Quest quest : availableQuests) {
                            buf.m_130079_(quest.toNbt());
                        }
                    });
                    playerQuest.syncToClient(player);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

