/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.network.packet.particle.kungfu;

import com.shengchanshe.chang_sheng_jue.particle.ChangShengJueParticles;
import com.shengchanshe.chang_sheng_jue.util.particle.XpParatice;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public record XpParticlePacket(UUID playerUUID, SimpleParticleType particleType, int tick) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerUUID);
        buf.m_130085_(Objects.requireNonNull(ForgeRegistries.PARTICLE_TYPES.getKey((Object)this.particleType)));
        buf.writeInt(this.tick);
    }

    public static XpParticlePacket decode(FriendlyByteBuf buf) {
        UUID playerUUID = buf.m_130259_();
        ParticleType particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buf.m_130281_());
        int tick = buf.readInt();
        if (particleType instanceof SimpleParticleType) {
            SimpleParticleType simpleParticleType = (SimpleParticleType)particleType;
            return new XpParticlePacket(playerUUID, simpleParticleType, tick);
        }
        return new XpParticlePacket(playerUUID, (SimpleParticleType)ChangShengJueParticles.EXTERNAL_KUN_FU_XP_PARTICLE.get(), tick);
    }

    public static void handle(XpParticlePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            Player player = Minecraft.m_91087_().f_91073_.m_46003_(packet.playerUUID());
            if (player != null && player.m_9236_() == mc.f_91073_) {
                XpParatice.XpParaticeParticle(packet.particleType(), player, player.m_9236_(), packet.tick);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

