/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.quest;

import com.shengchanshe.chang_sheng_jue.capability.ChangShengJueCapabiliy;
import com.shengchanshe.chang_sheng_jue.capability.quest.PlayerQuestCapability;
import com.shengchanshe.chang_sheng_jue.event.quest.PlayerQuestEvent;
import com.shengchanshe.chang_sheng_jue.item.kungfuxp.ExternalKungfuXp;
import com.shengchanshe.chang_sheng_jue.item.kungfuxp.InternalkungfuXp;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.external_kunfu.AbstractionExternalKunfu;
import com.shengchanshe.chang_sheng_jue.martial_arts.kungfu.internal_kungfu.AbstractionInternalkungfu;
import com.shengchanshe.chang_sheng_jue.quest.QuestEffectEntry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class Quest {
    private UUID questId;
    private String questName;
    private String questDescription;
    private List<ItemStack> questRequirements;
    private List<ItemStack> questRewards;
    private UUID questNpcId;
    private UUID acceptedBy;
    private boolean needRefresh;
    private QuestType questType;
    private boolean repeatable;
    private String targetEntity;
    private int requiredKills;
    private int currentKills;
    private String secondTargetEntity;
    private int secondRequiredKills;
    private int secondCurrentKills;
    private boolean isEntityTag;
    private boolean isSecondEntityTag;
    private String questRequirementsDescription;
    private boolean questGenerateTarget;
    private int questTargetCount;
    private int questCurrentTargetCount;
    private List<QuestEffectEntry> effects = new ArrayList<QuestEffectEntry>();
    private boolean isComplete;
    private int questDay;
    private int questCurrentDay;
    private int questTime;
    private int questCurrentTime;
    private boolean isAcceptQuestEffects;
    private List<UUID> limitQuestIds;
    private boolean isNeedCompletePreQuest;
    private List<UUID> conflictQuestIds;
    private boolean isConflictQuest;
    private int needCompletionCount;
    private int weight;

    public Quest(UUID questId, UUID questNpcId, String questName, String questDescription, boolean needRefresh, List<ItemStack> questRequirements, List<ItemStack> questRewards, QuestType questType, String targetEntity, boolean isEntityTag, int requiredKills, String secondTargetEntity, int secondRequiredKills, boolean isSecondEntityTag, boolean repeatable, String questRequirementsDescription, boolean questGenerateTarget, int questDay, int questTargetCount, int questTime, List<QuestEffectEntry> effects, boolean isAcceptQuestEffects, List<UUID> limitQuestIds, boolean isNeedCompletePreQuest, List<UUID> conflictQuestIds, boolean isConflictQuest, int needCompletionCount, int weight) {
        this.questId = Objects.requireNonNull(questId, "\u4efb\u52a1ID\u4e0d\u80fd\u4e3anull");
        this.questNpcId = questNpcId;
        this.questName = questName;
        this.needRefresh = needRefresh;
        this.questDescription = questDescription;
        this.questRequirements = questRequirements != null ? questRequirements : new ArrayList();
        this.questRewards = questRewards != null ? questRewards : new ArrayList();
        this.questType = questType;
        this.repeatable = repeatable;
        this.questRequirementsDescription = questRequirementsDescription;
        this.effects = effects != null ? effects : new ArrayList();
        this.limitQuestIds = limitQuestIds != null ? limitQuestIds : new ArrayList();
        this.targetEntity = targetEntity;
        this.requiredKills = requiredKills;
        this.currentKills = 0;
        this.isEntityTag = isEntityTag;
        this.secondTargetEntity = secondTargetEntity;
        this.secondRequiredKills = secondRequiredKills;
        this.secondCurrentKills = 0;
        this.isSecondEntityTag = isSecondEntityTag;
        this.questGenerateTarget = questGenerateTarget;
        this.questDay = questDay;
        this.questCurrentDay = 0;
        this.questTargetCount = questTargetCount;
        this.questCurrentTargetCount = 0;
        this.questTime = questTime;
        this.questCurrentTime = 0;
        this.isComplete = false;
        this.isAcceptQuestEffects = isAcceptQuestEffects;
        this.isNeedCompletePreQuest = isNeedCompletePreQuest;
        this.conflictQuestIds = conflictQuestIds != null ? conflictQuestIds : new ArrayList();
        this.isConflictQuest = isConflictQuest;
        this.needCompletionCount = needCompletionCount;
        this.weight = weight;
    }

    public void updateFrom(Quest newQuest) {
        this.questId = newQuest.questId;
        this.questName = newQuest.questName;
        this.questDescription = newQuest.questDescription;
        this.questRequirements = newQuest.questRequirements;
        this.questRewards = newQuest.questRewards;
        this.questNpcId = newQuest.questNpcId;
        this.acceptedBy = newQuest.acceptedBy;
        this.needRefresh = newQuest.needRefresh;
        this.questType = newQuest.questType;
        this.targetEntity = newQuest.targetEntity;
        this.requiredKills = newQuest.requiredKills;
        this.currentKills = newQuest.currentKills;
        this.isEntityTag = newQuest.isEntityTag;
        this.secondTargetEntity = newQuest.secondTargetEntity;
        this.secondRequiredKills = newQuest.secondRequiredKills;
        this.secondCurrentKills = newQuest.secondCurrentKills;
        this.isSecondEntityTag = newQuest.isSecondEntityTag;
        this.repeatable = newQuest.repeatable;
        this.questRequirementsDescription = newQuest.questRequirementsDescription;
        this.questGenerateTarget = newQuest.questGenerateTarget;
        this.effects = newQuest.effects;
        this.isComplete = newQuest.isComplete;
        this.questDay = newQuest.questDay;
        this.questCurrentDay = newQuest.questCurrentDay;
        this.questTargetCount = newQuest.questTargetCount;
        this.questCurrentTargetCount = newQuest.questCurrentTargetCount;
        this.questTime = newQuest.questTime;
        this.isAcceptQuestEffects = newQuest.isAcceptQuestEffects;
        this.limitQuestIds = newQuest.limitQuestIds;
        this.isNeedCompletePreQuest = newQuest.isNeedCompletePreQuest;
        this.conflictQuestIds = newQuest.conflictQuestIds;
        this.isConflictQuest = newQuest.isConflictQuest;
        this.needCompletionCount = newQuest.needCompletionCount;
        this.weight = newQuest.weight;
    }

    public Quest(CompoundTag tag) {
        ListTag idList;
        int i;
        this.questId = tag.m_128403_("QuestId") ? tag.m_128342_("QuestId") : UUID.randomUUID();
        this.questName = tag.m_128441_("QuestName") ? tag.m_128461_("QuestName") : "\u5f53\u524d\u672a\u63a5\u53d6\u4efb\u52a1";
        String string = this.questDescription = tag.m_128441_("QuestDescription") ? tag.m_128461_("QuestDescription") : "\u5f53\u524d\u672a\u63a5\u53d6\u4efb\u52a1";
        if (tag.m_128441_("QuestRewards")) {
            this.questRewards = new ArrayList<ItemStack>();
            ListTag rewardList = tag.m_128437_("QuestRewards", 10);
            for (i = 0; i < rewardList.size(); ++i) {
                this.questRewards.add(ItemStack.m_41712_((CompoundTag)rewardList.m_128728_(i)));
            }
        }
        if (tag.m_128403_("AcceptedBy")) {
            this.acceptedBy = tag.m_128342_("AcceptedBy");
        }
        this.needRefresh = tag.m_128471_("NeedRefresh");
        if (tag.m_128441_("Repeatable")) {
            this.repeatable = tag.m_128471_("Repeatable");
        }
        if (tag.m_128441_("Effects")) {
            ListTag effectsList = tag.m_128437_("Effects", 10);
            for (i = 0; i < effectsList.size(); ++i) {
                CompoundTag effectTag = effectsList.m_128728_(i);
                this.effects.add(new QuestEffectEntry(effectTag.m_128461_("id"), effectTag.m_128451_("duration"), effectTag.m_128451_("amplifier"), effectTag.m_128471_("ambient"), effectTag.m_128471_("showParticles"), effectTag.m_128471_("showIcon")));
            }
        }
        if (tag.m_128441_("QuestType")) {
            this.questType = QuestType.valueOf(tag.m_128461_("QuestType"));
        }
        String string2 = this.questRequirementsDescription = tag.m_128441_("QuestRequirementsDescription") ? tag.m_128461_("QuestRequirementsDescription") : "\u5f53\u524d\u672a\u63a5\u53d6\u4efb\u52a1";
        if (tag.m_128403_("QuestNpcId")) {
            this.questNpcId = tag.m_128342_("QuestNpcId");
        }
        if (tag.m_128441_("QuestRequirements")) {
            this.questRequirements = new ArrayList<ItemStack>();
            ListTag reqList = tag.m_128437_("QuestRequirements", 10);
            for (i = 0; i < reqList.size(); ++i) {
                this.questRequirements.add(ItemStack.m_41712_((CompoundTag)reqList.m_128728_(i)));
            }
        }
        if (tag.m_128441_("TargetEntity")) {
            this.targetEntity = tag.m_128461_("TargetEntity");
        }
        if (tag.m_128441_("RequiredKills")) {
            this.requiredKills = tag.m_128451_("RequiredKills");
        }
        if (tag.m_128441_("CurrentKills")) {
            this.currentKills = tag.m_128451_("CurrentKills");
        }
        if (tag.m_128441_("SecondTargetEntity")) {
            this.secondTargetEntity = tag.m_128461_("SecondTargetEntity");
        }
        if (tag.m_128441_("SecondRequiredKills")) {
            this.secondRequiredKills = tag.m_128451_("SecondRequiredKills");
        }
        if (tag.m_128441_("SecondCurrentKills")) {
            this.secondCurrentKills = tag.m_128451_("SecondCurrentKills");
        }
        if (tag.m_128441_("IsEntityTag")) {
            this.isEntityTag = tag.m_128471_("IsEntityTag");
        }
        if (tag.m_128441_("IsSecondEntityTag")) {
            this.isSecondEntityTag = tag.m_128471_("IsSecondEntityTag");
        }
        if (tag.m_128441_("QuestGenerateTarget")) {
            this.questGenerateTarget = tag.m_128471_("QuestGenerateTarget");
        }
        if (tag.m_128441_("IsComplete")) {
            this.isComplete = tag.m_128471_("IsComplete");
        }
        if (tag.m_128441_("QuestDay")) {
            this.questDay = tag.m_128451_("QuestDay");
        }
        if (tag.m_128441_("QuestCurrentDay")) {
            this.questCurrentDay = tag.m_128451_("QuestCurrentDay");
        }
        if (tag.m_128441_("QuestTargetCount")) {
            this.questTargetCount = tag.m_128451_("QuestTargetCount");
        }
        if (tag.m_128441_("QuestCurrentTargetCount")) {
            this.questCurrentTargetCount = tag.m_128451_("QuestCurrentTargetCount");
        }
        if (tag.m_128441_("QuestTime")) {
            this.questTime = tag.m_128451_("QuestTime");
        }
        if (tag.m_128441_("IsAcceptQuestEffects")) {
            this.isAcceptQuestEffects = tag.m_128471_("IsAcceptQuestEffects");
        }
        this.limitQuestIds = new ArrayList<UUID>();
        if (tag.m_128441_("LimitQuestIds")) {
            idList = tag.m_128437_("LimitQuestIds", 11);
            for (Tag value : idList) {
                this.limitQuestIds.add(NbtUtils.m_129233_((Tag)value));
            }
        }
        if (tag.m_128441_("IsNeedCompletePreQuest")) {
            this.isNeedCompletePreQuest = tag.m_128471_("IsNeedCompletePreQuest");
        }
        this.conflictQuestIds = new ArrayList<UUID>();
        if (tag.m_128441_("ConflictQuestIds")) {
            idList = tag.m_128437_("ConflictQuestIds", 11);
            for (Tag value : idList) {
                this.conflictQuestIds.add(NbtUtils.m_129233_((Tag)value));
            }
        }
        if (tag.m_128441_("IsConflictQuest")) {
            this.isConflictQuest = tag.m_128471_("IsConflictQuest");
        }
        if (tag.m_128441_("NeedCompletionCount")) {
            this.needCompletionCount = tag.m_128451_("NeedCompletionCount");
        }
        if (tag.m_128441_("Weight")) {
            this.weight = tag.m_128451_("Weight");
        }
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        if (this.questId != null) {
            tag.m_128362_("QuestId", this.questId);
        }
        if (this.questName != null) {
            tag.m_128359_("QuestName", this.questName);
        }
        if (this.questDescription != null) {
            tag.m_128359_("QuestDescription", this.questDescription);
        }
        if (this.questRewards != null) {
            ListTag rewardList = new ListTag();
            for (ItemStack itemStack : this.questRewards) {
                rewardList.add((Object)itemStack.m_41739_(new CompoundTag()));
            }
            tag.m_128365_("QuestRewards", (Tag)rewardList);
        }
        if (this.acceptedBy != null) {
            tag.m_128362_("AcceptedBy", this.acceptedBy);
        }
        tag.m_128379_("NeedRefresh", this.needRefresh);
        tag.m_128379_("Repeatable", this.repeatable);
        ListTag effectsList = this.getTags();
        tag.m_128365_("Effects", (Tag)effectsList);
        if (this.questType != null) {
            tag.m_128359_("QuestType", this.questType.name());
        }
        if (this.questRequirementsDescription != null) {
            tag.m_128359_("QuestRequirementsDescription", this.questRequirementsDescription);
        }
        if (this.questNpcId != null) {
            tag.m_128362_("QuestNpcId", this.questNpcId);
        }
        if (this.questRequirements != null) {
            ListTag reqList = new ListTag();
            for (ItemStack stack : this.questRequirements) {
                reqList.add((Object)stack.m_41739_(new CompoundTag()));
            }
            tag.m_128365_("QuestRequirements", (Tag)reqList);
        }
        if (this.targetEntity != null) {
            tag.m_128359_("TargetEntity", this.targetEntity);
        }
        tag.m_128405_("RequiredKills", this.requiredKills);
        tag.m_128405_("CurrentKills", this.currentKills);
        tag.m_128379_("IsEntityTag", this.isEntityTag);
        tag.m_128379_("IsSecondEntityTag", this.isSecondEntityTag);
        tag.m_128379_("QuestGenerateTarget", this.questGenerateTarget);
        tag.m_128379_("IsComplete", this.isComplete);
        tag.m_128405_("QuestDay", this.questDay);
        tag.m_128405_("QuestCurrentDay", this.questCurrentDay);
        tag.m_128405_("QuestTargetCount", this.questTargetCount);
        tag.m_128405_("QuestCurrentTargetCount", this.questCurrentTargetCount);
        tag.m_128405_("QuestTime", this.questTime);
        tag.m_128379_("IsAcceptQuestEffects", this.isAcceptQuestEffects);
        ListTag idList = new ListTag();
        this.limitQuestIds.forEach(id -> idList.add((Object)NbtUtils.m_129226_((UUID)id)));
        tag.m_128365_("LimitQuestIds", (Tag)idList);
        tag.m_128379_("IsNeedCompletePreQuest", this.isNeedCompletePreQuest);
        ListTag listTag = new ListTag();
        this.conflictQuestIds.forEach(id -> idListC.add((Object)NbtUtils.m_129226_((UUID)id)));
        tag.m_128365_("ConflictQuestIds", (Tag)listTag);
        tag.m_128379_("IsConflictQuest", this.isConflictQuest);
        tag.m_128405_("NeedCompletionCount", this.needCompletionCount);
        if (this.secondTargetEntity != null) {
            tag.m_128359_("SecondTargetEntity", this.secondTargetEntity);
        }
        tag.m_128405_("SecondRequiredKills", this.secondRequiredKills);
        tag.m_128405_("SecondCurrentKills", this.secondCurrentKills);
        tag.m_128405_("Weight", this.weight);
        return tag;
    }

    public void saveNBTData(CompoundTag compound) {
        if (this.questId != null) {
            compound.m_128362_("QuestId", this.questId);
        }
        if (this.questName != null) {
            compound.m_128359_("QuestName", this.questName);
        }
        if (this.questDescription != null) {
            compound.m_128359_("QuestDescription", this.questDescription);
        }
        if (this.questRewards != null) {
            ListTag rewardList = new ListTag();
            for (ItemStack stack : this.questRewards) {
                rewardList.add((Object)stack.m_41739_(new CompoundTag()));
            }
            compound.m_128365_("QuestRewards", (Tag)rewardList);
        }
        if (this.acceptedBy != null) {
            compound.m_128362_("AcceptedBy", this.acceptedBy);
        }
        compound.m_128379_("Repeatable", this.repeatable);
        ListTag effectsList = this.getTags();
        compound.m_128365_("Effects", (Tag)effectsList);
        if (this.questType != null) {
            compound.m_128359_("QuestType", this.questType.name());
        }
        if (this.questRequirementsDescription != null) {
            compound.m_128359_("QuestRequirementsDescription", this.questRequirementsDescription);
        }
        if (this.questNpcId != null) {
            compound.m_128362_("QuestNpcId", this.questNpcId);
        }
        if (this.questRequirements != null) {
            ListTag reqList = new ListTag();
            for (ItemStack stack : this.questRequirements) {
                reqList.add((Object)stack.m_41739_(new CompoundTag()));
            }
            compound.m_128365_("QuestRequirements", (Tag)reqList);
        }
        if (this.targetEntity != null) {
            compound.m_128359_("TargetEntity", this.targetEntity);
        }
        compound.m_128405_("RequiredKills", this.requiredKills);
        compound.m_128405_("CurrentKills", this.currentKills);
        compound.m_128379_("IsEntityTag", this.isEntityTag);
        compound.m_128379_("IsSecondEntityTag", this.isSecondEntityTag);
        compound.m_128379_("QuestGenerateTarget", this.questGenerateTarget);
        compound.m_128379_("IsComplete", this.isComplete);
        compound.m_128405_("QuestDay", this.questDay);
        compound.m_128405_("QuestCurrentDay", this.questCurrentDay);
        compound.m_128405_("QuestTargetCount", this.questTargetCount);
        compound.m_128405_("QuestCurrentTargetCount", this.questCurrentTargetCount);
        compound.m_128405_("QuestTime", this.questTime);
        compound.m_128379_("IsAcceptQuestEffects", this.isAcceptQuestEffects);
        ListTag idList = new ListTag();
        this.limitQuestIds.forEach(id -> idList.add((Object)NbtUtils.m_129226_((UUID)id)));
        compound.m_128365_("LimitQuestIds", (Tag)idList);
        compound.m_128379_("IsNeedCompletePreQuest", this.isNeedCompletePreQuest);
        compound.m_128405_("NeedCompletionCount", this.needCompletionCount);
        if (this.secondTargetEntity != null) {
            compound.m_128359_("SecondTargetEntity", this.secondTargetEntity);
        }
        compound.m_128405_("SecondRequiredKills", this.secondRequiredKills);
        compound.m_128405_("SecondCurrentKills", this.secondCurrentKills);
        compound.m_128405_("Weight", this.weight);
    }

    public void loadNBTData(CompoundTag tag) {
        int i;
        this.questId = tag.m_128403_("QuestId") ? tag.m_128342_("QuestId") : UUID.randomUUID();
        this.questName = tag.m_128441_("QuestName") ? tag.m_128461_("QuestName") : "\u5f53\u524d\u6ca1\u6709\u4efb\u52a1";
        String string = this.questDescription = tag.m_128441_("QuestDescription") ? tag.m_128461_("QuestDescription") : "\u5f53\u524d\u6ca1\u6709\u4efb\u52a1";
        if (tag.m_128441_("QuestRewards")) {
            this.questRewards = new ArrayList<ItemStack>();
            ListTag rewardList = tag.m_128437_("QuestRewards", 10);
            for (i = 0; i < rewardList.size(); ++i) {
                this.questRewards.add(ItemStack.m_41712_((CompoundTag)rewardList.m_128728_(i)));
            }
        }
        if (tag.m_128403_("AcceptedBy")) {
            this.acceptedBy = tag.m_128342_("AcceptedBy");
        }
        if (tag.m_128441_("Repeatable")) {
            this.repeatable = tag.m_128471_("Repeatable");
        }
        if (tag.m_128441_("QuestType")) {
            this.questType = QuestType.valueOf(tag.m_128461_("QuestType"));
        }
        String string2 = this.questRequirementsDescription = tag.m_128441_("QuestRequirementsDescription") ? tag.m_128461_("QuestRequirementsDescription") : "\u5f53\u524d\u672a\u63a5\u53d6\u4efb\u52a1";
        if (tag.m_128403_("QuestNpcId")) {
            this.questNpcId = tag.m_128342_("QuestNpcId");
        }
        if (tag.m_128441_("QuestRequirements")) {
            this.questRequirements = new ArrayList<ItemStack>();
            ListTag reqList = tag.m_128437_("QuestRequirements", 10);
            for (i = 0; i < reqList.size(); ++i) {
                this.questRequirements.add(ItemStack.m_41712_((CompoundTag)reqList.m_128728_(i)));
            }
        }
        if (tag.m_128441_("TargetEntity")) {
            this.targetEntity = tag.m_128461_("TargetEntity");
        }
        if (tag.m_128441_("RequiredKills")) {
            this.requiredKills = tag.m_128451_("RequiredKills");
        }
        if (tag.m_128441_("CurrentKills")) {
            this.currentKills = tag.m_128451_("CurrentKills");
        }
        if (tag.m_128441_("IsEntityTag")) {
            this.isEntityTag = tag.m_128471_("IsEntityTag");
        }
        if (tag.m_128441_("IsSecondEntityTag")) {
            this.isSecondEntityTag = tag.m_128471_("IsSecondEntityTag");
        }
        if (tag.m_128441_("QuestGenerateTarget")) {
            this.questGenerateTarget = tag.m_128471_("QuestGenerateTarget");
        }
        if (tag.m_128441_("IsComplete")) {
            this.isComplete = tag.m_128471_("IsComplete");
        }
        if (tag.m_128441_("QuestDay")) {
            this.questDay = tag.m_128451_("QuestDay");
        }
        if (tag.m_128441_("QuestCurrentDay")) {
            this.questCurrentDay = tag.m_128451_("QuestCurrentDay");
        }
        if (tag.m_128441_("QuestTargetCount")) {
            this.questTargetCount = tag.m_128451_("QuestTargetCount");
        }
        if (tag.m_128441_("QuestCurrentTargetCount")) {
            this.questCurrentTargetCount = tag.m_128451_("QuestCurrentTargetCount");
        }
        if (tag.m_128441_("QuestTime")) {
            this.questTime = tag.m_128451_("QuestTime");
        }
        if (tag.m_128441_("Effects")) {
            ListTag effectsList = tag.m_128437_("Effects", 10);
            for (i = 0; i < effectsList.size(); ++i) {
                CompoundTag effectTag = effectsList.m_128728_(i);
                this.effects.add(new QuestEffectEntry(effectTag.m_128461_("id"), effectTag.m_128451_("duration"), effectTag.m_128451_("amplifier"), effectTag.m_128471_("ambient"), effectTag.m_128471_("showParticles"), effectTag.m_128471_("showIcon")));
            }
        }
        if (tag.m_128441_("IsAcceptQuestEffects")) {
            this.isAcceptQuestEffects = tag.m_128471_("IsAcceptQuestEffects");
        }
        this.limitQuestIds = new ArrayList<UUID>();
        if (tag.m_128441_("LimitQuestIds")) {
            ListTag idList = tag.m_128437_("LimitQuestIds", 11);
            for (Tag value : idList) {
                this.limitQuestIds.add(NbtUtils.m_129233_((Tag)value));
            }
        }
        if (tag.m_128441_("IsNeedCompletePreQuest")) {
            this.isNeedCompletePreQuest = tag.m_128471_("IsNeedCompletePreQuest");
        }
        if (tag.m_128441_("NeedCompletionCount")) {
            this.needCompletionCount = tag.m_128451_("NeedCompletionCount");
        }
        if (tag.m_128441_("SecondTargetEntity")) {
            this.secondTargetEntity = tag.m_128461_("SecondTargetEntity");
        }
        if (tag.m_128441_("SecondRequiredKills")) {
            this.secondRequiredKills = tag.m_128451_("SecondRequiredKills");
        }
        if (tag.m_128441_("SecondCurrentKills")) {
            this.secondCurrentKills = tag.m_128451_("SecondCurrentKills");
        }
        if (tag.m_128441_("Weight")) {
            this.weight = tag.m_128451_("Weight");
        }
    }

    public boolean isValid() {
        return this.questId != null && this.questNpcId != null;
    }

    public UUID getQuestId() {
        return this.questId;
    }

    public String getQuestName() {
        return this.questName;
    }

    public String getQuestDescription() {
        return this.questDescription;
    }

    public List<ItemStack> getQuestRequirements() {
        return this.questRequirements;
    }

    public List<ItemStack> getQuestRewards() {
        return this.questRewards;
    }

    public void setQuestRewards(List<ItemStack> questRewards) {
        this.questRewards = questRewards;
    }

    public boolean isNeedRefresh() {
        return this.needRefresh;
    }

    public void setNeedRefresh(boolean needRefresh) {
        this.needRefresh = needRefresh;
    }

    public UUID getQuestNpcId() {
        return this.questNpcId;
    }

    public void setQuestNpcId(UUID questNpcId) {
        this.questNpcId = questNpcId;
    }

    public UUID getAcceptedBy() {
        return this.acceptedBy;
    }

    public void setAcceptedBy(UUID playerId) {
        this.acceptedBy = playerId;
    }

    public QuestType getQuestType() {
        return this.questType;
    }

    public String getTargetEntity() {
        return this.targetEntity;
    }

    public int getRequiredKills() {
        return this.requiredKills;
    }

    public void setRequiredKills(int requiredKills) {
        this.requiredKills = requiredKills;
    }

    public int getCurrentKills() {
        return this.currentKills;
    }

    public void setCurrentKills(int kills) {
        this.currentKills = kills;
    }

    public void incrementKills() {
        ++this.currentKills;
    }

    public void secondIncrementKills() {
        ++this.secondCurrentKills;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public String getQuestRequirementsDescription() {
        return this.questRequirementsDescription;
    }

    public boolean isQuestGenerateTarget() {
        return this.questGenerateTarget;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean complete) {
        this.isComplete = complete;
    }

    public int getQuestCurrentDay() {
        return this.questCurrentDay;
    }

    public void setQuestCurrentDay(int questCurrentDay) {
        this.questCurrentDay = questCurrentDay;
    }

    public int getQuestDay() {
        return this.questDay;
    }

    public int getQuestTargetCount() {
        return this.questTargetCount;
    }

    public int getQuestCurrentTargetCount() {
        return this.questCurrentTargetCount;
    }

    public void setQuestCurrentTargetCount(int questCurrentTargetCount) {
        this.questCurrentTargetCount = questCurrentTargetCount;
    }

    public int getQuestTime() {
        return this.questTime;
    }

    public int getQuestCurrentTime() {
        return this.questCurrentTime;
    }

    public void setQuestCurrentTime() {
        ++this.questCurrentTime;
    }

    public List<QuestEffectEntry> getEffects() {
        return this.effects;
    }

    public void setEffects(List<QuestEffectEntry> effects) {
        this.effects = effects != null ? effects : new ArrayList();
    }

    public boolean isAcceptQuestEffects() {
        return this.isAcceptQuestEffects;
    }

    public void setAcceptQuestEffects(boolean acceptQuestEffects) {
        this.isAcceptQuestEffects = acceptQuestEffects;
    }

    public boolean isEntityTag() {
        return this.isEntityTag;
    }

    public boolean isSecondEntityTag() {
        return this.isSecondEntityTag;
    }

    public String getSecondTargetEntity() {
        return this.secondTargetEntity;
    }

    public int getSecondRequiredKills() {
        return this.secondRequiredKills;
    }

    public int getSecondCurrentKills() {
        return this.secondCurrentKills;
    }

    public void setSecondCurrentKills(int kills) {
        this.secondCurrentKills = kills;
    }

    public boolean isConflictQuest() {
        return this.isConflictQuest;
    }

    public void setConflictQuest(boolean conflictQuest) {
        this.isConflictQuest = conflictQuest;
    }

    public List<UUID> getConflictQuestIds() {
        return this.conflictQuestIds;
    }

    public void setConflictQuestIds(List<UUID> conflictQuestIds) {
        this.conflictQuestIds = conflictQuestIds;
    }

    public List<UUID> getLimitQuestIds() {
        return this.limitQuestIds;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean canComplete(Player player) {
        if (this.questType == QuestType.GATHER) {
            for (ItemStack req : this.questRequirements) {
                if (player.m_150109_().m_18947_(req.m_41720_()) >= req.m_41613_()) continue;
                return false;
            }
            return true;
        }
        if (this.questType == QuestType.KILL) {
            if (this.secondTargetEntity == null) {
                return this.currentKills >= this.requiredKills;
            }
            boolean firstTargetComplete = this.currentKills >= this.requiredKills;
            boolean secondTargetComplete = this.secondCurrentKills >= this.secondRequiredKills;
            return firstTargetComplete && secondTargetComplete;
        }
        if (this.questType == QuestType.RAID || this.questType == QuestType.TREAT || this.questType == QuestType.AUTOMATIC) {
            return this.isComplete;
        }
        return false;
    }

    public boolean isSameQuestType(Quest other) {
        return this.questId.equals(other.questId);
    }

    public boolean isNeedCompletePreQuest() {
        return this.isNeedCompletePreQuest;
    }

    public int getNeedCompletionCount() {
        return this.needCompletionCount;
    }

    public boolean matchesEntity(Entity entity) {
        return this.isEntityTag ? this.matchesEntityTag(entity, this.targetEntity) : this.matchesEntityId(entity, this.targetEntity);
    }

    public boolean matchesSecondEntity(Entity entity) {
        return this.isSecondEntityTag ? this.matchesEntityTag(entity, this.secondTargetEntity) : this.matchesEntityId(entity, this.secondTargetEntity);
    }

    private boolean matchesEntityTag(Entity entity, String targetEntity) {
        TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation(targetEntity.substring(1)));
        return entity.m_6095_().m_204039_(tag);
    }

    private boolean matchesEntityId(Entity entity, String targetEntity) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        return entityId.toString().equals(targetEntity);
    }

    public boolean checkConflictQuests(PlayerQuestCapability capability) {
        if (this.conflictQuestIds.isEmpty()) {
            return false;
        }
        return this.isConflictQuest && this.checkConflictPrerequisites(capability);
    }

    private boolean checkConflictPrerequisites(PlayerQuestCapability capability) {
        return this.conflictQuestIds.stream().anyMatch(capability::isQuestCompleted);
    }

    public boolean checkPrerequisiteQuests(PlayerQuestCapability capability) {
        if (this.limitQuestIds.isEmpty()) {
            return true;
        }
        return this.isNeedCompletePreQuest ? this.checkCompletedPrerequisites(capability) : this.checkNeverAcceptedPrerequisites(capability);
    }

    private boolean checkCompletedPrerequisites(PlayerQuestCapability capability) {
        return this.limitQuestIds.stream().anyMatch(limitQuestIds -> capability.getCompletionCount((UUID)limitQuestIds) >= this.needCompletionCount);
    }

    private boolean checkNeverAcceptedPrerequisites(PlayerQuestCapability capability) {
        return this.limitQuestIds.stream().anyMatch(capability::isQuestAccepted);
    }

    public void giveRewards(Player player) {
        if (this.questId.equals(PlayerQuestEvent.REN_WO_XING_QUEST_ID)) {
            player.getCapability(ChangShengJueCapabiliy.KUNGFU).ifPresent(cap -> {
                ArrayList<AbstractionInternalkungfu> kungFus = new ArrayList<AbstractionInternalkungfu>();
                cap.getAllLearned().forEach(kungFu -> {
                    if (kungFu instanceof AbstractionInternalkungfu) {
                        AbstractionInternalkungfu upgradable = (AbstractionInternalkungfu)kungFu;
                        kungFus.add(upgradable);
                    }
                });
                kungFus.sort(Comparator.comparingInt(kf -> kf.getMaxExp() - kf.getExp()));
                for (AbstractionInternalkungfu kungFu2 : kungFus) {
                    if (kungFu2.getLevel() < kungFu2.getMaxLevel()) {
                        for (ItemStack reward : this.questRewards) {
                            Item patt34882$temp = reward.m_41720_();
                            if (!(patt34882$temp instanceof InternalkungfuXp)) continue;
                            InternalkungfuXp internalkungfuXp = (InternalkungfuXp)patt34882$temp;
                            internalkungfuXp.m_7203_(player.m_9236_(), player, player.m_7655_());
                            return;
                        }
                        continue;
                    }
                    for (ItemStack reward : this.questRewards) {
                        if (reward.m_41720_() instanceof InternalkungfuXp) continue;
                        player.m_150109_().m_36054_(reward.m_41777_());
                        return;
                    }
                }
            });
            return;
        }
        if (this.questId.equals(PlayerQuestEvent.KUAI_YI_EN_CHOU_QUEST_ID)) {
            player.getCapability(ChangShengJueCapabiliy.KUNGFU).ifPresent(cap -> {
                ArrayList<AbstractionExternalKunfu> kungFus = new ArrayList<AbstractionExternalKunfu>();
                cap.getAllLearned().forEach(kungFu -> {
                    if (kungFu instanceof AbstractionExternalKunfu) {
                        AbstractionExternalKunfu upgradable = (AbstractionExternalKunfu)kungFu;
                        kungFus.add(upgradable);
                    }
                });
                kungFus.sort(Comparator.comparingInt(kf -> kf.getMaxExp() - kf.getExp()));
                for (AbstractionExternalKunfu kungFu2 : kungFus) {
                    if (kungFu2.getLevel() < kungFu2.getMaxLevel()) {
                        for (ItemStack reward : this.questRewards) {
                            Item patt36472$temp = reward.m_41720_();
                            if (!(patt36472$temp instanceof ExternalKungfuXp)) continue;
                            ExternalKungfuXp externalKungfuXp = (ExternalKungfuXp)patt36472$temp;
                            externalKungfuXp.m_7203_(player.m_9236_(), player, player.m_7655_());
                            return;
                        }
                        continue;
                    }
                    for (ItemStack reward : this.questRewards) {
                        if (reward.m_41720_() instanceof ExternalKungfuXp) continue;
                        player.m_150109_().m_36054_(reward.m_41777_());
                        return;
                    }
                }
            });
            return;
        }
        for (ItemStack reward : this.questRewards) {
            player.m_150109_().m_36054_(reward.m_41777_());
        }
    }

    public void takeRequirements(Player player) {
        if (this.questRequirements != null) {
            for (ItemStack req : this.questRequirements) {
                player.m_150109_().m_36022_(p -> p.m_41720_() == req.m_41720_(), req.m_41613_(), (Container)player.f_36095_.m_39730_());
            }
        }
    }

    public void applyEffects(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        for (QuestEffectEntry effect : this.effects) {
            MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effect.effectId()));
            if (mobEffect == null) continue;
            player.m_7292_(new MobEffectInstance(mobEffect, effect.duration(), effect.amplifier(), effect.isAmbient(), effect.showParticles(), effect.showIcon()));
        }
    }

    @NotNull
    private ListTag getTags() {
        ListTag effectsList = new ListTag();
        for (QuestEffectEntry effect : this.effects) {
            CompoundTag effectTag = new CompoundTag();
            effectTag.m_128359_("id", effect.effectId());
            effectTag.m_128405_("duration", effect.duration());
            effectTag.m_128405_("amplifier", effect.amplifier());
            effectTag.m_128379_("ambient", effect.isAmbient());
            effectTag.m_128379_("showParticles", effect.showParticles());
            effectTag.m_128379_("showIcon", effect.showIcon());
            effectsList.add((Object)effectTag);
        }
        return effectsList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quest)) {
            return false;
        }
        Quest quest = (Quest)o;
        return Objects.equals(this.questId, quest.questId) && Objects.equals(this.questNpcId, quest.questNpcId) && this.questType == quest.questType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.questId, this.questNpcId, this.questType});
    }

    public static enum QuestType {
        GATHER,
        KILL,
        RAID,
        TREAT,
        AUTOMATIC;

    }
}

