/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.quest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shengchanshe.chang_sheng_jue.ChangShengJue;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import com.shengchanshe.chang_sheng_jue.quest.QuestEffectEntry;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class QuestLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Quest loadSpecificQuest(UUID questId, Set<UUID> completedNonRepeatable, UUID npcId) {
        Map<ResourceLocation, Resource> allResources = QuestLoader.getAutomaticResourceLocationResourceMap();
        Iterator<ResourceLocation> iterator = allResources.keySet().iterator();
        while (iterator.hasNext()) {
            ResourceLocation loc = iterator.next();
            try {
                InputStream stream = allResources.get(loc).m_215507_();
                try {
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream), JsonObject.class);
                    UUID currentId = UUID.fromString(json.get("questId").getAsString());
                    boolean repeatable = json.get("repeatable").getAsBoolean();
                    if (!repeatable && completedNonRepeatable.contains(questId) || !currentId.equals(questId)) continue;
                    Quest quest = QuestLoader.parseQuest(json, npcId);
                    return quest;
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                ChangShengJue.LOGGER.error("\u52a0\u8f7d\u4efb\u52a1\u5931\u8d25: {}", (Object)loc, (Object)e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Quest loadSpecificQuest(UUID questId, UUID npcId) {
        Map<ResourceLocation, Resource> allResources = QuestLoader.getAutomaticResourceLocationResourceMap();
        Iterator<ResourceLocation> iterator = allResources.keySet().iterator();
        while (iterator.hasNext()) {
            ResourceLocation loc = iterator.next();
            try {
                InputStream stream = allResources.get(loc).m_215507_();
                try {
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream), JsonObject.class);
                    UUID currentId = UUID.fromString(json.get("questId").getAsString());
                    if (!currentId.equals(questId)) continue;
                    Quest quest = QuestLoader.parseQuest(json, npcId);
                    return quest;
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                ChangShengJue.LOGGER.error("\u52a0\u8f7d\u4efb\u52a1\u5931\u8d25: {}", (Object)loc, (Object)e);
            }
        }
        return null;
    }

    public static List<Quest> loadAllAvailableQuests(UUID npcId, Set<UUID> completedNonRepeatable) {
        Map<ResourceLocation, Resource> allResources = QuestLoader.getResourceLocationResourceMap();
        ArrayList<Quest> quests = new ArrayList<Quest>();
        for (ResourceLocation loc : allResources.keySet()) {
            try {
                InputStream stream = allResources.get(loc).m_215507_();
                try {
                    Quest quest;
                    UUID questId;
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream), JsonObject.class);
                    boolean repeatable = json.get("repeatable").getAsBoolean();
                    UUID uUID = questId = json.has("questId") ? UUID.fromString(json.get("questId").getAsString()) : QuestLoader.generateDeterministicId(npcId, json);
                    if (!repeatable && completedNonRepeatable.contains(questId) || (quest = QuestLoader.parseQuest(json, npcId)) == null) continue;
                    quests.add(quest);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                ChangShengJue.LOGGER.error("\u52a0\u8f7d\u4efb\u52a1\u5931\u8d25: {}", (Object)loc, (Object)e);
            }
        }
        return quests;
    }

    @NotNull
    private static Map<ResourceLocation, Resource> getAutomaticResourceLocationResourceMap() {
        ResourceManager resourceManager = ServerLifecycleHooks.getCurrentServer().m_177941_();
        String namespace = "chang_sheng_jue";
        String[] questPaths = new String[]{"quests/automatic"};
        HashMap<ResourceLocation, Resource> allResources = new HashMap<ResourceLocation, Resource>();
        for (String path : questPaths) {
            Map resources = resourceManager.m_214159_(path, location -> location.m_135827_().equals(namespace) && location.m_135815_().endsWith(".json"));
            allResources.putAll(resources);
        }
        return allResources;
    }

    @NotNull
    private static Map<ResourceLocation, Resource> getResourceLocationResourceMap() {
        ResourceManager resourceManager = ServerLifecycleHooks.getCurrentServer().m_177941_();
        String namespace = "chang_sheng_jue";
        String[] questPaths = new String[]{"quests/gather", "quests/kill", "quests/raid", "quests/treat"};
        HashMap<ResourceLocation, Resource> allResources = new HashMap<ResourceLocation, Resource>();
        for (String path : questPaths) {
            Map resources = resourceManager.m_214159_(path, location -> location.m_135827_().equals(namespace) && location.m_135815_().endsWith(".json"));
            allResources.putAll(resources);
        }
        return allResources;
    }

    private static Quest parseQuest(JsonObject json, UUID npcId) {
        try {
            UUID questId = json.has("questId") ? UUID.fromString(json.get("questId").getAsString()) : QuestLoader.generateDeterministicId(npcId, json);
            String title = json.has("questName") ? json.get("questName").getAsString() : "";
            String description = json.has("questDescription") ? json.get("questDescription").getAsString() : "";
            String typeStr = json.has("questType") ? json.get("questType").getAsString() : "GATHER";
            Quest.QuestType type = Quest.QuestType.valueOf(typeStr.toUpperCase());
            boolean repeatable = json.has("repeatable") && json.get("repeatable").getAsBoolean();
            String questRequirementsDescription = json.has("questRequirementsDescription") ? json.get("questRequirementsDescription").getAsString() : "";
            ArrayList<QuestEffectEntry> effects = new ArrayList<QuestEffectEntry>();
            if (json.has("effects")) {
                JsonArray effectsJson = json.getAsJsonArray("effects");
                for (JsonElement element : effectsJson) {
                    JsonObject effectJson = element.getAsJsonObject();
                    effects.add(new QuestEffectEntry(effectJson.get("effectId").getAsString(), effectJson.get("duration").getAsInt(), effectJson.get("amplifier").getAsInt(), effectJson.has("isAmbient") && effectJson.get("isAmbient").getAsBoolean(), !effectJson.has("showParticles") || effectJson.get("showParticles").getAsBoolean(), !effectJson.has("showIcon") || effectJson.get("showIcon").getAsBoolean()));
                }
            }
            List<ItemStack> requirements = json.has("questRequirements") ? QuestLoader.parseItemList((JsonElement)json.getAsJsonArray("questRequirements")) : Collections.emptyList();
            List<ItemStack> rewards = json.has("questRewards") ? QuestLoader.parseItemList((JsonElement)json.getAsJsonArray("questRewards")) : Collections.emptyList();
            int questDay = json.has("qusetDay") ? json.get("questDay").getAsInt() : 0;
            String targetEntity = json.has("targetEntity") ? json.get("targetEntity").getAsString() : "";
            boolean isEntityTag = targetEntity.startsWith("#");
            int requiredKills = QuestLoader.getRequiredKills(json);
            boolean questGenerateTarget = json.has("questGenerateTarget") && json.get("questGenerateTarget").getAsBoolean();
            int questTargetCount = json.has("questTargetCount") ? json.get("questTargetCount").getAsInt() : 0;
            int questTime = json.has("questTime") ? json.get("questTime").getAsInt() : 0;
            boolean isAcceptQuestEffects = json.has("isAcceptQuestEffects") && json.get("isAcceptQuestEffects").getAsBoolean();
            ArrayList<UUID> limitQuestIds = new ArrayList<UUID>();
            if (json.has("limitQuestIds")) {
                JsonArray idArray = json.getAsJsonArray("limitQuestIds");
                for (JsonElement element : idArray) {
                    try {
                        limitQuestIds.add(UUID.fromString(element.getAsString()));
                    }
                    catch (IllegalArgumentException e) {
                        ChangShengJue.LOGGER.error("\u65e0\u6548\u7684\u4efb\u52a1ID\u683c\u5f0f: {}", (Object)element.getAsString());
                    }
                }
            }
            boolean isNeedCompletePreQuest = json.has("isNeedCompletePreQuest") && json.get("isNeedCompletePreQuest").getAsBoolean();
            ArrayList<UUID> conflictQuestIds = new ArrayList<UUID>();
            if (json.has("conflictQuestIds")) {
                JsonArray idArray = json.getAsJsonArray("conflictQuestIds");
                for (JsonElement element : idArray) {
                    try {
                        conflictQuestIds.add(UUID.fromString(element.getAsString()));
                    }
                    catch (IllegalArgumentException e) {
                        ChangShengJue.LOGGER.error("\u65e0\u6548\u7684\u4efb\u52a1ID\u683c\u5f0f: {}", (Object)element.getAsString());
                    }
                }
            }
            boolean isConflictQuest = json.has("isConflictQuest") && json.get("isConflictQuest").getAsBoolean();
            int needCompletionCount = json.has("needCompletionCount") ? json.get("needCompletionCount").getAsInt() : 0;
            boolean needRefresh = json.has("needRefresh") && json.get("needRefresh").getAsBoolean();
            int weight = json.has("weight") ? json.get("weight").getAsInt() : 1;
            String secondTargetEntity = json.has("secondTargetEntity") ? json.get("secondTargetEntity").getAsString() : "";
            boolean isSecondEntityTag = targetEntity.startsWith("#");
            int secondRequiredKills = QuestLoader.getSecondRequiredKills(json);
            return new Quest(questId, npcId, title, description, needRefresh, requirements, rewards, type, targetEntity, isEntityTag, requiredKills, secondTargetEntity, secondRequiredKills, isSecondEntityTag, repeatable, questRequirementsDescription, questGenerateTarget, questDay, questTargetCount, questTime, effects, isAcceptQuestEffects, limitQuestIds, isNeedCompletePreQuest, conflictQuestIds, isConflictQuest, needCompletionCount, weight);
        }
        catch (Exception e) {
            ChangShengJue.LOGGER.error("\u89e3\u6790\u4efb\u52a1JSON\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static int getSecondRequiredKills(JsonObject json) {
        if (json.has("minSecondKills") && json.has("maxSecondKills")) {
            int minKills = json.get("minSecondKills").getAsInt();
            int maxKills = json.get("maxSecondKills").getAsInt();
            return Math.toIntExact(Math.round(Math.random() * (double)(maxKills - minKills) + (double)minKills));
        }
        return json.has("secondRequiredKills") ? json.get("secondRequiredKills").getAsInt() : 0;
    }

    private static int getRequiredKills(JsonObject json) {
        if (json.has("minKills") && json.has("maxKills")) {
            int minKills = json.get("minKills").getAsInt();
            int maxKills = json.get("maxKills").getAsInt();
            return Math.toIntExact(Math.round(Math.random() * (double)(maxKills - minKills) + (double)minKills));
        }
        return json.has("requiredKills") ? json.get("requiredKills").getAsInt() : 0;
    }

    private static UUID generateDeterministicId(UUID npcId, JsonObject json) {
        String uniqueKey = String.format("%s|%s|%s", npcId, json.get("questName").getAsString(), json.get("type").getAsString());
        return UUID.nameUUIDFromBytes(uniqueKey.getBytes(StandardCharsets.UTF_8));
    }

    public static List<ItemStack> parseItemList(JsonElement element) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        RandomSource random = RandomSource.m_216327_();
        element.getAsJsonArray().forEach(itemJson -> {
            JsonObject itemObj = itemJson.getAsJsonObject();
            String itemId = itemObj.get("item").getAsString();
            int count = QuestLoader.parseCount(itemObj.get("count"), random);
            if (itemId.startsWith("#")) {
                String tagId = itemId.substring(1);
                ResourceLocation tagLocation = new ResourceLocation(tagId);
                TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)tagLocation);
                if (ForgeRegistries.ITEMS.tags() == null) {
                    System.err.println("\u6807\u7b7e\u7cfb\u7edf\u672a\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u89e3\u6790\u6807\u7b7e: " + tagId);
                    return;
                }
                ITag tag = ForgeRegistries.ITEMS.tags().getTag(tagKey);
                if (!tag.isEmpty()) {
                    List tagItems = tag.stream().toList();
                    Item randomItem = (Item)tagItems.get(random.m_188503_(tagItems.size()));
                    items.add(new ItemStack((ItemLike)randomItem, count));
                } else {
                    System.err.println("\u6807\u7b7e\u4e0d\u5b58\u5728\u6216\u4e3a\u7a7a: " + tagId);
                }
            } else {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
                if (item != null) {
                    items.add(new ItemStack((ItemLike)item, count));
                } else {
                    System.err.println("\u672a\u77e5\u7269\u54c1: " + itemId);
                }
            }
        });
        return items;
    }

    private static int parseCount(JsonElement countElement, RandomSource random) {
        String type;
        if (countElement.isJsonPrimitive()) {
            return countElement.getAsInt();
        }
        JsonObject countObj = countElement.getAsJsonObject();
        switch (type = countObj.get("type").getAsString()) {
            case "minecraft:uniform": {
                float min = countObj.get("min").getAsFloat();
                float max = countObj.get("max").getAsFloat();
                return Math.round(min + (max - min) * random.m_188501_());
            }
            case "minecraft:binomial": {
                int n = countObj.get("n").getAsInt();
                float p = countObj.get("p").getAsFloat();
                int binomialCount = 0;
                for (int i = 0; i < n; ++i) {
                    if (!(random.m_188501_() < p)) continue;
                    ++binomialCount;
                }
                return binomialCount;
            }
        }
        System.err.println("\u672a\u77e5\u7684count\u7c7b\u578b: " + type);
        return 1;
    }
}

