/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.quest;

import com.shengchanshe.chang_sheng_jue.capability.quest.PlayerQuestCapabilityProvider;
import com.shengchanshe.chang_sheng_jue.cilent.gui.screens.wuxia.playerquest.PlayerQuestMenu;
import com.shengchanshe.chang_sheng_jue.entity.custom.wuxia.gangleader.AbstractGangLeader;
import com.shengchanshe.chang_sheng_jue.event.quest.PlayerQuestEvent;
import com.shengchanshe.chang_sheng_jue.network.ChangShengJueMessages;
import com.shengchanshe.chang_sheng_jue.network.packet.gui.playerquest.RefreshPlayerQuestScreenPacket;
import com.shengchanshe.chang_sheng_jue.network.packet.gui.quest.RefreshQuestScreenPacket;
import com.shengchanshe.chang_sheng_jue.quest.Quest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class QuestManager {
    private static QuestManager instance;
    private final Map<UUID, Integer> questCompletionCounts = new ConcurrentHashMap<UUID, Integer>();

    public static QuestManager getInstance() {
        if (instance == null) {
            instance = new QuestManager();
        }
        return instance;
    }

    public void acceptQuest(Player player, AbstractGangLeader gangLeader, UUID questId) {
        player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
            List<Quest> npcQuests = gangLeader.getPlayerQuests(player.m_20148_());
            Optional<Quest> existingQuest = npcQuests.stream().filter(Objects::nonNull).filter(q -> q.getQuestId().equals(questId)).findFirst();
            if (existingQuest.isPresent()) {
                Quest targetQuest = existingQuest.get();
                if (!gangLeader.m_20148_().equals(targetQuest.getQuestNpcId())) {
                    return;
                }
                if (targetQuest.getAcceptedBy() != null) {
                    return;
                }
                targetQuest.setAcceptedBy(player.m_20148_());
                cap.setQuests(targetQuest, player.m_20148_());
                cap.markQuestAccepted(targetQuest.getQuestId());
                gangLeader.addQuestForPlayer(player.m_20148_(), targetQuest);
                int requiredKills = targetQuest.getRequiredKills();
                this.spawnTargetForQuest((ServerPlayer)player, targetQuest, requiredKills);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    cap.syncToClient(serverPlayer);
                    ChangShengJueMessages.sendToPlayer(new RefreshQuestScreenPacket(gangLeader.getPlayerQuests(player.m_20148_())), serverPlayer);
                }
            }
        });
    }

    public void submitPlayerQuest(Player player, Quest quest, AbstractContainerMenu menu) {
        if (menu instanceof PlayerQuestMenu) {
            if (quest == null) {
                return;
            }
            player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
                Optional<Quest> matchedQuest = cap.getQuests(player.m_20148_()).stream().filter(q -> q != null && q.getQuestId().equals(quest.getQuestId())).findFirst();
                if (matchedQuest.isEmpty()) {
                    return;
                }
                Quest actualQuest = matchedQuest.get();
                if (!actualQuest.canComplete(player)) {
                    player.m_213846_((Component)Component.m_237115_((String)"quest.chang_sheng_jue.requirements.prompt"));
                    return;
                }
                actualQuest.takeRequirements(player);
                actualQuest.giveRewards(player);
                actualQuest.setComplete(false);
                actualQuest.applyEffects(player);
                actualQuest.setAcceptedBy(null);
                actualQuest.setNeedRefresh(true);
                if (actualQuest.getQuestId().equals(PlayerQuestEvent.KUAI_YI_EN_CHOU_QUEST_ID) && quest.getQuestNpcId() != null) {
                    this.questCompletionCounts.merge(actualQuest.getQuestId(), 1, Integer::sum);
                }
                cap.markQuestCompleted(actualQuest.getQuestId());
                cap.setCompletionCount(actualQuest.getQuestId());
                Optional<Quest> clashQuest = cap.getQuests(player.m_20148_()).stream().filter(q -> q != null && quest.getConflictQuestIds().contains(q.getQuestId())).findFirst();
                clashQuest.ifPresent(value -> cap.removeQuestFromPlayer(player.m_20148_(), value.getQuestId()));
                cap.removeQuestFromPlayer(player.m_20148_(), actualQuest.getQuestId());
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    cap.syncToClient(serverPlayer);
                    ChangShengJueMessages.sendToPlayer(new RefreshPlayerQuestScreenPacket(), serverPlayer);
                }
            });
        }
    }

    public void abandonPlayerQuest(Player player, Quest quest) {
        if (quest == null) {
            return;
        }
        player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).ifPresent(cap -> {
            Optional<Quest> matchedQuest = cap.getQuests(player.m_20148_()).stream().filter(q -> q != null && q.getQuestId().equals(quest.getQuestId())).findFirst();
            if (matchedQuest.isEmpty()) {
                return;
            }
            Quest actualQuest = matchedQuest.get();
            actualQuest.setComplete(false);
            actualQuest.setAcceptedBy(null);
            cap.removeQuestFromPlayer(player.m_20148_(), quest.getQuestId());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                cap.syncToClient(serverPlayer);
                ChangShengJueMessages.sendToPlayer(new RefreshPlayerQuestScreenPacket(), serverPlayer);
            }
        });
    }

    public void spawnTargetForQuest(ServerPlayer player, Quest quest, int count) {
        block11: {
            LivingEntity entity;
            EntityType type2;
            String targetId;
            Level level;
            block12: {
                LivingEntity entity2;
                int i;
                EntityType selectedType;
                List<EntityType> possibleTypes;
                TagKey entityTag;
                ResourceLocation tagId;
                level = player.m_9236_();
                RandomSource rand = player.m_217043_();
                targetId = quest.getTargetEntity();
                String secondTargetId = quest.getSecondTargetEntity();
                if (quest.isAcceptQuestEffects()) {
                    quest.applyEffects((Player)player);
                }
                if (!quest.isQuestGenerateTarget()) break block11;
                if (secondTargetId != null && !secondTargetId.isEmpty()) {
                    if (secondTargetId.startsWith("#")) {
                        tagId = new ResourceLocation(secondTargetId.substring(1));
                        entityTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagId);
                        possibleTypes = ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(type -> {
                            Optional holder = ForgeRegistries.ENTITY_TYPES.getHolder(type);
                            return holder.map(h -> level.m_9598_().m_175515_(Registries.f_256939_).m_203431_(entityTag).map(tag -> tag.m_203333_(h)).orElse(false)).orElse(false);
                        }).toList();
                        if (!possibleTypes.isEmpty()) {
                            selectedType = possibleTypes.get(rand.m_188503_(possibleTypes.size()));
                            for (i = 0; i < count; ++i) {
                                entity2 = this.spawnEntityAtValidPosition(level, player, selectedType);
                                if (entity2 == null) continue;
                                this.setAttackTarget(entity2, (Player)player);
                            }
                        }
                    } else {
                        type2 = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(secondTargetId));
                        if (type2 != null) {
                            for (int i2 = 0; i2 < count; ++i2) {
                                entity = this.spawnEntityAtValidPosition(level, player, type2);
                                if (entity == null) continue;
                                this.setAttackTarget(entity, (Player)player);
                            }
                        }
                    }
                }
                if (!targetId.startsWith("#")) break block12;
                tagId = new ResourceLocation(targetId.substring(1));
                entityTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagId);
                possibleTypes = ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(type -> {
                    Optional holder = ForgeRegistries.ENTITY_TYPES.getHolder(type);
                    return holder.map(h -> level.m_9598_().m_175515_(Registries.f_256939_).m_203431_(entityTag).map(tag -> tag.m_203333_(h)).orElse(false)).orElse(false);
                }).toList();
                if (possibleTypes.isEmpty()) break block11;
                selectedType = possibleTypes.get(rand.m_188503_(possibleTypes.size()));
                for (i = 0; i < count; ++i) {
                    entity2 = this.spawnEntityAtValidPosition(level, player, selectedType);
                    if (entity2 == null) continue;
                    this.setAttackTarget(entity2, (Player)player);
                }
                break block11;
            }
            type2 = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(targetId));
            if (type2 != null) {
                for (int i = 0; i < count; ++i) {
                    entity = this.spawnEntityAtValidPosition(level, player, type2);
                    if (entity == null) continue;
                    this.setAttackTarget(entity, (Player)player);
                }
            }
        }
    }

    private LivingEntity spawnEntityAtValidPosition(Level level, ServerPlayer player, EntityType<?> type) {
        for (int i = 0; i < 10; ++i) {
            LivingEntity entity;
            Vec3 pos = player.m_20182_().m_82520_((double)(player.m_217043_().m_188503_(20) - 10), 0.0, (double)(player.m_217043_().m_188503_(20) - 10));
            BlockPos groundPos = this.findGroundPos(level, new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
            if (groundPos == null || (entity = (LivingEntity)type.m_20615_(level)) == null) continue;
            entity.m_6034_((double)groundPos.m_123341_() + 0.5, (double)groundPos.m_123342_(), (double)groundPos.m_123343_() + 0.5);
            if (level.m_45786_((Entity)entity)) {
                level.m_7967_((Entity)entity);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 500, 0, false, false));
                return entity;
            }
            entity.m_146870_();
        }
        LivingEntity entity = (LivingEntity)type.m_20615_(level);
        if (entity != null) {
            entity.m_146884_(player.m_20182_());
            level.m_7967_((Entity)entity);
            return entity;
        }
        return null;
    }

    private void setAttackTarget(LivingEntity entity, Player player) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_6710_((LivingEntity)player);
        } else if (entity instanceof NeutralMob) {
            NeutralMob neutralMob = (NeutralMob)entity;
            neutralMob.m_6710_((LivingEntity)player);
        }
    }

    private BlockPos findGroundPos(Level level, BlockPos startPos) {
        BlockPos.MutableBlockPos mutablePos = startPos.m_122032_();
        while (mutablePos.m_123342_() < level.m_151558_()) {
            if (this.canSpawnAt(level, (BlockPos)mutablePos)) {
                return mutablePos;
            }
            mutablePos.m_122173_(Direction.UP);
        }
        mutablePos.m_122190_((Vec3i)startPos);
        while (mutablePos.m_123342_() > level.m_141937_()) {
            if (this.canSpawnAt(level, (BlockPos)mutablePos)) {
                return mutablePos;
            }
            mutablePos.m_122173_(Direction.DOWN);
        }
        return null;
    }

    private boolean canSpawnAt(Level level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        BlockState belowState = level.m_8055_(pos.m_7495_());
        return (blockState.m_60795_() || blockState.m_247087_()) && belowState.m_60804_((BlockGetter)level, pos.m_7495_());
    }

    public List<Quest> getPlayerQuests(Level level, UUID playerId) {
        Player player;
        if (playerId == null) {
            return Collections.emptyList();
        }
        if (level != null && (player = level.m_46003_(playerId)) != null) {
            return this.getQuestsFromCapability(player);
        }
        ServerPlayer serverPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerId);
        if (serverPlayer != null) {
            return this.getQuestsFromCapability((Player)serverPlayer);
        }
        return Collections.emptyList();
    }

    private List<Quest> getQuestsFromCapability(Player player) {
        return player.getCapability(PlayerQuestCapabilityProvider.PLAYER_QUEST_CAPABILITY).map(cap -> cap.getQuests(player.m_20148_())).orElse(Collections.emptyList());
    }

    public int getTotalQuestCompletions() {
        return this.questCompletionCounts.values().stream().mapToInt(Integer::intValue).sum();
    }

    public void addKungFuCount(Player player, int count) {
    }
}

