/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.shengchanshe.chang_sheng_jue.ChangShengJue;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ForgeBlockRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final String group;

    public ForgeBlockRecipe(ResourceLocation id, ItemStack result, NonNullList<Ingredient> ingredients, String group) {
        this.id = id;
        this.result = result;
        this.ingredients = ingredients;
        this.group = group;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (container.m_6643_() < this.ingredients.size()) {
            return false;
        }
        for (int i = 0; i < this.ingredients.size(); ++i) {
            if (((Ingredient)this.ingredients.get(i)).test(container.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public String m_6076_() {
        return this.group;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<ForgeBlockRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("chang_sheng_jue", "forge_block");

        @NotNull
        public ForgeBlockRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            Serializer.validateResourceLocation(recipeId);
            ItemStack result = Serializer.safelyParseItemStack(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList inputs = NonNullList.m_122779_();
            for (JsonElement element : ingredients) {
                inputs.add((Object)Serializer.safelyParseIngredient(element));
            }
            return new ForgeBlockRecipe(recipeId, result, (NonNullList<Ingredient>)inputs, group);
        }

        public ForgeBlockRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            try {
                String group = buffer.m_130136_(64);
                int size = buffer.m_130242_();
                NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
                for (int i = 0; i < size; ++i) {
                    inputs.set(i, (Object)Serializer.safelyReadIngredient(buffer));
                }
                ItemStack result = Serializer.safelyReadItemStack(buffer);
                return new ForgeBlockRecipe(recipeId, result, (NonNullList<Ingredient>)inputs, group);
            }
            catch (Exception e) {
                ChangShengJue.LOGGER.error("Failed to deserialize recipe {} from network", (Object)recipeId, (Object)e);
                throw new RecipeDecodeException("Failed to decode recipe: " + recipeId, e);
            }
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, ForgeBlockRecipe recipe) {
            try {
                buffer.m_130072_(recipe.group, 64);
                buffer.m_130130_(recipe.ingredients.size());
                for (Ingredient ingredient : recipe.ingredients) {
                    Serializer.safelyWriteIngredient(buffer, ingredient);
                }
                Serializer.safelyWriteItemStack(buffer, recipe.result);
            }
            catch (Exception e) {
                ChangShengJue.LOGGER.error("Failed to serialize recipe {}", (Object)recipe.id, (Object)e);
                throw new RecipeEncodeException("Failed to encode recipe: " + recipe.id, e);
            }
        }

        private static void validateResourceLocation(ResourceLocation id) {
            Objects.requireNonNull(id, "Recipe ID cannot be null");
            if (!id.m_135827_().matches("[a-z0-9_.-]+") || !id.m_135815_().matches("[a-z0-9_./-]+")) {
                throw new JsonSyntaxException("Invalid recipe ID format: " + id);
            }
        }

        private static ItemStack safelyParseItemStack(JsonObject json) {
            try {
                return ShapedRecipe.m_151274_((JsonObject)json);
            }
            catch (Exception e) {
                ChangShengJue.LOGGER.error("Failed to parse item stack from JSON", (Throwable)e);
                return ItemStack.f_41583_;
            }
        }

        private static Ingredient safelyParseIngredient(JsonElement json) {
            try {
                JsonObject jsonObj = GsonHelper.m_13918_((JsonElement)json, (String)"ingredient");
                if (jsonObj.has("tag")) {
                    Ingredient ingredient = Ingredient.m_43917_((JsonElement)json);
                    if (jsonObj.has("count")) {
                        int count = GsonHelper.m_13927_((JsonObject)jsonObj, (String)"count");
                        return new CountedIngredient(ingredient, count);
                    }
                    return ingredient;
                }
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)json);
                if (jsonObj.has("count")) {
                    ItemStack[] stacks;
                    int count = GsonHelper.m_13927_((JsonObject)jsonObj, (String)"count");
                    for (ItemStack stack : stacks = ingredient.m_43908_()) {
                        stack.m_41764_(count);
                    }
                    return Ingredient.m_43927_((ItemStack[])stacks);
                }
                return ingredient;
            }
            catch (Exception e) {
                ChangShengJue.LOGGER.error("Failed to parse ingredient from JSON", (Throwable)e);
                return Ingredient.f_43901_;
            }
        }

        private static Ingredient safelyReadIngredient(FriendlyByteBuf buffer) {
            try {
                ItemStack stack = buffer.m_130267_();
                int count = buffer.m_130242_();
                if (!stack.m_41619_()) {
                    stack.m_41764_(count);
                    return Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
                }
                return Ingredient.f_43901_;
            }
            catch (Exception e) {
                ChangShengJue.LOGGER.error("Failed to read ingredient from network", (Throwable)e);
                return Ingredient.f_43901_;
            }
        }

        private static ItemStack safelyReadItemStack(FriendlyByteBuf buffer) {
            try {
                return buffer.m_130267_();
            }
            catch (Exception e) {
                ChangShengJue.LOGGER.error("Failed to read item stack from network", (Throwable)e);
                return ItemStack.f_41583_;
            }
        }

        private static void safelyWriteIngredient(FriendlyByteBuf buffer, Ingredient ingredient) {
            try {
                ItemStack[] items = ingredient.m_43908_();
                if (items.length > 0) {
                    buffer.m_130055_(items[0].m_41777_());
                    buffer.m_130130_(items[0].m_41613_());
                } else {
                    buffer.m_130055_(ItemStack.f_41583_);
                    buffer.m_130130_(0);
                }
            }
            catch (Exception e) {
                ChangShengJue.LOGGER.error("Failed to write ingredient to network", (Throwable)e);
                buffer.m_130055_(ItemStack.f_41583_);
                buffer.m_130130_(0);
            }
        }

        private static void safelyWriteItemStack(FriendlyByteBuf buffer, ItemStack stack) {
            try {
                buffer.m_130055_(stack);
            }
            catch (Exception e) {
                ChangShengJue.LOGGER.error("Failed to write item stack to network", (Throwable)e);
                buffer.m_130055_(ItemStack.f_41583_);
            }
        }
    }

    public static class Type
    implements RecipeType<ForgeBlockRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "forge_block";
    }

    public static class RecipeEncodeException
    extends RuntimeException {
        public RecipeEncodeException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class RecipeDecodeException
    extends RuntimeException {
        public RecipeDecodeException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class CountedIngredient
    extends Ingredient {
        private final Ingredient original;
        private final int requiredCount;

        public CountedIngredient(Ingredient original, int count) {
            super(Stream.of(new Ingredient.Value[0]));
            this.original = original;
            this.requiredCount = count;
        }

        public boolean test(@Nullable ItemStack stack) {
            if (stack == null || stack.m_41619_()) {
                return false;
            }
            return this.original.test(stack) && stack.m_41613_() >= this.requiredCount;
        }

        public ItemStack[] m_43908_() {
            ItemStack[] items = this.original.m_43908_();
            if (items.length > 0 && items[0].m_41613_() != this.requiredCount) {
                ItemStack[] countedItems = new ItemStack[items.length];
                for (int i = 0; i < items.length; ++i) {
                    countedItems[i] = items[i].m_41777_();
                    countedItems[i].m_41764_(this.requiredCount);
                }
                return countedItems;
            }
            return items;
        }
    }
}

