/*
 * Decompiled with CFR 0.152.
 */
package com.shengchanshe.chang_sheng_jue.util;

import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;

public record GuiEntityGraphics(Font font, int headSize, int maxVisibleHeads, Map<EntityType<?>, Entity> entityCache) {
    private static GuiEntityGraphics instance;

    public static GuiEntityGraphics getInstance(Font font, int headSize, int maxVisibleHeads, Map<EntityType<?>, Entity> entityCache) {
        if (instance == null) {
            instance = new GuiEntityGraphics(font, headSize, maxVisibleHeads, entityCache);
        }
        return instance;
    }

    public void renderKillTargetHead(GuiGraphics guiGraphics, int x, int y, String questEntity, int currentKillsCount, int requiredKillsCount) {
        if (questEntity.startsWith("#")) {
            this.renderTaggedEntities(guiGraphics, x, y, questEntity);
        } else {
            this.renderSingleEntity(guiGraphics, x, y, questEntity);
        }
        this.renderScaledKillCount(guiGraphics, x, y, currentKillsCount, requiredKillsCount);
    }

    private void renderScaledKillCount(GuiGraphics guiGraphics, int x, int y, int currentKillsCount, int requiredKillsCount) {
        float maxWidth;
        String killText = currentKillsCount + "/" + requiredKillsCount;
        int textWidth = this.font.m_92895_(killText);
        float scale = (float)textWidth > (maxWidth = (float)this.headSize * 1.0f) ? maxWidth / (float)textWidth : 1.0f;
        int renderX = x + (this.headSize - (int)((float)textWidth * scale)) / 2;
        int renderY = y + this.headSize - (int)(9.0f * scale);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)renderX, (float)renderY, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        String[] parts = killText.split("/");
        this.font.m_271703_(parts[0], 0.0f, 0.0f, currentKillsCount >= requiredKillsCount ? 65280 : 16766720, true, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.font.m_271703_("/" + parts[1], (float)this.font.m_92895_(parts[0]), 0.0f, 0xFFFFFF, true, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        guiGraphics.m_280168_().m_85849_();
    }

    public void renderTaggedEntities(GuiGraphics guiGraphics, int x, int y, String questEntity) {
        TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation(questEntity.substring(1)));
        List taggedEntities = ForgeRegistries.ENTITY_TYPES.tags().getTag(tag).stream().toList();
        if (taggedEntities.isEmpty()) {
            this.renderMissingIcon(guiGraphics, x, y);
            return;
        }
        long gameTime = Minecraft.m_91087_().f_91073_.m_46467_();
        int index = (int)(gameTime / 20L % (long)taggedEntities.size());
        this.renderEntityHead(guiGraphics, x, y, (EntityType)taggedEntities.get(index));
    }

    public void renderSingleEntity(GuiGraphics guiGraphics, int x, int y, String questEntity) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(questEntity));
        if (entityType != null) {
            this.renderEntityHead(guiGraphics, x, y, entityType);
        } else {
            this.renderMissingIcon(guiGraphics, x, y);
        }
    }

    public void renderMissingIcon(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280163_(new ResourceLocation("textures/gui/icon_missing.png"), x, y, 0.0f, 0.0f, this.headSize, this.headSize, this.headSize, this.headSize);
    }

    public void renderEntityHead(GuiGraphics guiGraphics, int x, int y, EntityType<?> entityType) {
        Entity entity = this.entityCache.computeIfAbsent(entityType, type -> {
            Entity e = type.m_20615_((Level)Minecraft.m_91087_().f_91073_);
            return e;
        });
        if (entity == null) {
            this.renderMissingIcon(guiGraphics, x, y);
            return;
        }
        float yOffset = 0.0f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)x + (float)this.headSize / 2.0f, (float)y + (float)this.headSize / 2.0f + yOffset, 100.0f);
        guiGraphics.m_280168_().m_85841_((float)this.headSize, (float)this.headSize, (float)this.headSize);
        Quaternionf quaternion = new Quaternionf().rotateZ((float)Math.PI);
        guiGraphics.m_280168_().m_252781_(quaternion);
        EntityRenderDispatcher renderer = Minecraft.m_91087_().m_91290_();
        quaternion.conjugate();
        renderer.m_252923_(quaternion);
        renderer.m_114468_(false);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        renderer.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, guiGraphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0);
        buffer.m_109911_();
        renderer.m_114468_(false);
        guiGraphics.m_280168_().m_85849_();
    }
}

