/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hyrinity.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.hyrinity.HyrinityMod;
import net.mcreator.hyrinity.procedures.CheatsButtonProcedure;
import net.mcreator.hyrinity.procedures.HyrLunaticSkullRightClickProcedure;
import net.mcreator.hyrinity.procedures.ItemRecoveryMenuButtonProcedure;
import net.mcreator.hyrinity.procedures.LevelingMenuButtonProcedure;
import net.mcreator.hyrinity.procedures.OptionsMenuButtonProcedure;
import net.mcreator.hyrinity.world.inventory.HyrinityMainMenuMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class HyrinityMainMenuButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public HyrinityMainMenuButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public HyrinityMainMenuButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(HyrinityMainMenuButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(HyrinityMainMenuButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HyrinityMainMenuButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = HyrinityMainMenuMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ItemRecoveryMenuButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            CheatsButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OptionsMenuButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            LevelingMenuButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            HyrLunaticSkullRightClickProcedure.execute((LevelAccessor)world);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HyrinityMod.addNetworkMessage(HyrinityMainMenuButtonMessage.class, HyrinityMainMenuButtonMessage::buffer, HyrinityMainMenuButtonMessage::new, HyrinityMainMenuButtonMessage::handler);
    }
}

