/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hyrinity.network;

import java.util.function.Supplier;
import net.mcreator.hyrinity.HyrinityMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class HyrinityModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        HyrinityMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        HyrinityMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.HyrMovementLevel = message.data.HyrMovementLevel;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double HyrMovementLevel = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                HyrinityMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("HyrMovementLevel", this.HyrMovementLevel);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.HyrMovementLevel = nbt.m_128459_("HyrMovementLevel");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("hyrinity", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "hyrinity_mapvars";
        public String HyrDimensionDeath = "surface";
        public double worldtime = 0.0;
        public double MobSpawnCD = 0.0;
        public double HyrBossKillsTier = 0.0;
        public double pZ = 0.0;
        public double pY = 0.0;
        public double pX = 0.0;
        public double PlayerDamageModifier = 1.0;
        public double MobHealthModifier = 1.0;
        public double MobDamageModifier = 1.0;
        public double ManaConsumptionModifier = 1.0;
        public double MagicWeaponDamageModifier = 1.0;
        public double HyrRangedDamageMultiplier = 1.0;
        public double HyrProtectionMultiplier = 1.0;
        public double HyrPlayerCritstrikeMultiplier = 1.0;
        public double HyrMobDefenseMultiplier = 1.0;
        public double MobSpawnerBoxSize = 100.0;
        public double HyrLevelCap = 20.0;
        public double MobSpawnDelay = 200.0;
        public double RequiredXPNextLevel = 5.0;
        public double HyrPlayerFlightTime = 0.0;
        public double PlayerXPLevelRefund = 0.0;
        public double PlayerXPLevel = 0.0;
        public double PlayerNextLevel = 0.0;
        public double MTokenRefund = 0.0;
        public double MiningTokenRefund = 0.0;
        public double ManaCrystalLVL = 0.0;
        public double MagicTokenRefund = 0.0;
        public double HyrRangerTokenRefund = 0.0;
        public double HyrPlayerRangedLevel = 0.0;
        public double HyrPlayerMiningLevel = 0.0;
        public double HyrPlayerMeleeLevel = 0.0;
        public double HyrPlayerMagicLevel = 0.0;
        public double HyrPlayerLastDeath_Z = 0.0;
        public double HyrPlayerLastDeath_Y = 0.0;
        public double HyrPlayerLastDeath_X = 0.0;
        public double HyrPlayerCraftingLevel = 0.0;
        public double HeartCrystalLVL = 0.0;
        public double CTokenRefund = 0.0;
        public double PlayerMovementSpeed = 1.0;
        public double PlayerLevelDamageMultiplier = 1.0;
        public double PlayerLevel = 1.0;
        public double Playerhealth = 50.0;
        public double MaxMana = 50.0;
        public boolean HyrDragonIsDead = false;
        public boolean HyrBossDespawn = false;
        public boolean HyrAirBlockState = false;
        public boolean cerafurrestspreadblock = false;
        public boolean BossIsAlive = false;
        public boolean barriers = false;
        public boolean HyrPlayerBossZen = false;
        public boolean FirstJoin = true;
        public ItemStack HyrPlayerFlightAccessory = ItemStack.f_41583_;
        public Direction HyrPlayerDirection = Direction.NORTH;
        public double HyrPlayerMovementTokenRefund = 0.0;
        public boolean HyrTheEnd = false;
        public boolean HyrPlayerGodmode = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.HyrDimensionDeath = nbt.m_128461_("HyrDimensionDeath");
            this.worldtime = nbt.m_128459_("worldtime");
            this.MobSpawnCD = nbt.m_128459_("MobSpawnCD");
            this.HyrBossKillsTier = nbt.m_128459_("HyrBossKillsTier");
            this.pZ = nbt.m_128459_("pZ");
            this.pY = nbt.m_128459_("pY");
            this.pX = nbt.m_128459_("pX");
            this.PlayerDamageModifier = nbt.m_128459_("PlayerDamageModifier");
            this.MobHealthModifier = nbt.m_128459_("MobHealthModifier");
            this.MobDamageModifier = nbt.m_128459_("MobDamageModifier");
            this.ManaConsumptionModifier = nbt.m_128459_("ManaConsumptionModifier");
            this.MagicWeaponDamageModifier = nbt.m_128459_("MagicWeaponDamageModifier");
            this.HyrRangedDamageMultiplier = nbt.m_128459_("HyrRangedDamageMultiplier");
            this.HyrProtectionMultiplier = nbt.m_128459_("HyrProtectionMultiplier");
            this.HyrPlayerCritstrikeMultiplier = nbt.m_128459_("HyrPlayerCritstrikeMultiplier");
            this.HyrMobDefenseMultiplier = nbt.m_128459_("HyrMobDefenseMultiplier");
            this.MobSpawnerBoxSize = nbt.m_128459_("MobSpawnerBoxSize");
            this.HyrLevelCap = nbt.m_128459_("HyrLevelCap");
            this.MobSpawnDelay = nbt.m_128459_("MobSpawnDelay");
            this.RequiredXPNextLevel = nbt.m_128459_("RequiredXPNextLevel");
            this.HyrPlayerFlightTime = nbt.m_128459_("HyrPlayerFlightTime");
            this.PlayerXPLevelRefund = nbt.m_128459_("PlayerXPLevelRefund");
            this.PlayerXPLevel = nbt.m_128459_("PlayerXPLevel");
            this.PlayerNextLevel = nbt.m_128459_("PlayerNextLevel");
            this.MTokenRefund = nbt.m_128459_("MTokenRefund");
            this.MiningTokenRefund = nbt.m_128459_("MiningTokenRefund");
            this.ManaCrystalLVL = nbt.m_128459_("ManaCrystalLVL");
            this.MagicTokenRefund = nbt.m_128459_("MagicTokenRefund");
            this.HyrRangerTokenRefund = nbt.m_128459_("HyrRangerTokenRefund");
            this.HyrPlayerRangedLevel = nbt.m_128459_("HyrPlayerRangedLevel");
            this.HyrPlayerMiningLevel = nbt.m_128459_("HyrPlayerMiningLevel");
            this.HyrPlayerMeleeLevel = nbt.m_128459_("HyrPlayerMeleeLevel");
            this.HyrPlayerMagicLevel = nbt.m_128459_("HyrPlayerMagicLevel");
            this.HyrPlayerLastDeath_Z = nbt.m_128459_("HyrPlayerLastDeath_Z");
            this.HyrPlayerLastDeath_Y = nbt.m_128459_("HyrPlayerLastDeath_Y");
            this.HyrPlayerLastDeath_X = nbt.m_128459_("HyrPlayerLastDeath_X");
            this.HyrPlayerCraftingLevel = nbt.m_128459_("HyrPlayerCraftingLevel");
            this.HeartCrystalLVL = nbt.m_128459_("HeartCrystalLVL");
            this.CTokenRefund = nbt.m_128459_("CTokenRefund");
            this.PlayerMovementSpeed = nbt.m_128459_("PlayerMovementSpeed");
            this.PlayerLevelDamageMultiplier = nbt.m_128459_("PlayerLevelDamageMultiplier");
            this.PlayerLevel = nbt.m_128459_("PlayerLevel");
            this.Playerhealth = nbt.m_128459_("Playerhealth");
            this.MaxMana = nbt.m_128459_("MaxMana");
            this.HyrDragonIsDead = nbt.m_128471_("HyrDragonIsDead");
            this.HyrBossDespawn = nbt.m_128471_("HyrBossDespawn");
            this.HyrAirBlockState = nbt.m_128471_("HyrAirBlockState");
            this.cerafurrestspreadblock = nbt.m_128471_("cerafurrestspreadblock");
            this.BossIsAlive = nbt.m_128471_("BossIsAlive");
            this.barriers = nbt.m_128471_("barriers");
            this.HyrPlayerBossZen = nbt.m_128471_("HyrPlayerBossZen");
            this.FirstJoin = nbt.m_128471_("FirstJoin");
            this.HyrPlayerFlightAccessory = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("HyrPlayerFlightAccessory"));
            this.HyrPlayerDirection = Direction.m_122376_((int)nbt.m_128451_("HyrPlayerDirection"));
            this.HyrPlayerMovementTokenRefund = nbt.m_128459_("HyrPlayerMovementTokenRefund");
            this.HyrTheEnd = nbt.m_128471_("HyrTheEnd");
            this.HyrPlayerGodmode = nbt.m_128471_("HyrPlayerGodmode");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128359_("HyrDimensionDeath", this.HyrDimensionDeath);
            nbt.m_128347_("worldtime", this.worldtime);
            nbt.m_128347_("MobSpawnCD", this.MobSpawnCD);
            nbt.m_128347_("HyrBossKillsTier", this.HyrBossKillsTier);
            nbt.m_128347_("pZ", this.pZ);
            nbt.m_128347_("pY", this.pY);
            nbt.m_128347_("pX", this.pX);
            nbt.m_128347_("PlayerDamageModifier", this.PlayerDamageModifier);
            nbt.m_128347_("MobHealthModifier", this.MobHealthModifier);
            nbt.m_128347_("MobDamageModifier", this.MobDamageModifier);
            nbt.m_128347_("ManaConsumptionModifier", this.ManaConsumptionModifier);
            nbt.m_128347_("MagicWeaponDamageModifier", this.MagicWeaponDamageModifier);
            nbt.m_128347_("HyrRangedDamageMultiplier", this.HyrRangedDamageMultiplier);
            nbt.m_128347_("HyrProtectionMultiplier", this.HyrProtectionMultiplier);
            nbt.m_128347_("HyrPlayerCritstrikeMultiplier", this.HyrPlayerCritstrikeMultiplier);
            nbt.m_128347_("HyrMobDefenseMultiplier", this.HyrMobDefenseMultiplier);
            nbt.m_128347_("MobSpawnerBoxSize", this.MobSpawnerBoxSize);
            nbt.m_128347_("HyrLevelCap", this.HyrLevelCap);
            nbt.m_128347_("MobSpawnDelay", this.MobSpawnDelay);
            nbt.m_128347_("RequiredXPNextLevel", this.RequiredXPNextLevel);
            nbt.m_128347_("HyrPlayerFlightTime", this.HyrPlayerFlightTime);
            nbt.m_128347_("PlayerXPLevelRefund", this.PlayerXPLevelRefund);
            nbt.m_128347_("PlayerXPLevel", this.PlayerXPLevel);
            nbt.m_128347_("PlayerNextLevel", this.PlayerNextLevel);
            nbt.m_128347_("MTokenRefund", this.MTokenRefund);
            nbt.m_128347_("MiningTokenRefund", this.MiningTokenRefund);
            nbt.m_128347_("ManaCrystalLVL", this.ManaCrystalLVL);
            nbt.m_128347_("MagicTokenRefund", this.MagicTokenRefund);
            nbt.m_128347_("HyrRangerTokenRefund", this.HyrRangerTokenRefund);
            nbt.m_128347_("HyrPlayerRangedLevel", this.HyrPlayerRangedLevel);
            nbt.m_128347_("HyrPlayerMiningLevel", this.HyrPlayerMiningLevel);
            nbt.m_128347_("HyrPlayerMeleeLevel", this.HyrPlayerMeleeLevel);
            nbt.m_128347_("HyrPlayerMagicLevel", this.HyrPlayerMagicLevel);
            nbt.m_128347_("HyrPlayerLastDeath_Z", this.HyrPlayerLastDeath_Z);
            nbt.m_128347_("HyrPlayerLastDeath_Y", this.HyrPlayerLastDeath_Y);
            nbt.m_128347_("HyrPlayerLastDeath_X", this.HyrPlayerLastDeath_X);
            nbt.m_128347_("HyrPlayerCraftingLevel", this.HyrPlayerCraftingLevel);
            nbt.m_128347_("HeartCrystalLVL", this.HeartCrystalLVL);
            nbt.m_128347_("CTokenRefund", this.CTokenRefund);
            nbt.m_128347_("PlayerMovementSpeed", this.PlayerMovementSpeed);
            nbt.m_128347_("PlayerLevelDamageMultiplier", this.PlayerLevelDamageMultiplier);
            nbt.m_128347_("PlayerLevel", this.PlayerLevel);
            nbt.m_128347_("Playerhealth", this.Playerhealth);
            nbt.m_128347_("MaxMana", this.MaxMana);
            nbt.m_128379_("HyrDragonIsDead", this.HyrDragonIsDead);
            nbt.m_128379_("HyrBossDespawn", this.HyrBossDespawn);
            nbt.m_128379_("HyrAirBlockState", this.HyrAirBlockState);
            nbt.m_128379_("cerafurrestspreadblock", this.cerafurrestspreadblock);
            nbt.m_128379_("BossIsAlive", this.BossIsAlive);
            nbt.m_128379_("barriers", this.barriers);
            nbt.m_128379_("HyrPlayerBossZen", this.HyrPlayerBossZen);
            nbt.m_128379_("FirstJoin", this.FirstJoin);
            nbt.m_128365_("HyrPlayerFlightAccessory", (Tag)this.HyrPlayerFlightAccessory.m_41739_(new CompoundTag()));
            nbt.m_128405_("HyrPlayerDirection", this.HyrPlayerDirection.m_122411_());
            nbt.m_128347_("HyrPlayerMovementTokenRefund", this.HyrPlayerMovementTokenRefund);
            nbt.m_128379_("HyrTheEnd", this.HyrTheEnd);
            nbt.m_128379_("HyrPlayerGodmode", this.HyrPlayerGodmode);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                HyrinityMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "hyrinity_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                HyrinityMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.HyrMovementLevel = original.HyrMovementLevel;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    HyrinityMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    HyrinityMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                HyrinityMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

