/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hyrinity.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.hyrinity.HyrinityMod;
import net.mcreator.hyrinity.procedures.HyrLevelUpMovementProcedure;
import net.mcreator.hyrinity.procedures.HyrLevelUpRangerProcedure;
import net.mcreator.hyrinity.procedures.LevelUpCraftingProcedure;
import net.mcreator.hyrinity.procedures.LevelUpMagicProcedure;
import net.mcreator.hyrinity.procedures.LevelUpMeleeProcedure;
import net.mcreator.hyrinity.procedures.LevelUpMiningProcedure;
import net.mcreator.hyrinity.world.inventory.SkillMenuMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SkillMenuButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SkillMenuButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SkillMenuButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SkillMenuButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SkillMenuButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SkillMenuButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SkillMenuMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            LevelUpMeleeProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            LevelUpMagicProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            LevelUpMiningProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            LevelUpCraftingProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            HyrLevelUpRangerProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            HyrLevelUpMovementProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HyrinityMod.addNetworkMessage(SkillMenuButtonMessage.class, SkillMenuButtonMessage::buffer, SkillMenuButtonMessage::new, SkillMenuButtonMessage::handler);
    }
}

