/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hyrinity.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.hyrinity.HyrinityMod;
import net.mcreator.hyrinity.procedures.TTCMinus1000Procedure;
import net.mcreator.hyrinity.procedures.TTCMinus2500Procedure;
import net.mcreator.hyrinity.procedures.TTCMinus5000Procedure;
import net.mcreator.hyrinity.procedures.TTCMinus500Procedure;
import net.mcreator.hyrinity.procedures.TTCPlus1000Procedure;
import net.mcreator.hyrinity.procedures.TTCPlus2500Procedure;
import net.mcreator.hyrinity.procedures.TTCPlus5000Procedure;
import net.mcreator.hyrinity.procedures.TTCPlus500Procedure;
import net.mcreator.hyrinity.world.inventory.TheTimeConsoleMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheTimeConsoleButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public TheTimeConsoleButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public TheTimeConsoleButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(TheTimeConsoleButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(TheTimeConsoleButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            TheTimeConsoleButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = TheTimeConsoleMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            TTCPlus500Procedure.execute((LevelAccessor)world);
        }
        if (buttonID == 1) {
            TTCPlus1000Procedure.execute((LevelAccessor)world);
        }
        if (buttonID == 2) {
            TTCPlus2500Procedure.execute((LevelAccessor)world);
        }
        if (buttonID == 3) {
            TTCPlus5000Procedure.execute((LevelAccessor)world);
        }
        if (buttonID == 4) {
            TTCMinus500Procedure.execute((LevelAccessor)world);
        }
        if (buttonID == 5) {
            TTCMinus1000Procedure.execute((LevelAccessor)world);
        }
        if (buttonID == 6) {
            TTCMinus2500Procedure.execute((LevelAccessor)world);
        }
        if (buttonID == 7) {
            TTCMinus5000Procedure.execute((LevelAccessor)world);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HyrinityMod.addNetworkMessage(TheTimeConsoleButtonMessage.class, TheTimeConsoleButtonMessage::buffer, TheTimeConsoleButtonMessage::new, TheTimeConsoleButtonMessage::handler);
    }
}

