/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft;

import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.capabilities.AirHandlerItemStack;
import me.desht.pneumaticcraft.common.item.IFluidCapProvider;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class CapabilitySetup {
    public static void registerCaps(RegisterCapabilitiesEvent event) {
        List.of(ModEntityTypes.DRONE, ModEntityTypes.COLLECTOR_DRONE, ModEntityTypes.GUARD_DRONE, ModEntityTypes.LOGISTICS_DRONE, ModEntityTypes.HARVESTING_DRONE, ModEntityTypes.AMADRONE).forEach(d -> {
            event.registerEntity(PNCCapabilities.AIR_HANDLER_ENTITY, (EntityType)d.get(), (drone, ctx) -> drone.getAirHandler());
            event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)d.get(), (drone, ctx) -> drone.getDroneItemHandler());
            event.registerEntity(Capabilities.FluidHandler.ENTITY, (EntityType)d.get(), (drone, ctx) -> drone.getFluidTank());
            event.registerEntity(Capabilities.EnergyStorage.ENTITY, (EntityType)d.get(), (drone, ctx) -> drone.getEnergyStorage());
        });
        event.registerEntity(PNCCapabilities.HEAT_EXCHANGER_ENTITY, ModEntityTypes.HEAT_FRAME.get(), (frame, ctx) -> frame.getHeatExchangerLogic());
        ModBlockEntityTypes.streamBlockEntities().forEach(blockEntity -> {
            if (blockEntity instanceof AbstractPneumaticCraftBlockEntity) {
                AbstractPneumaticCraftBlockEntity pncBE = (AbstractPneumaticCraftBlockEntity)blockEntity;
                if (pncBE.hasItemCapability()) {
                    event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, pncBE.getType(), (object, dir) -> {
                        IItemHandler iItemHandler;
                        if (object instanceof AbstractPneumaticCraftBlockEntity) {
                            AbstractPneumaticCraftBlockEntity be = (AbstractPneumaticCraftBlockEntity)object;
                            iItemHandler = be.getItemHandler((Direction)dir);
                        } else {
                            iItemHandler = null;
                        }
                        return iItemHandler;
                    });
                }
                if (pncBE.hasFluidCapability()) {
                    event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, pncBE.getType(), (object, dir) -> {
                        IFluidHandler iFluidHandler;
                        if (object instanceof AbstractPneumaticCraftBlockEntity) {
                            AbstractPneumaticCraftBlockEntity be = (AbstractPneumaticCraftBlockEntity)object;
                            iFluidHandler = be.getFluidHandler((Direction)dir);
                        } else {
                            iFluidHandler = null;
                        }
                        return iFluidHandler;
                    });
                }
                if (pncBE.hasEnergyCapability()) {
                    event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, pncBE.getType(), (object, dir) -> {
                        IEnergyStorage iEnergyStorage;
                        if (object instanceof AbstractPneumaticCraftBlockEntity) {
                            AbstractPneumaticCraftBlockEntity be = (AbstractPneumaticCraftBlockEntity)object;
                            iEnergyStorage = be.getEnergyHandler((Direction)dir);
                        } else {
                            iEnergyStorage = null;
                        }
                        return iEnergyStorage;
                    });
                }
                if (pncBE instanceof IHeatExchangingTE) {
                    event.registerBlockEntity(PNCCapabilities.HEAT_EXCHANGER_BLOCK, pncBE.getType(), (object, dir) -> {
                        IHeatExchangerLogic iHeatExchangerLogic;
                        if (object instanceof IHeatExchangingTE) {
                            IHeatExchangingTE heat = (IHeatExchangingTE)object;
                            iHeatExchangerLogic = heat.getHeatExchanger((Direction)dir);
                        } else {
                            iHeatExchangerLogic = null;
                        }
                        return iHeatExchangerLogic;
                    });
                }
                if (pncBE instanceof AbstractAirHandlingBlockEntity) {
                    event.registerBlockEntity(PNCCapabilities.AIR_HANDLER_MACHINE, pncBE.getType(), (object, dir) -> {
                        IAirHandlerMachine iAirHandlerMachine;
                        if (object instanceof AbstractAirHandlingBlockEntity) {
                            AbstractAirHandlingBlockEntity a = (AbstractAirHandlingBlockEntity)object;
                            iAirHandlerMachine = a.getAirHandler((Direction)dir);
                        } else {
                            iAirHandlerMachine = null;
                        }
                        return iAirHandlerMachine;
                    });
                }
            }
        });
        ModItems.ITEMS.getEntries().forEach(entry -> {
            Object patt0$temp;
            if (entry.get() instanceof IPressurizableItem) {
                event.registerItem(PNCCapabilities.AIR_HANDLER_ITEM, (stack, ctx) -> new AirHandlerItemStack((ItemStack)stack), new ItemLike[]{(ItemLike)entry.get()});
            }
            if ((patt0$temp = entry.get()) instanceof IFluidCapProvider) {
                IFluidCapProvider f = (IFluidCapProvider)patt0$temp;
                event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> f.provideFluidCapability((ItemStack)stack), new ItemLike[]{(ItemLike)entry.get()});
            }
        });
    }
}

