/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.recipe;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class HeatPropertiesRecipe
extends PneumaticCraftRecipe {
    private static final Codec<BlockState> BLOCKSTATE_STRING_CODEC = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)string, (boolean)false).blockState());
        }
        catch (CommandSyntaxException e) {
            return DataResult.error(() -> "invalid blockstate definition: " + string);
        }
    }, BlockStateParser::serialize);

    public abstract Block getBlock();

    public abstract BlockState getBlockState();

    public abstract Optional<Integer> getHeatCapacity();

    public abstract int getTemperature();

    public abstract Optional<Double> getThermalResistance();

    public abstract Transforms getTransforms();

    public abstract Optional<BlockState> getTransformHot();

    public abstract Optional<BlockState> getTransformCold();

    public abstract Optional<BlockState> getTransformHotFlowing();

    public abstract Optional<BlockState> getTransformColdFlowing();

    public abstract IHeatExchangerLogic getLogic();

    public abstract boolean matchState(BlockState var1);

    public abstract Map<String, String> getBlockStatePredicates();

    public abstract String getDescriptionKey();

    public Component getInputDisplayName() {
        Component component;
        Block block = this.getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock liq = (LiquidBlock)block;
            component = new FluidStack((Fluid)liq.fluid, 1000).getHoverName();
        } else {
            component = new ItemStack((ItemLike)this.getBlock()).getHoverName();
        }
        return component;
    }

    public record Transforms(Optional<BlockState> hot, Optional<BlockState> cold, Optional<BlockState> hotFlowing, Optional<BlockState> coldFlowing) {
        public static final Codec<Transforms> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BLOCKSTATE_STRING_CODEC.optionalFieldOf("hot").forGetter(Transforms::hot), (App)BLOCKSTATE_STRING_CODEC.optionalFieldOf("cold").forGetter(Transforms::cold), (App)BLOCKSTATE_STRING_CODEC.optionalFieldOf("hot_flowing").forGetter(Transforms::hotFlowing), (App)BLOCKSTATE_STRING_CODEC.optionalFieldOf("cold_flowing").forGetter(Transforms::coldFlowing)).apply((Applicative)builder, Transforms::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Transforms> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)BlockState.CODEC)), Transforms::hot, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)BlockState.CODEC)), Transforms::cold, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)BlockState.CODEC)), Transforms::hotFlowing, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)BlockState.CODEC)), Transforms::coldFlowing, Transforms::new);
        public static final Transforms NONE = new Transforms(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }
}

