/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.data;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Fluid;

public class PneumaticCraftTags {

    public static class DamageTypes
    extends PneumaticCraftTags {
        public static final TagKey<DamageType> ACID = DamageTypes.modTag("etching_acid");
        public static final TagKey<DamageType> PRESSURE = DamageTypes.modTag("pressure");
        public static final TagKey<DamageType> PLASTIC_BLOCK = DamageTypes.modTag("plastic_block");
        public static final TagKey<DamageType> SECURITY_STATION = DamageTypes.modTag("security_station");
        public static final TagKey<DamageType> MINIGUN = DamageTypes.modTag("minigun");

        static TagKey<DamageType> tag(String modid, String name) {
            return TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
        }

        static TagKey<DamageType> modTag(String name) {
            return DamageTypes.tag("pneumaticcraft", name);
        }
    }

    public static class Structures
    extends PneumaticCraftTags {
        public static final TagKey<Structure> NO_OIL_LAKES = Structures.modTag("no_oil_lakes");

        static TagKey<Structure> tag(String modid, String name) {
            return TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
        }

        static TagKey<Structure> modTag(String name) {
            return Structures.tag("pneumaticcraft", name);
        }
    }

    public static class Biomes
    extends PneumaticCraftTags {
        public static final TagKey<Biome> OIL_LAKES_SURFACE = Biomes.modTag("has_surface_oil_lakes");
        public static final TagKey<Biome> OIL_LAKES_UNDERGROUND = Biomes.modTag("has_underground_oil_lakes");

        static TagKey<Biome> tag(String modid, String name) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
        }

        static TagKey<Biome> modTag(String name) {
            return Biomes.tag("pneumaticcraft", name);
        }
    }

    public static class EntityTypes
    extends PneumaticCraftTags {
        public static final TagKey<EntityType<?>> VACUUM_TRAP_BLACKLISTED = EntityTypes.modTag("vacuum_trap_blacklisted");
        public static final TagKey<EntityType<?>> VACUUM_TRAP_WHITELISTED = EntityTypes.modTag("vacuum_trap_whitelisted");
        public static final TagKey<EntityType<?>> OMNIHOPPER_BLACKLISTED = EntityTypes.modTag("omnihopper_blacklisted");

        static TagKey<EntityType<?>> tag(String modid, String name) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
        }

        static TagKey<EntityType<?>> modTag(String name) {
            return EntityTypes.tag("pneumaticcraft", name);
        }
    }

    public static class Fluids
    extends PneumaticCraftTags {
        public static final TagKey<Fluid> CRUDE_OIL = Fluids.commonTag("fuels/crude_oil");
        public static final TagKey<Fluid> ETHANOL = Fluids.commonTag("fuels/ethanol");
        public static final TagKey<Fluid> DIESEL = Fluids.commonTag("fuels/diesel");
        public static final TagKey<Fluid> KEROSENE = Fluids.commonTag("fuels/kerosene");
        public static final TagKey<Fluid> GASOLINE = Fluids.commonTag("fuels/gasoline");
        public static final TagKey<Fluid> LPG = Fluids.commonTag("fuels/lpg");
        public static final TagKey<Fluid> BIODIESEL = Fluids.commonTag("fuels/biodiesel");
        public static final TagKey<Fluid> LUBRICANT = Fluids.commonTag("lubricant");
        public static final TagKey<Fluid> PLANT_OIL = Fluids.commonTag("plantoil");
        public static final TagKey<Fluid> EXPERIENCE = Fluids.commonTag("experience");
        public static final TagKey<Fluid> ETCHING_ACID = Fluids.modTag("etching_acid");
        public static final TagKey<Fluid> PLASTIC = Fluids.modTag("plastic");
        public static final TagKey<Fluid> YEAST_CULTURE = Fluids.modTag("yeast_culture");
        public static final TagKey<Fluid> SEISMIC = Fluids.modTag("seismic_sensor_interesting");

        static TagKey<Fluid> tag(String modid, String name) {
            return TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
        }

        static TagKey<Fluid> modTag(String name) {
            return Fluids.tag("pneumaticcraft", name);
        }

        public static TagKey<Fluid> commonTag(String name) {
            return Fluids.tag("c", name);
        }
    }

    public static class Items
    extends PneumaticCraftTags {
        public static final TagKey<Item> SLABS = Items.modTag("slabs");
        public static final TagKey<Item> STAIRS = Items.modTag("stairs");
        public static final TagKey<Item> DOORS = Items.modTag("doors");
        public static final TagKey<Item> WALLS = Items.modTag("walls");
        public static final TagKey<Item> PLASTIC_BRICKS = Items.modTag("plastic_bricks");
        public static final TagKey<Item> SMOOTH_PLASTIC_BRICKS = Items.modTag("smooth_plastic_bricks");
        public static final TagKey<Item> WALL_LAMPS = Items.modTag("wall_lamps");
        public static final TagKey<Item> WALL_LAMPS_INVERTED = Items.modTag("wall_lamps_inverted");
        public static final TagKey<Item> FLUID_TANKS = Items.modTag("fluid_tanks");
        public static final TagKey<Item> CHESTS = Items.modTag("chests");
        public static final TagKey<Item> REINFORCED_STONE = Items.modTag("reinforced_stone");
        public static final TagKey<Item> REINFORCED_STONE_BRICKS = Items.modTag("reinforced_stone_bricks");
        public static final TagKey<Item> COMPRESSED_STONE = Items.modTag("compressed_stone");
        public static final TagKey<Item> COMPRESSED_STONE_BRICKS = Items.modTag("compressed_stone_bricks");
        public static final TagKey<Item> REINFORCED_CHEST_DISALLOWED = Items.modTag("reinforced_chest_disallowed");
        public static final TagKey<Item> WIRING = Items.modTag("wiring");
        public static final TagKey<Item> UPGRADE_COMPONENTS = Items.modTag("upgrade_components");
        public static final TagKey<Item> BASIC_DRONES = Items.modTag("basic_drones");
        public static final TagKey<Item> PLASTIC_SHEETS = Items.modTag("plastic_sheets");
        public static final TagKey<Item> FLOUR = Items.commonTag("dusts/flour");
        public static final TagKey<Item> LOGISTIC_FRAMES = Items.modTag("logistics_frames");
        public static final TagKey<Item> UPGRADES = Items.modTag("upgrades");
        public static final TagKey<Item> MINIGUN_AMMO = Items.modTag("minigun_ammo");
        public static final TagKey<Item> INGOTS_COMPRESSED_IRON = Items.commonTag("ingots/compressed_iron");
        public static final TagKey<Item> STORAGE_BLOCKS_COMPRESSED_IRON = Items.commonTag("storage_blocks/compressed_iron");
        public static final TagKey<Item> GEARS = Items.commonTag("gears");
        public static final TagKey<Item> GEARS_COMPRESSED_IRON = Items.commonTag("gears/compressed_iron");
        public static final TagKey<Item> NUGGETS_COPPER = Items.commonTag("nuggets/copper");
        public static final TagKey<Item> CURIO = Items.tag("curios", "curio");
        public static final TagKey<Item> WRENCHES = Items.commonTag("tools/wrench");
        public static final TagKey<Item> COMPRESSED_IRON_ARMOR = Items.modTag("armors/compressed_iron");
        public static final TagKey<Item> PNEUMATIC_ARMOR = Items.modTag("armors/pneumatic");

        static TagKey<Item> tag(String modid, String name) {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
        }

        static TagKey<Item> modTag(String name) {
            return Items.tag("pneumaticcraft", name);
        }

        static TagKey<Item> neoforgeTag(String name) {
            return Items.tag("neoforge", name);
        }

        static TagKey<Item> commonTag(String name) {
            return Items.tag("c", name);
        }
    }

    public static class Blocks
    extends PneumaticCraftTags {
        public static final TagKey<Block> SLABS = Blocks.modTag("slabs");
        public static final TagKey<Block> STAIRS = Blocks.modTag("stairs");
        public static final TagKey<Block> DOORS = Blocks.modTag("doors");
        public static final TagKey<Block> WALLS = Blocks.modTag("walls");
        public static final TagKey<Block> PLASTIC_BRICKS = Blocks.modTag("plastic_bricks");
        public static final TagKey<Block> SMOOTH_PLASTIC_BRICKS = Blocks.modTag("smooth_plastic_bricks");
        public static final TagKey<Block> FLUID_TANKS = Blocks.modTag("fluid_tanks");
        public static final TagKey<Block> CHESTS = Blocks.modTag("chests");
        public static final TagKey<Block> REINFORCED_STONE = Blocks.modTag("reinforced_stone");
        public static final TagKey<Block> REINFORCED_STONE_BRICKS = Blocks.modTag("reinforced_stone_bricks");
        public static final TagKey<Block> COMPRESSED_STONE = Blocks.modTag("compressed_stone");
        public static final TagKey<Block> COMPRESSED_STONE_BRICKS = Blocks.modTag("compressed_stone_bricks");
        public static final TagKey<Block> WALL_LAMPS = Blocks.modTag("wall_lamps");
        public static final TagKey<Block> WALL_LAMPS_INVERTED = Blocks.modTag("wall_lamps_inverted");
        public static final TagKey<Block> BLOCK_TRACKER_MISC = Blocks.modTag("block_tracker_misc_blocks");
        public static final TagKey<Block> PROBE_TARGET = Blocks.modTag("probe_target");
        public static final TagKey<Block> JACKHAMMER_ORES = Blocks.modTag("jackhammer_ores");
        public static final TagKey<Block> ELECTROSTATIC_GRID = Blocks.modTag("electrostatic_grid");
        public static final TagKey<Block> CROP_SUPPORT_GROWABLE = Blocks.modTag("crop_support_growable");
        public static final TagKey<Block> STORAGE_BLOCKS_COMPRESSED_IRON = Blocks.commonTag("storage_blocks/compressed_iron");

        static TagKey<Block> tag(String modid, String name) {
            return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
        }

        static TagKey<Block> modTag(String name) {
            return Blocks.tag("pneumaticcraft", name);
        }

        static TagKey<Block> neoforgeTag(String name) {
            return Blocks.tag("neoforge", name);
        }

        static TagKey<Block> commonTag(String name) {
            return Blocks.tag("c", name);
        }
    }
}

