/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.utility.GasLiftBlockEntity;
import me.desht.pneumaticcraft.common.inventory.GasLiftMenu;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GasLiftScreen
extends AbstractPneumaticCraftContainerScreen<GasLiftMenu, GasLiftBlockEntity> {
    private WidgetAnimatedStat statusStat;
    private final WidgetButtonExtended[] modeButtons = new WidgetButtonExtended[GasLiftBlockEntity.PumpMode.values().length];

    public GasLiftScreen(GasLiftMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new WidgetTank(this.leftPos + 80, this.topPos + 15, ((GasLiftBlockEntity)this.te).getTank()));
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status", new Object[0]), new ItemStack((ItemLike)ModBlocks.GAS_LIFT.get()), -22016, false);
        WidgetAnimatedStat optionStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.gasLift.mode", new Object[0]), new ItemStack((ItemLike)ModBlocks.PRESSURE_TUBE.get()), -13312, false);
        optionStat.setMinimumExpandedDimensions(60, 45);
        WidgetButtonExtended button = new WidgetButtonExtended(5, 20, 20, 20, (Component)Component.empty()).withTag(GasLiftBlockEntity.PumpMode.PUMP_EMPTY.toString());
        button.setRenderStacks(new ItemStack((ItemLike)Items.BUCKET));
        button.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.gasLift.mode.pumpEmpty", new Object[0])));
        optionStat.addSubWidget((AbstractWidget)button);
        this.modeButtons[0] = button;
        button = new WidgetButtonExtended(30, 20, 20, 20, (Component)Component.empty()).withTag(GasLiftBlockEntity.PumpMode.PUMP_LEAVE_FLUID.toString());
        button.setRenderStacks(new ItemStack((ItemLike)Items.WATER_BUCKET));
        button.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.gasLift.mode.pumpLeave", new Object[0])));
        optionStat.addSubWidget((AbstractWidget)button);
        this.modeButtons[1] = button;
        button = new WidgetButtonExtended(55, 20, 20, 20, (Component)Component.empty()).withTag(GasLiftBlockEntity.PumpMode.RETRACT.toString());
        button.setRenderStacks(new ItemStack((ItemLike)ModBlocks.DRILL_PIPE.get()));
        button.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.gasLift.mode.drawIn", new Object[0])));
        optionStat.addSubWidget((AbstractWidget)button);
        this.modeButtons[2] = button;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_GAS_LIFT;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(0, -1);
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.statusStat.setText(this.getStatus());
        for (int i = 0; i < this.modeButtons.length; ++i) {
            this.modeButtons[i].active = ((GasLiftBlockEntity)this.te).pumpMode != GasLiftBlockEntity.PumpMode.values()[i];
        }
    }

    private List<Component> getStatus() {
        ArrayList<Component> textList = new ArrayList<Component>();
        textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.gasLift.action", new Object[0]));
        textList.add((Component)PneumaticCraftUtils.xlate(((GasLiftBlockEntity)this.te).status.getTranslationKey(), ((GasLiftBlockEntity)this.te).getTank().getFluid().getHoverName().getString()).withStyle(ChatFormatting.BLACK));
        textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.gasLift.currentDepth", new Object[0]));
        textList.add((Component)Component.literal((String)(((GasLiftBlockEntity)this.te).currentDepth + " meter(s)")).withStyle(ChatFormatting.BLACK));
        return textList;
    }

    @Override
    public void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((GasLiftBlockEntity)this.te).pumpMode == GasLiftBlockEntity.PumpMode.PUMP_EMPTY || ((GasLiftBlockEntity)this.te).pumpMode == GasLiftBlockEntity.PumpMode.PUMP_LEAVE_FLUID) {
            if (((GasLiftBlockEntity)this.te).getTank().getCapacity() - ((GasLiftBlockEntity)this.te).getTank().getFluidAmount() < 1000) {
                curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.gasLift.noLiquidSpace", new Object[0]));
            }
            if (((GasLiftBlockEntity)this.te).getItemHandler().getStackInSlot(0).isEmpty()) {
                curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.gasLift.noTubes", new Object[0]));
            }
            if (((GasLiftBlockEntity)this.te).status == GasLiftBlockEntity.Status.STUCK) {
                curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.gasLift.stuck", new Object[0]));
            }
        } else if (((GasLiftBlockEntity)this.te).getItemHandler().getStackInSlot(0).getCount() == 64) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.gasLift.noTubeSpace", new Object[0]));
        }
    }
}

