/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.EnumMap;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTooltipArea;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.inventory.JackhammerSetupMenu;
import me.desht.pneumaticcraft.common.item.DrillBitItem;
import me.desht.pneumaticcraft.common.item.JackHammerItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class JackHammerSetupScreen
extends AbstractPneumaticCraftContainerScreen<JackhammerSetupMenu, AbstractPneumaticCraftBlockEntity> {
    private final EnumMap<JackHammerItem.DigMode, WidgetButtonExtended> typeButtons = new EnumMap(JackHammerItem.DigMode.class);
    private WidgetButtonExtended selectorButton;

    public JackHammerSetupScreen(JackhammerSetupMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageHeight = 182;
    }

    @Override
    public void init() {
        super.init();
        ItemStack hammerStack = ClientUtils.getClientPlayer().getItemInHand(((JackhammerSetupMenu)this.menu).getHand());
        JackHammerItem.DigMode digMode = JackHammerItem.getDigMode(hammerStack);
        this.selectorButton = new WidgetButtonExtended(this.leftPos + 127, this.topPos + 67, 20, 20, (Component)Component.empty(), b -> this.toggleShowChoices());
        ((WidgetButtonExtended)this.addRenderableWidget((GuiEventListener)this.selectorButton)).setRenderedIcon(digMode.getGuiIcon());
        int xBase = 147 - 20 * JackHammerItem.DigMode.values().length;
        for (JackHammerItem.DigMode dm : JackHammerItem.DigMode.values()) {
            WidgetButtonExtended button = new WidgetButtonExtended(this.leftPos + xBase, this.topPos + 47, 20, 20, (Component)Component.empty(), b -> this.selectDigMode(dm)).setRenderedIcon(dm.getGuiIcon()).withTag("digmode:" + String.valueOf(dm));
            xBase += 20;
            button.visible = false;
            this.typeButtons.put(dm, button);
            this.addRenderableWidget((GuiEventListener)button);
        }
        this.addRenderableWidget((GuiEventListener)new WidgetTooltipArea(this.leftPos + 96, this.topPos + 19, 18, 18, () -> !((Slot)((JackhammerSetupMenu)this.menu).slots.get(1)).hasItem() ? Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.jackhammer.enchantedBookTip", new Object[0])) : null));
    }

    private void selectDigMode(JackHammerItem.DigMode digMode) {
        this.typeButtons.values().forEach(button -> {
            button.visible = false;
        });
        this.selectorButton.setRenderedIcon(digMode.getGuiIcon());
    }

    private void toggleShowChoices() {
        this.typeButtons.values().forEach(button -> {
            button.visible = !button.visible;
        });
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.updateDigModeButtons();
    }

    private void updateDigModeButtons() {
        ItemStack drillStack = ((JackhammerSetupMenu)this.menu).getSlot(0).getItem();
        DrillBitItem.DrillBitType bitType = drillStack.getItem() instanceof DrillBitItem ? ((DrillBitItem)drillStack.getItem()).getType() : DrillBitItem.DrillBitType.NONE;
        ItemStack hammerStack = ClientUtils.getClientPlayer().getItemInHand(((JackhammerSetupMenu)this.menu).getHand());
        JackHammerItem.DigMode digMode = JackHammerItem.getDigMode(hammerStack);
        this.typeButtons.forEach((dm, button) -> {
            button.active = bitType.getBitQuality() >= dm.getBitType().getBitQuality();
        });
        if (digMode.getBitType().getBitQuality() > bitType.getBitQuality() && digMode != JackHammerItem.DigMode.MODE_1X1) {
            digMode = JackHammerItem.DigMode.MODE_1X1;
            NetworkHandler.sendToServer(new PacketGuiButton("digmode:" + String.valueOf(digMode)));
        }
        this.selectorButton.setRenderedIcon(digMode.getGuiIcon());
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (!((Slot)((JackhammerSetupMenu)this.menu).slots.get(0)).hasItem()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.jackhammer.noBit", new Object[0]));
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_JACKHAMMER_SETUP;
    }
}

