/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.block.entity.utility.SentryTurretBlockEntity;
import me.desht.pneumaticcraft.common.inventory.SentryTurretMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class SentryTurretScreen
extends AbstractPneumaticCraftContainerScreen<SentryTurretMenu, SentryTurretBlockEntity> {
    private WidgetTextField entityFilter;
    private WidgetButtonExtended errorButton;

    public SentryTurretScreen(SentryTurretMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_SENTRY_TURRET;
    }

    @Override
    public void init() {
        super.init();
        this.entityFilter = new WidgetTextField(this.font, this.leftPos + 80, this.topPos + 62, 70);
        this.addRenderableWidget((GuiEventListener)this.entityFilter);
        this.entityFilter.setMaxLength(256);
        this.errorButton = new WidgetButtonExtended(this.leftPos + 155, this.topPos + 52, 16, 16, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.errorButton);
        this.errorButton.setRenderedIcon(Textures.GUI_PROBLEMS_TEXTURE).setVisible(false);
        this.errorButton.visible = false;
    }

    @Override
    public void containerTick() {
        if (this.firstUpdate) {
            this.entityFilter.setValue(((SentryTurretBlockEntity)this.te).getText(0));
            this.entityFilter.setResponder(this::onEntityFilterChanged);
        }
        super.containerTick();
    }

    private void onEntityFilterChanged(String newText) {
        try {
            new EntityFilter(newText);
            this.errorButton.visible = false;
            this.errorButton.setTooltipText(Collections.emptyList());
            this.sendDelayed(5);
        }
        catch (IllegalArgumentException e) {
            this.errorButton.visible = true;
            this.errorButton.setTooltipText((Component)Component.literal((String)e.getMessage()));
        }
    }

    @Override
    protected void doDelayedAction() {
        ((SentryTurretBlockEntity)this.te).setText(0, this.entityFilter.getValue());
        NetworkHandler.sendToServer(PacketUpdateTextfield.create((IGUITextFieldSensitive)((Object)this.te), 0));
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        super.renderLabels(graphics, x, y);
        graphics.drawString(this.font, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.sentryTurret.ammo", new Object[0]), 80, 19, 0x404040, false);
        graphics.drawString(this.font, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.sentryTurret.targetFilter", new Object[0]), 80, 53, 0x404040, false);
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen(graphics, (Screen)this, this.font, GuiUtils.xlateAndSplit("pneumaticcraft.gui.entityFilter.helpText", new Object[0]));
        } else if (x >= this.leftPos + 76 && y >= this.topPos + 51 && x <= this.leftPos + 153 && y <= this.topPos + 74) {
            MutableComponent str = PneumaticCraftUtils.xlate("pneumaticcraft.gui.entityFilter.holdF1", new Object[0]);
            graphics.drawString(this.font, (Component)str, (this.imageWidth - this.font.width((FormattedText)str)) / 2, this.imageHeight + 5, 0x808080, false);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return this.entityFilter.keyPressed(keyCode, scanCode, modifiers) || this.entityFilter.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (!this.entityFilter.isHovered()) {
            this.setFocused(null);
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        boolean hasAmmo = false;
        for (int i = 0; i < ((SentryTurretBlockEntity)this.te).getItemHandler().getSlots(); ++i) {
            if (((SentryTurretBlockEntity)this.te).getItemHandler().getStackInSlot(i).isEmpty()) continue;
            hasAmmo = true;
            break;
        }
        if (!hasAmmo) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.sentryTurret.noAmmo", new Object[0]));
        }
    }
}

