/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.RangeManager;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.block.entity.utility.SmartChestBlockEntity;
import me.desht.pneumaticcraft.common.inventory.SmartChestMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncSmartChest;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class SmartChestScreen
extends AbstractPneumaticCraftContainerScreen<SmartChestMenu, SmartChestBlockEntity> {
    private List<SmartChestBlockEntity.FilterSlot> filter;
    private IGuiAnimatedStat statusStat;
    private WidgetButtonExtended showRangeButton;

    public SmartChestScreen(SmartChestMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageWidth = 234;
        this.imageHeight = 216;
        this.filter = ((SmartChestBlockEntity)this.te).getFilter();
    }

    @Override
    public void init() {
        super.init();
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.smart_chest.slots.title", new Object[0]), Textures.GUI_MOUSE_LOCATION, -16740144, true).setText(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.smart_chest.slots", new Object[0]));
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status", new Object[0]), new ItemStack((ItemLike)ModBlocks.SMART_CHEST.get()), -22016, false);
        this.addPushPullTab();
        this.showRangeButton = new WidgetButtonExtended(this.leftPos + 196, this.topPos + 189, 12, 12, "A", b -> this.previewRange()).withCustomTooltip(this::makeRangeButtonTooltip);
        this.addRenderableWidget((GuiEventListener)this.showRangeButton);
    }

    private void previewRange() {
        if (AreaRenderManager.getInstance().isShowing(this.te)) {
            AreaRenderManager.getInstance().removeHandlers(this.te);
        } else if (((SmartChestBlockEntity)this.te).getUpgrades(ModUpgrades.MAGNET.get()) > 0) {
            int range = ((SmartChestBlockEntity)this.te).getUpgrades(ModUpgrades.RANGE.get()) + 1;
            HashSet<BlockPos> posSet = new HashSet<BlockPos>();
            for (SideConfigurator.RelativeFace face : SideConfigurator.RelativeFace.values()) {
                if (((SmartChestBlockEntity)this.te).getPushPullMode(face) != SmartChestBlockEntity.PushPullMode.PULL) continue;
                Direction dir = ((SmartChestBlockEntity)this.te).getAbsoluteFacing(face, ((SmartChestBlockEntity)this.te).getRotation());
                BlockPos pos = ((SmartChestBlockEntity)this.te).getBlockPos().relative(dir, range + 1);
                posSet.addAll(RangeManager.getFrame(pos, range));
            }
            AreaRenderManager.getInstance().showArea(posSet, 0x4000FFFF, this.te, false);
        }
    }

    @Override
    public void containerTick() {
        super.containerTick();
        ArrayList<Component> text = new ArrayList<Component>();
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.smartChestStatus.header", new Object[0]));
        text.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.smartChestStatus.itemsPerOperation", ((SmartChestBlockEntity)this.te).getMaxItems()));
        text.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.smartChestStatus.tickInterval", ((SmartChestBlockEntity)this.te).getTickRate()));
        this.statusStat.setText(text);
        if (((SmartChestBlockEntity)this.te).getUpgrades(ModUpgrades.MAGNET.get()) > 0) {
            this.showRangeButton.setVisible(true);
            this.showRangeButton.setMessage((Component)Component.literal((String)"R").withStyle(AreaRenderManager.getInstance().isShowing(this.te) ? ChatFormatting.AQUA : ChatFormatting.GRAY));
        } else {
            this.showRangeButton.setVisible(false);
        }
    }

    private List<Component> makeRangeButtonTooltip() {
        return AreaRenderManager.getInstance().isShowing(this.te) ? List.of(PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.stopShowingArea", new Object[0])) : List.of(PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showArea", new Object[0]));
    }

    private void addPushPullTab() {
        WidgetAnimatedStat stat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.smart_chest.push_pull.title", new Object[0]), new ItemStack((ItemLike)ModBlocks.OMNIDIRECTIONAL_HOPPER.get()), -7290656, false);
        stat.setMinimumExpandedDimensions(80, 80);
        int yTop = 15;
        int xLeft = 25;
        stat.addSubWidget((AbstractWidget)this.makePushPullButton(SideConfigurator.RelativeFace.TOP, xLeft + 22, yTop));
        stat.addSubWidget((AbstractWidget)this.makePushPullButton(SideConfigurator.RelativeFace.LEFT, xLeft, yTop + 22));
        stat.addSubWidget((AbstractWidget)this.makePushPullButton(SideConfigurator.RelativeFace.FRONT, xLeft + 22, yTop + 22));
        stat.addSubWidget((AbstractWidget)this.makePushPullButton(SideConfigurator.RelativeFace.RIGHT, xLeft + 44, yTop + 22));
        stat.addSubWidget((AbstractWidget)this.makePushPullButton(SideConfigurator.RelativeFace.BOTTOM, xLeft + 22, yTop + 44));
        stat.addSubWidget((AbstractWidget)this.makePushPullButton(SideConfigurator.RelativeFace.BACK, xLeft + 44, yTop + 44));
    }

    private WidgetButtonExtended makePushPullButton(SideConfigurator.RelativeFace face, int x, int y) {
        WidgetButtonExtended button = new WidgetButtonExtended(x, y, 20, 20, (Component)Component.empty(), b -> {
            ((SmartChestBlockEntity)this.te).cycleMode(face, Screen.hasShiftDown());
            this.setupPushPullButton((WidgetButtonExtended)b, face);
        }).withTag("push_pull:" + face.toString());
        this.setupPushPullButton(button, face);
        return button;
    }

    private void setupPushPullButton(WidgetButtonExtended button, SideConfigurator.RelativeFace face) {
        SmartChestBlockEntity.PushPullMode mode = ((SmartChestBlockEntity)this.te).getPushPullMode(face);
        switch (mode) {
            case NONE: {
                button.setRenderedIcon(Textures.GUI_X_BUTTON);
                break;
            }
            case PUSH: {
                button.setRenderStacks(new ItemStack((ItemLike)Blocks.PISTON));
                break;
            }
            case PULL: {
                button.setRenderStacks(new ItemStack((ItemLike)Blocks.STICKY_PISTON));
            }
        }
        button.setTooltipText((List<Component>)ImmutableList.of((Object)Component.literal((String)face.toString()).withStyle(ChatFormatting.YELLOW), (Object)PneumaticCraftUtils.xlate(mode.getTranslationKey(), new Object[0])));
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_SMART_CHEST;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float partialTick) {
        super.render(graphics, x, y, partialTick);
        if (((SmartChestMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.getItem().isEmpty() && this.hoveredSlot.index < 72 && !((SmartChestBlockEntity)this.te).getFilter(this.hoveredSlot.index).isEmpty()) {
            ItemStack stack = ((SmartChestBlockEntity)this.te).getFilter(this.hoveredSlot.index);
            List<FormattedCharSequence> l = GuiUtils.wrapTextComponentList(GuiUtils.xlateAndSplit("pneumaticcraft.gui.smart_chest.filter", stack.getHoverName().getString(), stack.getCount()), this.imageWidth, this.font);
            graphics.renderTooltip(this.font, l, x, y);
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.renderBg(graphics, partialTicks, x, y);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (SmartChestBlockEntity.FilterSlot p : this.filter) {
            int slot = p.slot();
            if (slot >= ((SmartChestBlockEntity)this.te).getLastSlot() || !((Slot)((SmartChestMenu)this.menu).slots.get(slot)).hasItem()) continue;
            int sx = this.leftPos + 8 + slot % 12 * 18;
            int sy = this.topPos + 18 + slot / 12 * 18;
            graphics.fill(sx, sy, sx + 16, sy + 16, -2139041664);
        }
        for (int slot = ((SmartChestBlockEntity)this.te).getLastSlot(); slot < 72; ++slot) {
            int sx = this.leftPos + 8 + slot % 12 * 18;
            int sy = this.topPos + 18 + slot / 12 * 18;
            graphics.fill(sx, sy, sx + 16, sy + 16, 1090478176);
        }
        RenderSystem.disableBlend();
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        super.renderLabels(graphics, x, y);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (SmartChestBlockEntity.FilterSlot p : this.filter) {
            int slot = p.slot();
            if (slot >= ((SmartChestBlockEntity)this.te).getLastSlot()) continue;
            int sx = 8 + slot % 12 * 18;
            int sy = 18 + slot / 12 * 18;
            graphics.pose().pushPose();
            ItemStack stack = p.stack();
            graphics.renderItem(stack, sx, sy);
            String label = "[" + stack.getCount() + "]";
            graphics.pose().translate(0.0f, 0.0f, 300.0f);
            if (!((Slot)((SmartChestMenu)this.menu).slots.get(slot)).hasItem()) {
                graphics.fill(sx, sy, sx + 16, sy + 16, 1619054720);
            }
            graphics.pose().scale(0.5f, 0.5f, 0.5f);
            graphics.drawString(this.font, label, 2.0f * ((float)(sx + 16) - (float)this.font.width(label) / 2.0f), (float)(2 * (sy + 1)), -96, false);
            graphics.pose().scale(2.0f, 2.0f, 2.0f);
            graphics.pose().popPose();
        }
        RenderSystem.disableBlend();
    }

    protected void slotClicked(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotIn != null && slotId < 72 && mouseButton == 0 && Screen.hasAltDown()) {
            ItemStack stack = slotIn.getItem();
            if (stack.isEmpty() && slotId > 0 && ((SmartChestBlockEntity)this.te).getFilter(slotId).isEmpty()) {
                if (((SmartChestMenu)this.menu).getCarried().isEmpty()) {
                    if (slotId == ((SmartChestBlockEntity)this.te).getLastSlot()) {
                        ((SmartChestBlockEntity)this.te).setLastSlot(72);
                    } else {
                        for (int i = slotId; i < 72; ++i) {
                            if (((Slot)((SmartChestMenu)this.menu).slots.get(i)).getItem().isEmpty()) continue;
                            return;
                        }
                        ((SmartChestBlockEntity)this.te).setLastSlot(slotId);
                    }
                } else {
                    ItemStack inHand = ((SmartChestMenu)this.menu).getCarried().copy();
                    if (SmartChestScreen.hasShiftDown()) {
                        inHand.setCount(inHand.getMaxStackSize());
                    }
                    ((SmartChestBlockEntity)this.te).setFilter(slotId, inHand);
                    if (((SmartChestBlockEntity)this.te).getLastSlot() <= slotId) {
                        ((SmartChestBlockEntity)this.te).setLastSlot(slotId + 1);
                    }
                    this.filter = ((SmartChestBlockEntity)this.te).getFilter();
                }
                NetworkHandler.sendToServer(PacketSyncSmartChest.forBlockEntity((SmartChestBlockEntity)this.te));
            } else {
                if (((SmartChestBlockEntity)this.te).getFilter(slotId).isEmpty()) {
                    ((SmartChestBlockEntity)this.te).setFilter(slotId, SmartChestScreen.hasShiftDown() ? stack.copyWithCount(stack.getMaxStackSize()) : stack);
                } else {
                    ((SmartChestBlockEntity)this.te).setFilter(slotId, ItemStack.EMPTY);
                }
                this.filter = ((SmartChestBlockEntity)this.te).getFilter();
                NetworkHandler.sendToServer(PacketSyncSmartChest.forBlockEntity((SmartChestBlockEntity)this.te));
            }
        } else {
            super.slotClicked(slotIn, slotId, mouseButton, type);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dirX, double dirY) {
        Slot s = this.getSlotUnderMouse();
        if (Screen.hasAltDown() && s != null && s.index < 72) {
            ItemStack stack = ((SmartChestBlockEntity)this.te).getFilter(s.index);
            if (!stack.isEmpty()) {
                int newSize = SmartChestScreen.hasShiftDown() ? (dirY > 0.0 ? stack.getCount() * 2 : stack.getCount() / 2) : stack.getCount() + (int)dirY;
                newSize = Mth.clamp((int)newSize, (int)1, (int)stack.getMaxStackSize());
                if (newSize != stack.getCount()) {
                    ((SmartChestBlockEntity)this.te).setFilter(s.index, stack.copyWithCount(newSize));
                    this.filter = ((SmartChestBlockEntity)this.te).getFilter();
                    this.sendDelayed(5);
                }
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, dirX, dirY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        ItemStack stack;
        Slot s = this.getSlotUnderMouse();
        if (Screen.hasAltDown() && s != null && s.index < 72 && !(stack = ((SmartChestBlockEntity)this.te).getFilter(s.index)).isEmpty()) {
            int newCount = switch (keyCode) {
                case 265 -> {
                    if (Screen.hasShiftDown()) {
                        yield stack.getCount() * 2;
                    }
                    yield stack.getCount() + 1;
                }
                case 264 -> {
                    if (Screen.hasShiftDown()) {
                        yield stack.getCount() / 2;
                    }
                    yield stack.getCount() - 1;
                }
                default -> stack.getCount();
            };
            newCount = Mth.clamp((int)newCount, (int)1, (int)stack.getMaxStackSize());
            if (newCount != stack.getCount()) {
                ((SmartChestBlockEntity)this.te).setFilter(s.index, stack.copyWithCount(newCount));
                this.filter = ((SmartChestBlockEntity)this.te).getFilter();
                this.sendDelayed(5);
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected void doDelayedAction() {
        NetworkHandler.sendToServer(PacketSyncSmartChest.forBlockEntity((SmartChestBlockEntity)this.te));
    }
}

