/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.api.misc.RangedInt;
import me.desht.pneumaticcraft.api.universal_sensor.ISensorSetting;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRangeToggleButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.block.entity.IRangedTE;
import me.desht.pneumaticcraft.common.block.entity.utility.UniversalSensorBlockEntity;
import me.desht.pneumaticcraft.common.inventory.UniversalSensorMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class UniversalSensorScreen
extends AbstractPneumaticCraftContainerScreen<UniversalSensorMenu, UniversalSensorBlockEntity> {
    private static final int MAX_TEXTFIELD_LENGTH = 256;
    private WidgetAnimatedStat sensorInfoStat;
    private WidgetTextField textField;
    private WidgetComboBox comboBox;
    private int page;
    private int maxPage;
    private static final int MAX_SENSORS_PER_PAGE = 4;
    private int ticksExisted;
    private final List<AbstractWidget> sensorButtons = new ArrayList<AbstractWidget>();

    public UniversalSensorScreen(UniversalSensorMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageHeight = 239;
    }

    public static void refreshIfOpen() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof UniversalSensorScreen) {
            UniversalSensorScreen us = (UniversalSensorScreen)screen;
            us.updateButtons();
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_UNIVERSAL_SENSOR;
    }

    @Override
    public void init() {
        super.init();
        int xStart = (this.width - this.imageWidth) / 2;
        int yStart = (this.height - this.imageHeight) / 2;
        this.sensorInfoStat = this.addAnimatedStat((Component)Component.literal((String)"Sensor Info"), new ItemStack((ItemLike)ModBlocks.UNIVERSAL_SENSOR.get()), -22016, false);
        this.sensorInfoStat.setForegroundColor(-16777216);
        this.textField = new WidgetTextField(this.font, xStart + 70, yStart + 58, 98);
        this.textField.setMaxLength(256);
        this.textField.setValue(((UniversalSensorBlockEntity)this.te).getText(0));
        this.addRenderableWidget((GuiEventListener)this.textField);
        this.comboBox = new WidgetComboBox(this.font, xStart + 70, yStart + 58, 98);
        this.comboBox.setMaxLength(256);
        this.comboBox.setValue(((UniversalSensorBlockEntity)this.te).getText(0));
        this.addRenderableWidget((GuiEventListener)this.comboBox);
        this.comboBox.setVisible(false);
        this.updateButtons();
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        String[] folders;
        super.renderLabels(graphics, x, y);
        if (this.maxPage > 1) {
            graphics.drawString(this.font, this.page + "/" + this.maxPage, 110, 134, 0x404040, false);
        }
        if ((folders = ((UniversalSensorBlockEntity)this.te).getSensorSetting().split("/")).length == 1 && !folders[0].isEmpty()) {
            Set<PNCUpgrade> requiredUpgrades = SensorHandler.getInstance().getRequiredStacksFromText(folders[0]);
            int curX = 92;
            for (PNCUpgrade upgrade : requiredUpgrades) {
                graphics.renderItem(upgrade.getItemStack(), curX, 20);
                curX += 18;
            }
        } else {
            int xSpace = this.imageWidth - 92;
            int size = this.font.width(folders[folders.length - 1]);
            graphics.pose().pushPose();
            graphics.pose().translate(88.0f, 24.0f, 0.0f);
            if (size > xSpace) {
                graphics.pose().scale((float)xSpace / (float)size, 1.0f, 1.0f);
            }
            graphics.drawString(this.font, folders[folders.length - 1], 0, 0, 0x4040A0, false);
            graphics.pose().popPose();
        }
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((UniversalSensorBlockEntity)this.te).getSensorSetting());
        if (sensor != null) {
            ArrayList<Component> info = new ArrayList<Component>();
            sensor.getAdditionalInfo(info);
            int yOff = 0;
            for (Component line : info) {
                graphics.drawString(this.font, line.getVisualOrderText(), 70, 48 + yOff, 0x404040, false);
                Objects.requireNonNull(this.font);
                yOff += 9;
            }
            this.textField.setY(this.topPos + 48 + yOff + 2);
        }
        if (sensor != null && !sensor.getHelpText().isEmpty()) {
            if (ClientUtils.isKeyDown(290)) {
                GuiUtils.showPopupHelpScreen(graphics, (Screen)this, this.font, GuiUtils.xlateAndSplit("pneumaticcraft.gui.entityFilter.helpText", new Object[0]));
            } else if (!sensor.getHelpPromptText().isEmpty()) {
                MutableComponent str = Component.translatable((String)sensor.getHelpPromptText());
                graphics.drawString(this.font, (Component)str, (this.imageWidth - this.font.width((FormattedText)str)) / 2, this.imageHeight + 5, 0xFFFF00, false);
            }
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            ClientUtils.getClientPlayer().closeContainer();
        }
        return this.textField.keyPressed(keyCode, scanCode, modifiers) || this.textField.canConsumeInput() || this.comboBox.keyPressed(keyCode, scanCode, modifiers) || this.comboBox.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected PointXY getInvTextOffset() {
        return new PointXY(0, 2);
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.width - this.imageWidth) / 2;
        int yStart = (this.height - this.imageHeight) / 2;
        return new PointXY(xStart + 34, yStart + this.imageHeight / 4 - 18);
    }

    private void updateButtons() {
        this.sensorButtons.forEach(this::removeWidget);
        this.sensorButtons.clear();
        String[] directories = SensorHandler.getInstance().getDirectoriesAtLocation(((UniversalSensorBlockEntity)this.te).getSensorSetting());
        if (!((UniversalSensorBlockEntity)this.te).getSensorSetting().isEmpty()) {
            this.addButtonLocal((AbstractWidget)new WidgetButtonExtended(this.leftPos + 70, this.topPos + 20, 16, 16, "\u27f5").withTag("back"));
        }
        if (directories.length == 0 || ((UniversalSensorBlockEntity)this.te).getSensorSetting().isEmpty()) {
            this.addButtonLocal((AbstractWidget)new WidgetRangeToggleButton(this.leftPos + 150, this.topPos + 130, (IRangedTE)((Object)this.te)));
        }
        this.maxPage = (directories.length - 1) / 4 + 1;
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
        if (this.page < 1) {
            this.page = 1;
        }
        if (this.maxPage > 1) {
            this.addButtonLocal((AbstractWidget)new WidgetButtonExtended(this.leftPos + 70, this.topPos + 40 + 88, 30, 20, "\u25c0", b -> {
                --this.page;
                if (this.page <= 0) {
                    this.page = this.maxPage;
                }
                this.updateButtons();
            }));
            this.addButtonLocal((AbstractWidget)new WidgetButtonExtended(this.leftPos + 138, this.topPos + 40 + 88, 30, 20, "\u25b6", b -> {
                ++this.page;
                if (this.page > this.maxPage) {
                    this.page = 1;
                }
                this.updateButtons();
            }));
        }
        int buttonsOnPage = 4;
        if (this.page == this.maxPage && (directories.length % 4 > 0 || directories.length == 0)) {
            buttonsOnPage = directories.length % 4;
        }
        for (int i = 0; i < buttonsOnPage; ++i) {
            Object buttonText = directories[i + (this.page - 1) * 4];
            if (SensorHandler.getInstance().getSensorFromPath(((UniversalSensorBlockEntity)this.te).getSensorSetting() + "/" + (String)buttonText) != null) {
                buttonText = String.valueOf(ChatFormatting.YELLOW) + (String)buttonText;
            }
            int buttonID = i * 10 + 10 + (this.page - 1) * 4 * 10;
            int buttonX = this.leftPos + 70;
            int buttonY = this.topPos + 40 + i * 22;
            int buttonWidth = 98;
            int buttonHeight = 20;
            if (((UniversalSensorBlockEntity)this.te).getSensorSetting().isEmpty()) {
                Set<PNCUpgrade> requiredUpgrades = SensorHandler.getInstance().getRequiredStacksFromText((String)buttonText);
                WidgetButtonExtended button = new WidgetButtonExtended(buttonX, buttonY, buttonWidth, buttonHeight, "").withTag("set:" + buttonID);
                button.setRenderStacks((ItemStack[])requiredUpgrades.stream().map(PNCUpgrade::getItemStack).toArray(ItemStack[]::new));
                button.active = (((UniversalSensorBlockEntity)this.te).sensorStatus == UniversalSensorBlockEntity.SensorStatus.OK || ((UniversalSensorBlockEntity)this.te).sensorStatus == UniversalSensorBlockEntity.SensorStatus.NO_SENSOR) && ((UniversalSensorBlockEntity)this.te).areGivenUpgradesInserted(requiredUpgrades);
                this.addButtonLocal((AbstractWidget)button);
                continue;
            }
            this.addButtonLocal((AbstractWidget)new WidgetButtonExtended(buttonX, buttonY, buttonWidth, buttonHeight, (String)buttonText).withTag("set:" + buttonID));
        }
        this.sensorInfoStat.setText(this.getSensorInfo());
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((UniversalSensorBlockEntity)this.te).getSensorSetting());
        boolean textboxEnabled = sensor != null && sensor.needsTextBox();
        List<String> textOptions = sensor == null ? null : sensor.getTextBoxOptions(ClientUtils.getClientPlayer());
        this.textField.setVisible(textboxEnabled && textOptions == null);
        this.comboBox.setVisible(textboxEnabled && textOptions != null);
        if (textboxEnabled) {
            if (textOptions == null) {
                RangedInt range = sensor.getTextboxIntRange();
                if (range != null) {
                    this.textField.setFilter(s -> this.validateTextValue((String)s, range));
                    String max = Integer.toString(range.max());
                    this.textField.setMaxLength(max.length() + 1);
                    this.textField.setWidth(this.font.width(max) + 10);
                } else {
                    this.textField.setFilter(Objects::nonNull);
                    this.textField.setMaxLength(256);
                    this.textField.setWidth(98);
                }
                this.setFocused((GuiEventListener)this.textField);
            } else {
                this.comboBox.setElements(textOptions);
                this.comboBox.setShouldSort(true);
                this.comboBox.setFixedOptions(sensor.strictComboBox());
                this.setFocused((GuiEventListener)this.comboBox);
            }
        }
    }

    private boolean validateTextValue(String s, RangedInt r) {
        if (PneumaticCraftUtils.isInteger(s)) {
            int n = s.isEmpty() || s.equals("-") ? 0 : Integer.parseInt(s);
            return r.test(n);
        }
        return false;
    }

    private void addButtonLocal(AbstractWidget w) {
        this.addRenderableWidget((GuiEventListener)w);
        this.sensorButtons.add(w);
    }

    @Override
    protected void doDelayedAction() {
        if (this.textField.isVisible()) {
            ((UniversalSensorBlockEntity)this.te).setText(0, this.textField.getValue());
        } else if (this.comboBox.isVisible()) {
            ((UniversalSensorBlockEntity)this.te).setText(0, this.comboBox.getValue());
        }
        NetworkHandler.sendToServer(PacketUpdateTextfield.create((IGUITextFieldSensitive)((Object)this.te), 0));
    }

    @Override
    public void containerTick() {
        if (this.firstUpdate) {
            if (this.textField.isVisible()) {
                this.textField.setValue(((UniversalSensorBlockEntity)this.te).getText(0));
                this.textField.setResponder(s -> this.sendDelayed(5));
            } else if (this.comboBox.isVisible()) {
                this.comboBox.setValue(((UniversalSensorBlockEntity)this.te).getText(0));
                this.comboBox.setResponder(s -> this.sendDelayed(5));
            }
        }
        super.containerTick();
        if (((UniversalSensorBlockEntity)this.te).getSensorSetting().isEmpty() && this.ticksExisted++ > 5) {
            this.ticksExisted = 0;
            this.updateButtons();
        }
    }

    private List<Component> getSensorInfo() {
        ArrayList<Component> text = new ArrayList<Component>();
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(((UniversalSensorBlockEntity)this.te).getSensorSetting());
        if (sensor != null) {
            String[] folders = ((UniversalSensorBlockEntity)this.te).getSensorSetting().split("/");
            text.add((Component)Component.literal((String)folders[folders.length - 1]).withStyle(ChatFormatting.WHITE));
            text.addAll(GuiUtils.xlateAndSplit(sensor.getDescription().get(0), new Object[0]));
        } else {
            text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.none", new Object[0]).withStyle(ChatFormatting.BLACK));
        }
        return text;
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((UniversalSensorBlockEntity)this.te).isSensorActive) {
            pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.airUsage", 1).withStyle(ChatFormatting.BLACK));
        }
    }

    @Override
    protected void addWarnings(List<Component> curInfo) {
        super.addWarnings(curInfo);
        if (!((UniversalSensorBlockEntity)this.te).getItemHandler().getStackInSlot(0).isEmpty() && ((UniversalSensorBlockEntity)this.te).outOfRange > 0) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.universalSensor.outOfRange", ((UniversalSensorBlockEntity)this.te).outOfRange));
        }
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (!((UniversalSensorBlockEntity)this.te).lastSensorExceptionText.isEmpty()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.universalSensor.sensorException", ((UniversalSensorBlockEntity)this.te).lastSensorExceptionText));
        }
        if (((UniversalSensorBlockEntity)this.te).sensorStatus != UniversalSensorBlockEntity.SensorStatus.OK) {
            curInfo.addAll(GuiUtils.xlateAndSplit(((UniversalSensorBlockEntity)this.te).sensorStatus.getTranslationKey(), new Object[0]));
        }
    }
}

