/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.programmer.AbstractProgWidgetScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRadioButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDroneCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDroneConditionEnergy;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDroneConditionFluid;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDroneConditionItem;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDroneConditionPressure;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDroneConditionUpgrades;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public abstract class ProgWidgetDroneConditionScreen<T extends ProgWidgetDroneCondition>
extends AbstractProgWidgetScreen<T> {
    private WidgetTextFieldNumber textField;

    ProgWidgetDroneConditionScreen(T progWidget, ProgrammerScreen guiProgrammer) {
        super(progWidget, guiProgrammer);
    }

    @Override
    public void init() {
        int baseY;
        super.init();
        Direction[] directionArray = this.progWidget;
        if (directionArray instanceof ISidedWidget) {
            ISidedWidget sided = (ISidedWidget)directionArray;
            for (Direction dir : DirectionUtil.VALUES) {
                Component sideName = ClientUtils.translateDirectionComponent(dir);
                WidgetCheckBox checkBox = new WidgetCheckBox(this.guiLeft + 8, this.guiTop + 30 + dir.get3DDataValue() * 12, -12566464, sideName, b -> sided.setSideSelected(dir, b.checked));
                checkBox.checked = sided.isSideSelected(dir);
                this.addRenderableWidget((GuiEventListener)checkBox);
            }
        }
        int baseX = this.isSidedWidget() ? 94 : 8;
        int n = baseY = this.isUsingAndOr() ? 60 : 30;
        if (this.isUsingAndOr()) {
            WidgetRadioButton.Builder.create().addRadioButton(new WidgetRadioButton(this.guiLeft + baseX, this.guiTop + 30, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.anyBlock", new Object[0]), b -> ((ProgWidgetDroneCondition)this.progWidget).setAndFunction(false)), !((ProgWidgetDroneCondition)this.progWidget).isAndFunction()).addRadioButton(new WidgetRadioButton(this.guiLeft + baseX, this.guiTop + 42, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.allBlocks", new Object[0]), b -> ((ProgWidgetDroneCondition)this.progWidget).setAndFunction(true)), ((ProgWidgetDroneCondition)this.progWidget).isAndFunction()).build(x$0 -> {
                WidgetRadioButton cfr_ignored_0 = (WidgetRadioButton)this.addRenderableWidget((GuiEventListener)x$0);
            });
        }
        if (this.requiresNumber()) {
            WidgetRadioButton.Builder<WidgetRadioButton> builder = WidgetRadioButton.Builder.create();
            for (ICondition.Operator op : ICondition.Operator.values()) {
                builder.addRadioButton(new WidgetRadioButton(this.guiLeft + baseX, this.guiTop + baseY + op.ordinal() * 12, -12566464, (Component)Component.literal((String)op.toString()), b -> ((ProgWidgetDroneCondition)this.progWidget).setOperator(op)), ((ProgWidgetDroneCondition)this.progWidget).getOperator() == op);
            }
            builder.build(x$0 -> {
                WidgetRadioButton cfr_ignored_0 = (WidgetRadioButton)this.addRenderableWidget((GuiEventListener)x$0);
            });
            Objects.requireNonNull(this.font);
            this.textField = new WidgetTextFieldNumber(this.font, this.guiLeft + baseX, this.guiTop + baseY + 40, 50, 9 + 3).setRange(0, Integer.MAX_VALUE);
            this.textField.setValue("" + ((ProgWidgetDroneCondition)this.progWidget).getRequiredCount());
            this.textField.setMaxLength(64);
            this.textField.setResponder(s -> ((ProgWidgetDroneCondition)this.progWidget).setRequiredCount(this.textField.getIntValue()));
            this.addRenderableWidget((GuiEventListener)this.textField);
            this.setInitialFocus((GuiEventListener)this.textField);
        }
        WidgetLabel label = (WidgetLabel)((Object)this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.measure", new Object[0]), this.guiLeft + 8, this.guiTop + 152).setTooltipKey("pneumaticcraft.gui.progWidget.condition.measure.tooltip"));
        WidgetComboBox measureTextField = new WidgetComboBox(this.font, this.guiLeft + label.getWidth() + 8, this.guiTop + 150, 80, 11);
        measureTextField.setElements(((ProgrammerBlockEntity)this.guiProgrammer.te).getAllVariables());
        measureTextField.setValue(((ProgWidgetDroneCondition)this.progWidget).getMeasureVar());
        measureTextField.setResponder(((ProgWidgetDroneCondition)this.progWidget)::setMeasureVar);
        this.addRenderableWidget((GuiEventListener)measureTextField);
    }

    protected boolean isSidedWidget() {
        return this.progWidget instanceof ISidedWidget;
    }

    protected boolean isUsingAndOr() {
        return false;
    }

    protected boolean requiresNumber() {
        return true;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.isSidedWidget()) {
            graphics.drawString(this.font, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.inventory.accessingSides", new Object[0]), this.guiLeft + 4, this.guiTop + 20, -12566432, false);
        }
        Component s = ((ProgWidgetDroneCondition)this.progWidget).getExtraStringInfo().get(0);
        graphics.drawString(this.font, s, this.guiLeft + this.xSize / 2 - this.font.width((FormattedText)s) / 2, this.guiTop + 120, -12566432, false);
    }

    public static class Upgrades
    extends ProgWidgetDroneConditionScreen<ProgWidgetDroneConditionUpgrades> {
        public Upgrades(ProgWidgetDroneConditionUpgrades widget, ProgrammerScreen guiProgrammer) {
            super(widget, guiProgrammer);
        }
    }

    public static class Energy
    extends ProgWidgetDroneConditionScreen<ProgWidgetDroneConditionEnergy> {
        public Energy(ProgWidgetDroneConditionEnergy progWidget, ProgrammerScreen guiProgrammer) {
            super(progWidget, guiProgrammer);
        }
    }

    public static class Pressure
    extends ProgWidgetDroneConditionScreen<ProgWidgetDroneConditionPressure> {
        public Pressure(ProgWidgetDroneConditionPressure progWidget, ProgrammerScreen guiProgrammer) {
            super(progWidget, guiProgrammer);
        }
    }

    public static class Fluid
    extends ProgWidgetDroneConditionScreen<ProgWidgetDroneConditionFluid> {
        public Fluid(ProgWidgetDroneConditionFluid progWidget, ProgrammerScreen guiProgrammer) {
            super(progWidget, guiProgrammer);
        }
    }

    public static class Item
    extends ProgWidgetDroneConditionScreen<ProgWidgetDroneConditionItem> {
        public Item(ProgWidgetDroneConditionItem progWidget, ProgrammerScreen guiProgrammer) {
            super(progWidget, guiProgrammer);
        }
    }
}

