/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.elevator;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.ElevatorBaseBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.elevator.ElevatorCallerBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.event.MiscEventHandler;
import me.desht.pneumaticcraft.common.inventory.ElevatorMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class ElevatorBaseBlockEntity
extends AbstractAirHandlingBlockEntity
implements IGUITextFieldSensitive,
IRedstoneControl<ElevatorBaseBlockEntity>,
IMinWorkingPressure,
CamouflageableBlockEntity,
MenuProvider {
    private static final List<RedstoneController.RedstoneMode<ElevatorBaseBlockEntity>> REDSTONE_LABELS = ImmutableList.of(new RedstoneController.ReceivingRedstoneMode<ElevatorBaseBlockEntity>("elevator.redstone", new ItemStack((ItemLike)Items.REDSTONE), te -> true), new RedstoneController.ReceivingRedstoneMode<ElevatorBaseBlockEntity>("elevator.caller", new ItemStack((ItemLike)ModBlocks.ELEVATOR_CALLER.get()), te -> true));
    private static final float BUTTON_HEIGHT = 0.06f;
    private static final float BUTTON_SPACING = 0.02f;
    private static final byte RS_REDSTONE_MODE = 0;
    private static final byte RS_CALLER_MODE = 1;
    @DescSynced
    @LazySynced
    public double extension;
    @DescSynced
    private double targetExtension;
    @DescSynced
    double syncedSpeedMult;
    @DescSynced
    public int multiElevatorCount;
    @GuiSynced
    private final RedstoneController<ElevatorBaseBlockEntity> rsController = new RedstoneController<ElevatorBaseBlockEntity>(this, REDSTONE_LABELS);
    @GuiSynced
    private int maxFloorHeight;
    @DescSynced
    private int chargingUpgrades;
    public double oldExtension;
    private boolean isStopped = true;
    private ElevatorBaseBlockEntity coreElevator;
    private List<ElevatorBaseBlockEntity> multiElevators;
    public int[] floorHeights = new int[0];
    private Int2ObjectMap<String> floorNames = new Int2ObjectOpenHashMap();
    private int redstoneInputLevel = -1;
    private BlockState camoState;
    private BlockState prevCamoState;
    public int ticksRunning;
    private final IntList floorList = new IntArrayList();
    private final List<BlockPos> callerList = new ArrayList<BlockPos>();
    private long lastFloorUpdate = 0L;
    public float[] fakeFloorTextureUV;
    public int fakeFloorTextureTint;
    public int lightAbove;

    public ElevatorBaseBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.ELEVATOR_BASE.get(), pos, state, PressureTier.TIER_ONE, 10000, 4);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public void tickCommonPre() {
        double speedMultiplier;
        this.oldExtension = this.extension;
        super.tickCommonPre();
        if (!this.isCoreElevator()) {
            this.extension = 0.0;
            return;
        }
        if (!this.nonNullLevel().isClientSide) {
            if (this.isControlledByRedstone()) {
                this.handleRedstoneControl();
            }
            speedMultiplier = this.syncedSpeedMult = (double)this.getSpeedMultiplierFromUpgrades();
            this.chargingUpgrades = this.getUpgrades(ModUpgrades.CHARGING.get());
            MiscEventHandler.needsTPSSync(this.getLevel());
        } else {
            speedMultiplier = (float)(this.syncedSpeedMult * PacketServerTickTime.getTickTimeMultiplier());
            if (this.prevCamoState != this.camoState) {
                int n;
                this.fakeFloorTextureUV = ClientUtils.getTextureUV(this.camoState, Direction.UP);
                Block block = this.camoState.getBlock();
                if (block instanceof ColorHandlers.ITintableBlock) {
                    ColorHandlers.ITintableBlock t = (ColorHandlers.ITintableBlock)block;
                    n = 0xFF000000 | t.getTintColor(this.camoState, (BlockAndTintGetter)this.level, this.getBlockPos(), 0);
                } else {
                    n = -1;
                }
                this.fakeFloorTextureTint = n;
                this.prevCamoState = this.camoState;
            }
            if ((this.nonNullLevel().getGameTime() & 0xFL) == 0L) {
                this.lightAbove = ClientUtils.getLightAt(this.worldPosition.above());
            }
        }
        if (this.extension < this.targetExtension) {
            if (!this.nonNullLevel().isClientSide && this.getPressure() < 3.0f) {
                this.targetExtension = this.extension;
            }
            double moveBy = this.extension < this.targetExtension - 0.5 ? (double)0.05f * speedMultiplier : (double)0.02f * speedMultiplier;
            this.extension = Math.min(this.targetExtension, this.extension + moveBy);
            this.addAir((int)((this.oldExtension - this.extension) * 300.0 * ((double)this.getSpeedUsageMultiplierFromUpgrades() / speedMultiplier)));
        } else if (this.extension > this.targetExtension) {
            double chargingSlowdown = 1.0 - (double)this.chargingUpgrades * 0.1;
            double moveBy = this.extension > this.targetExtension + 0.5 ? (double)0.05f * speedMultiplier * chargingSlowdown : (double)0.02f * speedMultiplier * chargingSlowdown;
            this.extension = Math.max(this.targetExtension, this.extension - moveBy);
            if (!this.nonNullLevel().isClientSide && this.chargingUpgrades > 0 && this.getPressure() < this.airHandler.getDangerPressure() - 0.1f) {
                float mul = 0.15f * (float)Math.min(4, this.chargingUpgrades);
                this.addAir((int)((this.oldExtension - this.extension) * 300.0 * (double)mul * ((double)this.getSpeedUsageMultiplierFromUpgrades() / speedMultiplier)));
            }
        }
        if (PneumaticCraftUtils.epsilonEquals(this.oldExtension, this.extension) && !this.isStopped) {
            this.isStopped = true;
            this.ticksRunning = 0;
            this.playStopStartSound();
            if (!this.nonNullLevel().isClientSide) {
                this.updateFloors(false);
            }
        } else if (!PneumaticCraftUtils.epsilonEquals(this.oldExtension, this.extension) && this.isStopped) {
            this.isStopped = false;
            this.playStopStartSound();
        }
        if (!this.isStopped) {
            ++this.ticksRunning;
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.connectAsMultiblock();
    }

    private void playStopStartSound() {
        if (this.shouldPlaySounds()) {
            if (this.nonNullLevel().isClientSide()) {
                this.nonNullLevel().playLocalSound((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + this.extension, (double)this.getBlockPos().getZ() + 0.5, this.isStopped ? (SoundEvent)ModSounds.ELEVATOR_RISING_STOP.get() : (SoundEvent)ModSounds.ELEVATOR_RISING_START.get(), SoundSource.BLOCKS, ((Double)ConfigHelper.client().sound.elevatorVolumeStartStop.get()).floatValue(), 1.0f, true);
            } else if (!this.isStopped) {
                NetworkHandler.sendToAllTracking((CustomPacketPayload)new PacketPlayMovingSound(MovingSounds.Sound.ELEVATOR, PacketPlayMovingSound.MovingSoundFocus.of(this.getCoreElevator())), this);
            }
        }
    }

    private boolean shouldPlaySounds() {
        return !(this.getCachedNeighbor(Direction.EAST) instanceof ElevatorBaseBlockEntity) && !(this.getCachedNeighbor(Direction.SOUTH) instanceof ElevatorBaseBlockEntity);
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    private void handleRedstoneControl() {
        double oldTargetExtension = this.targetExtension;
        float maxExtension = this.getMaxElevatorHeight();
        int redstoneInput = this.getRedstoneInputLevel();
        if (this.multiElevators != null) {
            for (ElevatorBaseBlockEntity base : this.multiElevators) {
                redstoneInput = Math.max(redstoneInput, base.getRedstoneInputLevel());
            }
        }
        this.targetExtension = (float)redstoneInput * maxExtension / 15.0f;
        if (this.targetExtension > this.oldExtension && this.getPressure() < 3.0f) {
            this.targetExtension = this.oldExtension;
        }
        if (oldTargetExtension != this.targetExtension) {
            this.sendDescPacketFromAllElevators();
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public void onRedstoneModeChanged(int newModeIdx) {
        if (this.multiElevators != null) {
            for (ElevatorBaseBlockEntity base : this.multiElevators) {
                base.getRedstoneController().setCurrentMode(newModeIdx);
            }
        }
        int i = -1;
        BlockEntity te = this.nonNullLevel().getBlockEntity(this.getBlockPos().relative(Direction.DOWN));
        while (te instanceof ElevatorBaseBlockEntity) {
            ElevatorBaseBlockEntity elevator = (ElevatorBaseBlockEntity)te;
            elevator.getRedstoneController().setCurrentMode(newModeIdx);
            te = this.nonNullLevel().getBlockEntity(this.getBlockPos().offset(0, --i, 0));
        }
    }

    private boolean isControlledByRedstone() {
        return this.getRedstoneController().getCurrentMode() == 0;
    }

    private int getRedstoneInputLevel() {
        if (this.redstoneInputLevel < 0) {
            this.updateRedstoneInputLevel();
        }
        return this.redstoneInputLevel;
    }

    private void updateRedstoneInputLevel() {
        if (this.multiElevators == null) {
            return;
        }
        int maxRedstone = this.getMaxRedstone();
        for (ElevatorBaseBlockEntity base : this.multiElevators) {
            base.redstoneInputLevel = maxRedstone;
        }
    }

    private int getMaxRedstone() {
        int maxRedstone = 0;
        for (ElevatorBaseBlockEntity base : this.multiElevators) {
            BlockPos.MutableBlockPos pos1 = base.getBlockPos().mutable();
            while (this.nonNullLevel().getBlockState((BlockPos)pos1).getBlock() == ModBlocks.ELEVATOR_BASE.get()) {
                if ((maxRedstone = Math.max(maxRedstone, this.nonNullLevel().getBestNeighborSignal((BlockPos)pos1))) == 15) {
                    return 15;
                }
                pos1.move(Direction.DOWN);
            }
        }
        return maxRedstone;
    }

    public float getMaxElevatorHeight() {
        int max = this.maxFloorHeight;
        if (this.multiElevators != null) {
            for (ElevatorBaseBlockEntity base : this.multiElevators) {
                max = Math.min(max, base.maxFloorHeight);
            }
        }
        return max;
    }

    public void updateMaxElevatorHeight() {
        int i = -1;
        while (this.nonNullLevel().getBlockState(this.getBlockPos().offset(0, ++i + 1, 0)).getBlock() == ModBlocks.ELEVATOR_FRAME.get()) {
        }
        int elevatorBases = 0;
        while (this.nonNullLevel().getBlockState(this.getBlockPos().offset(0, -(++elevatorBases), 0)).getBlock() == ModBlocks.ELEVATOR_BASE.get()) {
        }
        this.maxFloorHeight = Math.min(i, elevatorBases * (Integer)ConfigHelper.common().machines.elevatorBaseBlocksPerBase.get());
        this.setChanged();
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("extensionD")) {
            this.extension = tag.getDouble("extensionD");
            this.targetExtension = tag.getDouble("targetExtensionD");
        } else {
            this.extension = tag.getFloat("extension");
            this.targetExtension = tag.getFloat("targetExtension");
        }
        this.maxFloorHeight = tag.getInt("maxFloorHeight");
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putDouble("extensionD", this.extension);
        tag.putDouble("targetExtensionD", this.targetExtension);
        tag.putInt("maxFloorHeight", this.maxFloorHeight);
    }

    @Override
    public void readFromPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.readFromPacket(tag, provider);
        this.camoState = CamouflageableBlockEntity.readCamo(tag);
        this.floorHeights = tag.getIntArray("floorHeights");
        this.floorNames.clear();
        ListTag floorNameList = tag.getList("floorNames", 10);
        for (int i = 0; i < floorNameList.size(); ++i) {
            CompoundTag floorName = floorNameList.getCompound(i);
            this.floorNames.put(floorName.getInt("floorHeight"), (Object)floorName.getString("floorName"));
        }
    }

    @Override
    public void writeToPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeToPacket(tag, provider);
        CamouflageableBlockEntity.writeCamo(tag, this.camoState);
        tag.putIntArray("floorHeights", this.floorHeights);
        ListTag floorNameList = new ListTag();
        this.floorNames.forEach((height, name) -> {
            CompoundTag floorNameTag = new CompoundTag();
            floorNameTag.putInt("floorHeight", height.intValue());
            floorNameTag.putString("floorName", name);
            floorNameList.add((Object)floorNameTag);
        });
        tag.put("floorNames", (Tag)floorNameList);
    }

    private void connectAsMultiblock() {
        this.multiElevators = null;
        if (this.isCoreElevator()) {
            this.multiElevators = new ArrayList<ElevatorBaseBlockEntity>();
            Stack<ElevatorBaseBlockEntity> todo = new Stack<ElevatorBaseBlockEntity>();
            todo.add(this);
            while (!todo.isEmpty()) {
                ElevatorBaseBlockEntity curElevator = (ElevatorBaseBlockEntity)todo.pop();
                if (!curElevator.isCoreElevator() || this.multiElevators.contains(curElevator)) continue;
                this.multiElevators.add(curElevator);
                curElevator.multiElevators = this.multiElevators;
                for (Direction face : DirectionUtil.HORIZONTALS) {
                    BlockEntity te = curElevator.getCachedNeighbor(face);
                    if (!(te instanceof ElevatorBaseBlockEntity) || te.isRemoved()) continue;
                    todo.push((ElevatorBaseBlockEntity)te);
                }
            }
            this.multiElevatorCount = this.multiElevators.size();
        }
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        this.getCoreElevator().updateRedstoneInputLevel();
        this.connectAsMultiblock();
        this.updateConnections();
    }

    private void updateConnections() {
        this.coreElevator = this.nonNullLevel().getBlockState(this.getBlockPos().above()).getBlock() != ModBlocks.ELEVATOR_BASE.get() ? this : null;
    }

    public void moveUpgradesFromAbove() {
        BlockEntity brokenTE = this.nonNullLevel().getBlockEntity(this.getBlockPos().relative(Direction.UP));
        if (brokenTE instanceof ElevatorBaseBlockEntity) {
            this.camoState = ((ElevatorBaseBlockEntity)brokenTE).camoState;
            this.sendDescriptionPacket();
            for (int i = 0; i < this.getUpgradeHandler().getSlots(); ++i) {
                ItemStack stack = ((ElevatorBaseBlockEntity)brokenTE).getUpgradeHandler().getStackInSlot(i);
                ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.getUpgradeHandler(), (ItemStack)stack, (boolean)false);
                if (!excess.isEmpty()) {
                    PneumaticCraftUtils.dropItemOnGround(excess, this.level, this.getBlockPos());
                }
                ((ElevatorBaseBlockEntity)brokenTE).getUpgradeHandler().setStackInSlot(i, ItemStack.EMPTY);
            }
        }
    }

    public void updateFloors(boolean notifyClient) {
        Level level = this.nonNullLevel();
        if (level.getGameTime() - this.lastFloorUpdate > 20L) {
            this.callerList.clear();
            this.floorList.clear();
            if (this.multiElevators != null) {
                int yOffset = 0;
                int worldHeight = level.dimensionType().logicalHeight();
                BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
                block0: while (this.worldPosition.getY() + yOffset < worldHeight - 2) {
                    boolean registeredThisFloor = false;
                    for (ElevatorBaseBlockEntity base : this.multiElevators) {
                        for (Direction dir : DirectionUtil.HORIZONTALS) {
                            mut.set((Vec3i)base.getBlockPos());
                            mut.move(dir.getStepX(), yOffset + 2, dir.getStepZ());
                            if (base.nonNullLevel().getBlockState((BlockPos)mut).getBlock() != ModBlocks.ELEVATOR_CALLER.get()) continue;
                            this.callerList.add(mut.immutable());
                            if (!registeredThisFloor) {
                                this.floorList.add(yOffset);
                            }
                            registeredThisFloor = true;
                        }
                    }
                    ++yOffset;
                    for (ElevatorBaseBlockEntity base : this.multiElevators) {
                        if (base.nonNullLevel().getBlockState(base.getBlockPos().above(yOffset)).getBlock() == ModBlocks.ELEVATOR_FRAME.get()) continue;
                        break block0;
                    }
                }
                for (ElevatorBaseBlockEntity base : this.multiElevators) {
                    base.floorHeights = this.floorList.intStream().toArray();
                }
            }
            this.lastFloorUpdate = level.getGameTime();
        }
        ElevatorCallerBlockEntity.ElevatorButton[] elevatorButtons = new ElevatorCallerBlockEntity.ElevatorButton[this.floorHeights.length];
        int columns = (elevatorButtons.length - 1) / 12 + 1;
        for (int j = 0; j < columns; ++j) {
            for (int i = j * 12; i < this.floorHeights.length && i < j * 12 + 12; ++i) {
                elevatorButtons[i] = new ElevatorCallerBlockEntity.ElevatorButton(0.2f + 0.6f / (float)columns * (float)j, 0.5f + (float)(Math.min(this.floorHeights.length, 12) - 2) * 0.08f / 2.0f - (float)(i % 12) * 0.08f, 0.58f / (float)columns, 0.06f, i, this.floorHeights[i]);
                elevatorButtons[i].setColor((double)this.floorHeights[i] == this.targetExtension ? 0.0f : 1.0f, 1.0f, (double)this.floorHeights[i] == this.targetExtension ? 0.0f : 1.0f);
                String floorName = (String)this.floorNames.get(this.floorHeights[i]);
                if (floorName != null) {
                    elevatorButtons[i].buttonText = floorName;
                    continue;
                }
                this.floorNames.put(this.floorHeights[i], (Object)elevatorButtons[i].buttonText);
            }
        }
        if (this.multiElevators != null) {
            for (ElevatorBaseBlockEntity base : this.multiElevators) {
                base.floorNames = new Int2ObjectOpenHashMap(this.floorNames);
            }
        }
        for (BlockPos p : this.callerList) {
            BlockEntity te = level.getBlockEntity(p);
            if (!(te instanceof ElevatorCallerBlockEntity)) continue;
            ElevatorCallerBlockEntity caller = (ElevatorCallerBlockEntity)te;
            int callerFloorHeight = p.getY() - this.getBlockPos().getY() - 2;
            int callerFloor = -1;
            for (ElevatorCallerBlockEntity.ElevatorButton floor : elevatorButtons) {
                if (floor.floorHeight != callerFloorHeight) continue;
                callerFloor = floor.floorNumber;
                break;
            }
            if (callerFloor == -1) {
                Log.error("Error while updating elevator floors! This will cause a indexOutOfBoundsException, index = -1", new Object[0]);
            }
            caller.setEmittingRedstone(PneumaticCraftUtils.epsilonEquals(this.targetExtension, this.extension, 0.1) && PneumaticCraftUtils.epsilonEquals(this.extension, (double)callerFloorHeight, 0.1));
            caller.setFloors(elevatorButtons, callerFloor);
        }
        if (notifyClient && !level.isClientSide) {
            this.sendDescPacketFromAllElevators();
        }
    }

    public void goToFloor(int floor) {
        if (this.getCoreElevator().isControlledByRedstone()) {
            this.getCoreElevator().getRedstoneController().setCurrentMode(1);
        }
        if (floor >= 0 && floor < this.floorHeights.length) {
            this.setTargetHeight(this.floorHeights[floor]);
        }
        this.updateFloors(false);
        this.sendDescPacketFromAllElevators();
    }

    private void setTargetHeight(float height) {
        height = Math.min(height, this.getMaxElevatorHeight());
        if (this.multiElevators != null) {
            for (ElevatorBaseBlockEntity base : this.multiElevators) {
                base.targetExtension = height;
            }
        }
    }

    public double getTargetExtension() {
        return this.targetExtension;
    }

    private void sendDescPacketFromAllElevators() {
        if (this.multiElevators != null) {
            for (ElevatorBaseBlockEntity base : this.multiElevators) {
                base.sendDescriptionPacket();
            }
        } else {
            this.sendDescriptionPacket();
        }
    }

    private ElevatorBaseBlockEntity getCoreElevator() {
        if (this.coreElevator == null || this.nonNullLevel().isClientSide && (this.nonNullLevel().getGameTime() & 0x3FL) == 0L) {
            this.coreElevator = ElevatorBaseBlock.getCoreBlockEntity(this.nonNullLevel(), this.getBlockPos()).orElse(null);
        }
        return this.coreElevator;
    }

    public boolean isCoreElevator() {
        return this.getCoreElevator() == this;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP || this.nonNullLevel().getBlockState(this.worldPosition.relative(side)).getBlock() == ModBlocks.ELEVATOR_BASE.get();
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.setFloorName(textFieldID, text);
    }

    @Override
    public String getText(int textFieldID) {
        return this.getFloorName(textFieldID);
    }

    public String getFloorName(int floor) {
        return floor < this.floorHeights.length ? (String)this.floorNames.get(this.floorHeights[floor]) : "";
    }

    public void setFloorName(int floor, String name) {
        if (floor < this.floorHeights.length) {
            this.floorNames.put(this.floorHeights[floor], (Object)name);
            this.updateFloors(true);
        }
    }

    @Override
    public boolean isGuiUseableByPlayer(Player par1EntityPlayer) {
        return this.nonNullLevel().getBlockEntity(this.getBlockPos()) == this;
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("setHeight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "height (in blocks)");
                ElevatorBaseBlockEntity.this.setTargetHeight(((Double)args[0]).floatValue());
                if (ElevatorBaseBlockEntity.this.getCoreElevator().isControlledByRedstone()) {
                    ElevatorBaseBlockEntity.this.getCoreElevator().getRedstoneController().setCurrentMode(1);
                }
                ElevatorBaseBlockEntity.this.getCoreElevator().sendDescPacketFromAllElevators();
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getCurrentHeight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{ElevatorBaseBlockEntity.this.getCoreElevator().extension};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getTargetHeight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{ElevatorBaseBlockEntity.this.getCoreElevator().targetExtension};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getVelocity"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{ElevatorBaseBlockEntity.this.getCoreElevator().extension - ElevatorBaseBlockEntity.this.getCoreElevator().oldExtension};
            }
        });
        registry.registerLuaMethod(new LuaMethod("setExternalControl"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "true/false");
                if (((Boolean)args[0]).booleanValue() && ElevatorBaseBlockEntity.this.getCoreElevator().isControlledByRedstone() || !((Boolean)args[0]).booleanValue() && !ElevatorBaseBlockEntity.this.getCoreElevator().isControlledByRedstone()) {
                    ElevatorBaseBlockEntity.this.getCoreElevator().getRedstoneController().setCurrentMode(1);
                }
                return null;
            }
        });
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    @Override
    public RedstoneController<ElevatorBaseBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.0f;
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        CamouflageableBlockEntity.syncToClient(this);
    }

    @Override
    public MutableComponent getRedstoneTabTitle() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.redstoneBehaviour.elevator.controlBy", new Object[0]);
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new ElevatorMenu(i, playerInventory, this.getBlockPos());
    }
}

