/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICraftingWidget;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ItemTagMatcher;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerDestroyItemEvent;
import net.neoforged.neoforge.items.IItemHandler;

public class DroneAICrafting
extends Goal {
    private final ICraftingWidget widget;
    private final IDrone drone;
    private final int maxActions;
    private int actionCount;

    public DroneAICrafting(IDrone drone, ICraftingWidget widget) {
        this.drone = drone;
        this.widget = widget;
        this.maxActions = widget.useCount() ? widget.getCount() : 0;
        this.actionCount = 0;
    }

    public boolean canUse() {
        if (this.maxActions > 0 && this.actionCount >= this.maxActions) {
            return false;
        }
        CraftingInput craftingGrid = this.widget.getCraftingGrid();
        return this.widget.getRecipe(this.drone.getDroneLevel(), craftingGrid).map(recipe -> {
            List<List<ItemStack>> equivalentsList = this.buildEquivalentsList(craftingGrid);
            if (equivalentsList.isEmpty()) {
                return false;
            }
            int[] equivIndices = new int[9];
            do {
                NonNullList stacks = NonNullList.withSize((int)equivalentsList.size(), (Object)ItemStack.EMPTY);
                for (int i = 0; i < equivalentsList.size(); ++i) {
                    ItemStack stack = equivalentsList.get(i).isEmpty() ? ItemStack.EMPTY : equivalentsList.get(i).get(equivIndices[i]);
                    stacks.set(i, (Object)stack);
                }
                CraftingInput input = CraftingInput.of((int)3, (int)3, (List)stacks);
                if (!recipe.matches((RecipeInput)input, this.drone.getDroneLevel()) || !this.doCrafting(recipe.assemble((RecipeInput)input, (HolderLookup.Provider)this.drone.getDroneLevel().registryAccess()), input)) continue;
                ++this.actionCount;
                return true;
            } while (this.count(equivIndices, equivalentsList));
            return false;
        }).orElse(false);
    }

    private List<List<ItemStack>> buildEquivalentsList(CraftingInput craftingGrid) {
        ArrayList<List<ItemStack>> equivalentsList = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < craftingGrid.size(); ++i) {
            equivalentsList.add(new ArrayList());
            ItemStack recipeStack = craftingGrid.getItem(i);
            if (recipeStack.isEmpty()) continue;
            ArrayList<ItemStack> equivalents = new ArrayList<ItemStack>();
            for (int j = 0; j < this.drone.getInv().getSlots(); ++j) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(j);
                if (droneStack.isEmpty() || droneStack.getItem() != recipeStack.getItem() && !ItemTagMatcher.matchTags(droneStack, recipeStack)) continue;
                equivalents.add(droneStack);
            }
            if (equivalents.isEmpty()) {
                return Collections.emptyList();
            }
            ((List)equivalentsList.get(i)).addAll(equivalents);
        }
        return equivalentsList;
    }

    private boolean count(int[] curIndexes, List<List<ItemStack>> equivalentsList) {
        for (int i = 0; i < equivalentsList.size(); ++i) {
            List<ItemStack> list = equivalentsList.get(i);
            int n = i;
            curIndexes[n] = curIndexes[n] + 1;
            if (!list.isEmpty() && curIndexes[i] < list.size()) {
                return true;
            }
            curIndexes[i] = 0;
        }
        return false;
    }

    public boolean doCrafting(ItemStack craftedStack, CraftingInput craftMatrix) {
        int i;
        for (i = 0; i < craftMatrix.size(); ++i) {
            int requiredCount = 0;
            ItemStack stack = craftMatrix.getItem(i);
            if (stack.isEmpty()) continue;
            for (int j = 0; j < craftMatrix.size(); ++j) {
                if (stack != craftMatrix.getItem(j)) continue;
                ++requiredCount;
            }
            if (requiredCount <= stack.getCount()) continue;
            return false;
        }
        EventHooks.firePlayerCraftingEvent((Player)this.drone.getFakePlayer(), (ItemStack)craftedStack, (Container)new SimpleContainer(craftMatrix.items().toArray(new ItemStack[0])));
        for (i = 0; i < craftMatrix.size(); ++i) {
            ItemStack stack = craftMatrix.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem().hasCraftingRemainingItem(stack)) {
                ItemStack containerItem = stack.getItem().getCraftingRemainingItem(stack);
                if (!containerItem.isEmpty() && containerItem.isDamageableItem() && containerItem.getDamageValue() > containerItem.getMaxDamage()) {
                    NeoForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent((Player)this.drone.getFakePlayer(), containerItem, InteractionHand.MAIN_HAND));
                    continue;
                }
                IOHelper.insertOrDrop(this.drone.getDroneLevel(), containerItem, (IItemHandler)this.drone.getInv(), this.drone.getDronePos(), false);
            }
            stack.shrink(1);
        }
        for (i = 0; i < this.drone.getInv().getSlots(); ++i) {
            ItemStack stack = this.drone.getInv().getStackInSlot(i);
            if (stack.getCount() > 0) continue;
            this.drone.getInv().setStackInSlot(i, ItemStack.EMPTY);
        }
        IOHelper.insertOrDrop(this.drone.getDroneLevel(), craftedStack, (IItemHandler)this.drone.getInv(), this.drone.getDronePos(), false);
        return true;
    }
}

